// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * Flag the presence or absence of periods of silence in your Call Analytics transcription output.
 *
 * Rules using `NonTalkTimeFilter` are designed to match:
 * + The presence of silence at specified periods throughout the call
 * + The presence of speech at specified periods throughout the call
 *
 * See [Rule criteria](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html#call-analytics-create-categories-rules) for usage examples.
 */
public class NonTalkTimeFilter private constructor(builder: Builder) {
    /**
     * Allows you to specify a time range (in milliseconds) in your audio, during which you want to search for a period of silence. See for more detail.
     */
    public val absoluteTimeRange: aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange? = builder.absoluteTimeRange
    /**
     * Set to `TRUE` to flag periods of speech. Set to `FALSE` to flag periods of silence
     */
    public val negate: kotlin.Boolean? = builder.negate
    /**
     * Allows you to specify a time range (in percentage) in your media file, during which you want to search for a period of silence. See for more detail.
     */
    public val relativeTimeRange: aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange? = builder.relativeTimeRange
    /**
     * Specify the duration, in milliseconds, of the period of silence you want to flag. For example, you can flag a silent period that lasts 30000 milliseconds.
     */
    public val threshold: kotlin.Long? = builder.threshold

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.NonTalkTimeFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NonTalkTimeFilter(")
        append("absoluteTimeRange=$absoluteTimeRange,")
        append("negate=$negate,")
        append("relativeTimeRange=$relativeTimeRange,")
        append("threshold=$threshold)")
    }

    override fun hashCode(): kotlin.Int {
        var result = absoluteTimeRange?.hashCode() ?: 0
        result = 31 * result + (negate?.hashCode() ?: 0)
        result = 31 * result + (relativeTimeRange?.hashCode() ?: 0)
        result = 31 * result + (threshold?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NonTalkTimeFilter

        if (absoluteTimeRange != other.absoluteTimeRange) return false
        if (negate != other.negate) return false
        if (relativeTimeRange != other.relativeTimeRange) return false
        if (threshold != other.threshold) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.NonTalkTimeFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Allows you to specify a time range (in milliseconds) in your audio, during which you want to search for a period of silence. See for more detail.
         */
        public var absoluteTimeRange: aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange? = null
        /**
         * Set to `TRUE` to flag periods of speech. Set to `FALSE` to flag periods of silence
         */
        public var negate: kotlin.Boolean? = null
        /**
         * Allows you to specify a time range (in percentage) in your media file, during which you want to search for a period of silence. See for more detail.
         */
        public var relativeTimeRange: aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange? = null
        /**
         * Specify the duration, in milliseconds, of the period of silence you want to flag. For example, you can flag a silent period that lasts 30000 milliseconds.
         */
        public var threshold: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.NonTalkTimeFilter) : this() {
            this.absoluteTimeRange = x.absoluteTimeRange
            this.negate = x.negate
            this.relativeTimeRange = x.relativeTimeRange
            this.threshold = x.threshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.NonTalkTimeFilter = NonTalkTimeFilter(this)

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange] inside the given [block]
         */
        public fun absoluteTimeRange(block: aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange.Builder.() -> kotlin.Unit) {
            this.absoluteTimeRange = aws.sdk.kotlin.services.transcribe.model.AbsoluteTimeRange.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange] inside the given [block]
         */
        public fun relativeTimeRange(block: aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange.Builder.() -> kotlin.Unit) {
            this.relativeTimeRange = aws.sdk.kotlin.services.transcribe.model.RelativeTimeRange.invoke(block)
        }
    }
}
