// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * Allows additional optional settings in your request, including channel identification, alternative transcriptions, and speaker labeling; allows you to apply custom vocabularies to your medical transcription job.
 */
public class MedicalTranscriptionSetting private constructor(builder: Builder) {
    /**
     * Enables channel identification in multi-channel audio.
     *
     * Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.
     *
     * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript does not separate the speech by channel.
     *
     * You can't include both `ShowSpeakerLabels` and `ChannelIdentification` in the same request. Including both parameters returns a `BadRequestException`.
     *
     * For more information, see [Transcribing multi-channel audio](https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html).
     */
    public val channelIdentification: kotlin.Boolean? = builder.channelIdentification
    /**
     * Indicate the maximum number of alternative transcriptions you want Amazon Transcribe Medical to include in your transcript.
     *
     * If you select a number greater than the number of alternative transcriptions generated by Amazon Transcribe Medical, only the actual number of alternative transcriptions are included.
     *
     * If you include `MaxAlternatives` in your request, you must also include `ShowAlternatives` with a value of `true`.
     *
     * For more information, see [Alternative transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html).
     */
    public val maxAlternatives: kotlin.Int? = builder.maxAlternatives
    /**
     * Specify the maximum number of speakers you want to identify in your media.
     *
     * Note that if your media contains more speakers than the specified number, multiple speakers will be identified as a single speaker.
     *
     * If you specify the `MaxSpeakerLabels` field, you must set the `ShowSpeakerLabels` field to true.
     */
    public val maxSpeakerLabels: kotlin.Int? = builder.maxSpeakerLabels
    /**
     * To include alternative transcriptions within your transcription output, include `ShowAlternatives` in your transcription request.
     *
     * If you include `ShowAlternatives`, you must also include `MaxAlternatives`, which is the maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.
     *
     * For more information, see [Alternative transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html).
     */
    public val showAlternatives: kotlin.Boolean? = builder.showAlternatives
    /**
     * Enables speaker identification (diarization) in your transcription output. Speaker identification labels the speech from individual speakers in your media file.
     *
     * If you enable `ShowSpeakerLabels` in your request, you must also include `MaxSpeakerLabels`.
     *
     * You can't include both `ShowSpeakerLabels` and `ChannelIdentification` in the same request. Including both parameters returns a `BadRequestException`.
     *
     * For more information, see [Identifying speakers (diarization)](https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html).
     */
    public val showSpeakerLabels: kotlin.Boolean? = builder.showSpeakerLabels
    /**
     * The name of the custom vocabulary you want to use when processing your medical transcription job. Vocabulary names are case sensitive.
     *
     * The language of the specified vocabulary must match the language code you specify in your transcription request. If the languages don't match, the vocabulary isn't applied. There are no errors or warnings associated with a language mismatch. US English (`en-US`) is the only valid language for Amazon Transcribe Medical.
     */
    public val vocabularyName: kotlin.String? = builder.vocabularyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MedicalTranscriptionSetting(")
        append("channelIdentification=$channelIdentification,")
        append("maxAlternatives=$maxAlternatives,")
        append("maxSpeakerLabels=$maxSpeakerLabels,")
        append("showAlternatives=$showAlternatives,")
        append("showSpeakerLabels=$showSpeakerLabels,")
        append("vocabularyName=$vocabularyName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelIdentification?.hashCode() ?: 0
        result = 31 * result + (maxAlternatives ?: 0)
        result = 31 * result + (maxSpeakerLabels ?: 0)
        result = 31 * result + (showAlternatives?.hashCode() ?: 0)
        result = 31 * result + (showSpeakerLabels?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MedicalTranscriptionSetting

        if (channelIdentification != other.channelIdentification) return false
        if (maxAlternatives != other.maxAlternatives) return false
        if (maxSpeakerLabels != other.maxSpeakerLabels) return false
        if (showAlternatives != other.showAlternatives) return false
        if (showSpeakerLabels != other.showSpeakerLabels) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Enables channel identification in multi-channel audio.
         *
         * Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.
         *
         * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript does not separate the speech by channel.
         *
         * You can't include both `ShowSpeakerLabels` and `ChannelIdentification` in the same request. Including both parameters returns a `BadRequestException`.
         *
         * For more information, see [Transcribing multi-channel audio](https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html).
         */
        public var channelIdentification: kotlin.Boolean? = null
        /**
         * Indicate the maximum number of alternative transcriptions you want Amazon Transcribe Medical to include in your transcript.
         *
         * If you select a number greater than the number of alternative transcriptions generated by Amazon Transcribe Medical, only the actual number of alternative transcriptions are included.
         *
         * If you include `MaxAlternatives` in your request, you must also include `ShowAlternatives` with a value of `true`.
         *
         * For more information, see [Alternative transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html).
         */
        public var maxAlternatives: kotlin.Int? = null
        /**
         * Specify the maximum number of speakers you want to identify in your media.
         *
         * Note that if your media contains more speakers than the specified number, multiple speakers will be identified as a single speaker.
         *
         * If you specify the `MaxSpeakerLabels` field, you must set the `ShowSpeakerLabels` field to true.
         */
        public var maxSpeakerLabels: kotlin.Int? = null
        /**
         * To include alternative transcriptions within your transcription output, include `ShowAlternatives` in your transcription request.
         *
         * If you include `ShowAlternatives`, you must also include `MaxAlternatives`, which is the maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.
         *
         * For more information, see [Alternative transcriptions](https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html).
         */
        public var showAlternatives: kotlin.Boolean? = null
        /**
         * Enables speaker identification (diarization) in your transcription output. Speaker identification labels the speech from individual speakers in your media file.
         *
         * If you enable `ShowSpeakerLabels` in your request, you must also include `MaxSpeakerLabels`.
         *
         * You can't include both `ShowSpeakerLabels` and `ChannelIdentification` in the same request. Including both parameters returns a `BadRequestException`.
         *
         * For more information, see [Identifying speakers (diarization)](https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html).
         */
        public var showSpeakerLabels: kotlin.Boolean? = null
        /**
         * The name of the custom vocabulary you want to use when processing your medical transcription job. Vocabulary names are case sensitive.
         *
         * The language of the specified vocabulary must match the language code you specify in your transcription request. If the languages don't match, the vocabulary isn't applied. There are no errors or warnings associated with a language mismatch. US English (`en-US`) is the only valid language for Amazon Transcribe Medical.
         */
        public var vocabularyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting) : this() {
            this.channelIdentification = x.channelIdentification
            this.maxAlternatives = x.maxAlternatives
            this.maxSpeakerLabels = x.maxSpeakerLabels
            this.showAlternatives = x.showAlternatives
            this.showSpeakerLabels = x.showSpeakerLabels
            this.vocabularyName = x.vocabularyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting = MedicalTranscriptionSetting(this)
    }
}
