// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides detailed information about a medical transcription job.
 *
 * To view the status of the specified medical transcription job, check the `TranscriptionJobStatus` field. If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
 */
public class MedicalTranscriptionJob private constructor(builder: Builder) {
    /**
     * The date and time the specified medical transcription job finished processing.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:33:13.922000-07:00` represents a transcription job that started processing at 12:33 PM UTC-7 on May 4, 2022.
     */
    public val completionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completionTime
    /**
     * Labels all personal health information (PHI) identified in your transcript. For more information, see [Identifying personal health information (PHI) in a transcription](https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html).
     */
    public val contentIdentificationType: aws.sdk.kotlin.services.transcribe.model.MedicalContentIdentificationType? = builder.contentIdentificationType
    /**
     * The date and time the specified medical transcription job request was made.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * If `TranscriptionJobStatus` is `FAILED`, `FailureReason` contains information about why the transcription job request failed.
     *
     * The `FailureReason` field contains one of the following values:
     * + `Unsupported media format`.The media format specified in `MediaFormat` isn't valid. Refer to **MediaFormat** for a list of supported formats.
     * + `The media format provided does not match the detected media format`.The media format specified in `MediaFormat` doesn't match the format of the input file. Check the media format of your media file and correct the specified value.
     * + `Invalid sample rate for audio file`.The sample rate specified in `MediaSampleRateHertz` isn't valid. The sample rate must be between 16,000 and 48,000 Hertz.
     * + `The sample rate provided does not match the detected sample rate`.The sample rate specified in `MediaSampleRateHertz` doesn't match the sample rate detected in your input media file. Check the sample rate of your media file and correct the specified value.
     * + `Invalid file size: file size too large`.The size of your media file is larger than what Amazon Transcribe can process. For more information, refer to [Guidelines and quotas](https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits).
     * + `Invalid number of channels: number of channels too large`.Your audio contains more channels than Amazon Transcribe is able to process. For more information, refer to [Guidelines and quotas](https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits).
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The language code used to create your medical transcription job. US English (`en-US`) is the only supported language for medical transcriptions.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = builder.languageCode
    /**
     * Describes the Amazon S3 location of the media file you want to use in your request.
     */
    public val media: aws.sdk.kotlin.services.transcribe.model.Media? = builder.media
    /**
     * The format of the input media file.
     */
    public val mediaFormat: aws.sdk.kotlin.services.transcribe.model.MediaFormat? = builder.mediaFormat
    /**
     * The sample rate, in Hertz, of the audio track in your input media file.
     */
    public val mediaSampleRateHertz: kotlin.Int? = builder.mediaSampleRateHertz
    /**
     * The name of the medical transcription job. Job names are case sensitive and must be unique within an Amazon Web Services account.
     */
    public val medicalTranscriptionJobName: kotlin.String? = builder.medicalTranscriptionJobName
    /**
     * Specify additional optional settings in your request, including channel identification, alternative transcriptions, and speaker labeling; allows you to apply custom vocabularies to your medical transcription job.
     */
    public val settings: aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting? = builder.settings
    /**
     * Describes the medical specialty represented in your media.
     */
    public val specialty: aws.sdk.kotlin.services.transcribe.model.Specialty? = builder.specialty
    /**
     * The date and time the specified medical transcription job began processing.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.789000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The tags, each in the form of a key:value pair, assigned to the specified medical transcription job.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Provides you with the Amazon S3 URI you can use to access your transcript.
     */
    public val transcript: aws.sdk.kotlin.services.transcribe.model.MedicalTranscript? = builder.transcript
    /**
     * Provides the status of the specified medical transcription job.
     *
     * If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     */
    public val transcriptionJobStatus: aws.sdk.kotlin.services.transcribe.model.TranscriptionJobStatus? = builder.transcriptionJobStatus
    /**
     * Indicates whether the input media is a dictation or a conversation, as specified in the `StartMedicalTranscriptionJob` request.
     */
    public val type: aws.sdk.kotlin.services.transcribe.model.Type? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MedicalTranscriptionJob(")
        append("completionTime=$completionTime,")
        append("contentIdentificationType=$contentIdentificationType,")
        append("creationTime=$creationTime,")
        append("failureReason=$failureReason,")
        append("languageCode=$languageCode,")
        append("media=$media,")
        append("mediaFormat=$mediaFormat,")
        append("mediaSampleRateHertz=$mediaSampleRateHertz,")
        append("medicalTranscriptionJobName=$medicalTranscriptionJobName,")
        append("settings=$settings,")
        append("specialty=$specialty,")
        append("startTime=$startTime,")
        append("tags=$tags,")
        append("transcript=$transcript,")
        append("transcriptionJobStatus=$transcriptionJobStatus,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionTime?.hashCode() ?: 0
        result = 31 * result + (contentIdentificationType?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (media?.hashCode() ?: 0)
        result = 31 * result + (mediaFormat?.hashCode() ?: 0)
        result = 31 * result + (mediaSampleRateHertz ?: 0)
        result = 31 * result + (medicalTranscriptionJobName?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        result = 31 * result + (specialty?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transcript?.hashCode() ?: 0)
        result = 31 * result + (transcriptionJobStatus?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MedicalTranscriptionJob

        if (completionTime != other.completionTime) return false
        if (contentIdentificationType != other.contentIdentificationType) return false
        if (creationTime != other.creationTime) return false
        if (failureReason != other.failureReason) return false
        if (languageCode != other.languageCode) return false
        if (media != other.media) return false
        if (mediaFormat != other.mediaFormat) return false
        if (mediaSampleRateHertz != other.mediaSampleRateHertz) return false
        if (medicalTranscriptionJobName != other.medicalTranscriptionJobName) return false
        if (settings != other.settings) return false
        if (specialty != other.specialty) return false
        if (startTime != other.startTime) return false
        if (tags != other.tags) return false
        if (transcript != other.transcript) return false
        if (transcriptionJobStatus != other.transcriptionJobStatus) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionJob = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time the specified medical transcription job finished processing.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:33:13.922000-07:00` represents a transcription job that started processing at 12:33 PM UTC-7 on May 4, 2022.
         */
        public var completionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Labels all personal health information (PHI) identified in your transcript. For more information, see [Identifying personal health information (PHI) in a transcription](https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html).
         */
        public var contentIdentificationType: aws.sdk.kotlin.services.transcribe.model.MedicalContentIdentificationType? = null
        /**
         * The date and time the specified medical transcription job request was made.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If `TranscriptionJobStatus` is `FAILED`, `FailureReason` contains information about why the transcription job request failed.
         *
         * The `FailureReason` field contains one of the following values:
         * + `Unsupported media format`.The media format specified in `MediaFormat` isn't valid. Refer to **MediaFormat** for a list of supported formats.
         * + `The media format provided does not match the detected media format`.The media format specified in `MediaFormat` doesn't match the format of the input file. Check the media format of your media file and correct the specified value.
         * + `Invalid sample rate for audio file`.The sample rate specified in `MediaSampleRateHertz` isn't valid. The sample rate must be between 16,000 and 48,000 Hertz.
         * + `The sample rate provided does not match the detected sample rate`.The sample rate specified in `MediaSampleRateHertz` doesn't match the sample rate detected in your input media file. Check the sample rate of your media file and correct the specified value.
         * + `Invalid file size: file size too large`.The size of your media file is larger than what Amazon Transcribe can process. For more information, refer to [Guidelines and quotas](https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits).
         * + `Invalid number of channels: number of channels too large`.Your audio contains more channels than Amazon Transcribe is able to process. For more information, refer to [Guidelines and quotas](https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits).
         */
        public var failureReason: kotlin.String? = null
        /**
         * The language code used to create your medical transcription job. US English (`en-US`) is the only supported language for medical transcriptions.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = null
        /**
         * Describes the Amazon S3 location of the media file you want to use in your request.
         */
        public var media: aws.sdk.kotlin.services.transcribe.model.Media? = null
        /**
         * The format of the input media file.
         */
        public var mediaFormat: aws.sdk.kotlin.services.transcribe.model.MediaFormat? = null
        /**
         * The sample rate, in Hertz, of the audio track in your input media file.
         */
        public var mediaSampleRateHertz: kotlin.Int? = null
        /**
         * The name of the medical transcription job. Job names are case sensitive and must be unique within an Amazon Web Services account.
         */
        public var medicalTranscriptionJobName: kotlin.String? = null
        /**
         * Specify additional optional settings in your request, including channel identification, alternative transcriptions, and speaker labeling; allows you to apply custom vocabularies to your medical transcription job.
         */
        public var settings: aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting? = null
        /**
         * Describes the medical specialty represented in your media.
         */
        public var specialty: aws.sdk.kotlin.services.transcribe.model.Specialty? = null
        /**
         * The date and time the specified medical transcription job began processing.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.789000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The tags, each in the form of a key:value pair, assigned to the specified medical transcription job.
         */
        public var tags: List<Tag>? = null
        /**
         * Provides you with the Amazon S3 URI you can use to access your transcript.
         */
        public var transcript: aws.sdk.kotlin.services.transcribe.model.MedicalTranscript? = null
        /**
         * Provides the status of the specified medical transcription job.
         *
         * If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
         */
        public var transcriptionJobStatus: aws.sdk.kotlin.services.transcribe.model.TranscriptionJobStatus? = null
        /**
         * Indicates whether the input media is a dictation or a conversation, as specified in the `StartMedicalTranscriptionJob` request.
         */
        public var type: aws.sdk.kotlin.services.transcribe.model.Type? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionJob) : this() {
            this.completionTime = x.completionTime
            this.contentIdentificationType = x.contentIdentificationType
            this.creationTime = x.creationTime
            this.failureReason = x.failureReason
            this.languageCode = x.languageCode
            this.media = x.media
            this.mediaFormat = x.mediaFormat
            this.mediaSampleRateHertz = x.mediaSampleRateHertz
            this.medicalTranscriptionJobName = x.medicalTranscriptionJobName
            this.settings = x.settings
            this.specialty = x.specialty
            this.startTime = x.startTime
            this.tags = x.tags
            this.transcript = x.transcript
            this.transcriptionJobStatus = x.transcriptionJobStatus
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionJob = MedicalTranscriptionJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.Media] inside the given [block]
         */
        public fun media(block: aws.sdk.kotlin.services.transcribe.model.Media.Builder.() -> kotlin.Unit) {
            this.media = aws.sdk.kotlin.services.transcribe.model.Media.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting] inside the given [block]
         */
        public fun settings(block: aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.transcribe.model.MedicalTranscriptionSetting.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.MedicalTranscript] inside the given [block]
         */
        public fun transcript(block: aws.sdk.kotlin.services.transcribe.model.MedicalTranscript.Builder.() -> kotlin.Unit) {
            this.transcript = aws.sdk.kotlin.services.transcribe.model.MedicalTranscript.invoke(block)
        }
    }
}
