// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * Provides you with the Amazon S3 URI you can use to access your transcript.
 */
public class MedicalTranscript private constructor(builder: Builder) {
    /**
     * The Amazon S3 location of your transcript. You can use this URI to access or download your transcript.
     *
     * If you included `OutputBucketName` in your transcription job request, this is the URI of that bucket. If you also included `OutputKey` in your request, your output is located in the path you specified in your request.
     *
     * If you didn't include `OutputBucketName` in your transcription job request, your transcript is stored in a service-managed bucket, and `TranscriptFileUri` provides you with a temporary URI you can use for secure access to your transcript.
     *
     * Temporary URIs for service-managed Amazon S3 buckets are only valid for 15 minutes. If you get an `AccesDenied` error, you can get a new temporary URI by running a `GetTranscriptionJob` or `ListTranscriptionJob` request.
     */
    public val transcriptFileUri: kotlin.String? = builder.transcriptFileUri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.MedicalTranscript = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MedicalTranscript(")
        append("transcriptFileUri=$transcriptFileUri)")
    }

    override fun hashCode(): kotlin.Int {
        var result = transcriptFileUri?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MedicalTranscript

        if (transcriptFileUri != other.transcriptFileUri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.MedicalTranscript = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon S3 location of your transcript. You can use this URI to access or download your transcript.
         *
         * If you included `OutputBucketName` in your transcription job request, this is the URI of that bucket. If you also included `OutputKey` in your request, your output is located in the path you specified in your request.
         *
         * If you didn't include `OutputBucketName` in your transcription job request, your transcript is stored in a service-managed bucket, and `TranscriptFileUri` provides you with a temporary URI you can use for secure access to your transcript.
         *
         * Temporary URIs for service-managed Amazon S3 buckets are only valid for 15 minutes. If you get an `AccesDenied` error, you can get a new temporary URI by running a `GetTranscriptionJob` or `ListTranscriptionJob` request.
         */
        public var transcriptFileUri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.MedicalTranscript) : this() {
            this.transcriptFileUri = x.transcriptFileUri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.MedicalTranscript = MedicalTranscript(this)
    }
}
