// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * If using automatic language identification (`IdentifyLanguage`) in your request and you want to apply a custom language model, a custom vocabulary, or a custom vocabulary filter, include `LanguageIdSettings` with the relevant sub-parameters (`VocabularyName`, `LanguageModelName`, and `VocabularyFilterName`).
 *
 * You can specify two or more language codes that represent the languages you think may be present in your media; including more than five is not recommended. Each language code you include can have an associated custom language model, custom vocabulary, and custom vocabulary filter. The languages you specify must match the languages of the specified custom language models, custom vocabularies, and custom vocabulary filters.
 *
 * To include language options using `IdentifyLanguage`**without** including a custom language model, a custom vocabulary, or a custom vocabulary filter, use `LanguageOptions` instead of `LanguageIdSettings`. Including language options can improve the accuracy of automatic language identification.
 *
 * If you want to include a custom language model with your request but **do not** want to use automatic language identification, use instead the `` parameter with the `LanguageModelName` sub-parameter.
 *
 * If you want to include a custom vocabulary or a custom vocabulary filter (or both) with your request but **do not** want to use automatic language identification, use instead the `` parameter with the `VocabularyName` or `VocabularyFilterName` (or both) sub-parameter.
 */
public class LanguageIdSettings private constructor(builder: Builder) {
    /**
     * The name of the custom language model you want to use when processing your transcription job. Note that language model names are case sensitive.
     *
     * The language of the specified language model must match the language code you specify in your transcription request. If the languages don't match, the language model isn't applied. There are no errors or warnings associated with a language mismatch.
     */
    public val languageModelName: kotlin.String? = builder.languageModelName
    /**
     * The name of the custom vocabulary filter you want to use when processing your transcription job. Vocabulary filter names are case sensitive.
     *
     * The language of the specified vocabulary filter must match the language code you specify in your transcription request. If the languages don't match, the vocabulary filter isn't applied. There are no errors or warnings associated with a language mismatch.
     *
     * Note that if you include `VocabularyFilterName` in your request, you must also include `VocabularyFilterMethod`.
     */
    public val vocabularyFilterName: kotlin.String? = builder.vocabularyFilterName
    /**
     * The name of the custom vocabulary you want to use when processing your transcription job. Vocabulary names are case sensitive.
     *
     * The language of the specified vocabulary must match the language code you specify in your transcription request. If the languages don't match, the vocabulary isn't applied. There are no errors or warnings associated with a language mismatch.
     */
    public val vocabularyName: kotlin.String? = builder.vocabularyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.LanguageIdSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LanguageIdSettings(")
        append("languageModelName=$languageModelName,")
        append("vocabularyFilterName=$vocabularyFilterName,")
        append("vocabularyName=$vocabularyName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = languageModelName?.hashCode() ?: 0
        result = 31 * result + (vocabularyFilterName?.hashCode() ?: 0)
        result = 31 * result + (vocabularyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LanguageIdSettings

        if (languageModelName != other.languageModelName) return false
        if (vocabularyFilterName != other.vocabularyFilterName) return false
        if (vocabularyName != other.vocabularyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.LanguageIdSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the custom language model you want to use when processing your transcription job. Note that language model names are case sensitive.
         *
         * The language of the specified language model must match the language code you specify in your transcription request. If the languages don't match, the language model isn't applied. There are no errors or warnings associated with a language mismatch.
         */
        public var languageModelName: kotlin.String? = null
        /**
         * The name of the custom vocabulary filter you want to use when processing your transcription job. Vocabulary filter names are case sensitive.
         *
         * The language of the specified vocabulary filter must match the language code you specify in your transcription request. If the languages don't match, the vocabulary filter isn't applied. There are no errors or warnings associated with a language mismatch.
         *
         * Note that if you include `VocabularyFilterName` in your request, you must also include `VocabularyFilterMethod`.
         */
        public var vocabularyFilterName: kotlin.String? = null
        /**
         * The name of the custom vocabulary you want to use when processing your transcription job. Vocabulary names are case sensitive.
         *
         * The language of the specified vocabulary must match the language code you specify in your transcription request. If the languages don't match, the vocabulary isn't applied. There are no errors or warnings associated with a language mismatch.
         */
        public var vocabularyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.LanguageIdSettings) : this() {
            this.languageModelName = x.languageModelName
            this.vocabularyFilterName = x.vocabularyFilterName
            this.vocabularyName = x.vocabularyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.LanguageIdSettings = LanguageIdSettings(this)
    }
}
