// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model



/**
 * Allows you to control how your transcription job is processed. Currently, the only `JobExecutionSettings` modification you can choose is enabling job queueing using the `AllowDeferredExecution` sub-parameter.
 *
 * If you include `JobExecutionSettings` in your request, you must also include the sub-parameters: `AllowDeferredExecution` and `DataAccessRoleArn`.
 */
public class JobExecutionSettings private constructor(builder: Builder) {
    /**
     * Allows you to enable job queuing when your concurrent request limit is exceeded. When `AllowDeferredExecution` is set to `true`, transcription job requests are placed in a queue until the number of jobs falls below the concurrent request limit. If `AllowDeferredExecution` is set to `false` and the number of transcription job requests exceed the concurrent request limit, you get a `LimitExceededException` error.
     *
     * Note that job queuing is enabled by default for Call Analytics jobs.
     *
     * If you include `AllowDeferredExecution` in your request, you must also include `DataAccessRoleArn`.
     */
    public val allowDeferredExecution: kotlin.Boolean? = builder.allowDeferredExecution
    /**
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.
     *
     * IAM role ARNs have the format `arn:partition:iam::account:role/role-name-with-path`. For example: `arn:aws:iam::111122223333:role/Admin`. For more information, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
     *
     * Note that if you include `DataAccessRoleArn` in your request, you must also include `AllowDeferredExecution`.
     */
    public val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.JobExecutionSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobExecutionSettings(")
        append("allowDeferredExecution=$allowDeferredExecution,")
        append("dataAccessRoleArn=$dataAccessRoleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowDeferredExecution?.hashCode() ?: 0
        result = 31 * result + (dataAccessRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobExecutionSettings

        if (allowDeferredExecution != other.allowDeferredExecution) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.JobExecutionSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Allows you to enable job queuing when your concurrent request limit is exceeded. When `AllowDeferredExecution` is set to `true`, transcription job requests are placed in a queue until the number of jobs falls below the concurrent request limit. If `AllowDeferredExecution` is set to `false` and the number of transcription job requests exceed the concurrent request limit, you get a `LimitExceededException` error.
         *
         * Note that job queuing is enabled by default for Call Analytics jobs.
         *
         * If you include `AllowDeferredExecution` in your request, you must also include `DataAccessRoleArn`.
         */
        public var allowDeferredExecution: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.
         *
         * IAM role ARNs have the format `arn:partition:iam::account:role/role-name-with-path`. For example: `arn:aws:iam::111122223333:role/Admin`. For more information, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
         *
         * Note that if you include `DataAccessRoleArn` in your request, you must also include `AllowDeferredExecution`.
         */
        public var dataAccessRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.JobExecutionSettings) : this() {
            this.allowDeferredExecution = x.allowDeferredExecution
            this.dataAccessRoleArn = x.dataAccessRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.JobExecutionSettings = JobExecutionSettings(this)
    }
}
