// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides detailed information about a Call Analytics job.
 *
 * To view the job's status, refer to `CallAnalyticsJobStatus`. If the status is `COMPLETED`, the job is finished. You can find your completed transcript at the URI specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
 *
 * If you enabled personally identifiable information (PII) redaction, the redacted transcript appears at the location specified in `RedactedTranscriptFileUri`.
 *
 * If you chose to redact the audio in your media file, you can find your redacted media file at the location specified in the `RedactedMediaFileUri` field of your response.
 */
public class CallAnalyticsJob private constructor(builder: Builder) {
    /**
     * The name of the Call Analytics job. Job names are case sensitive and must be unique within an Amazon Web Services account.
     */
    public val callAnalyticsJobName: kotlin.String? = builder.callAnalyticsJobName
    /**
     * Provides the status of the specified Call Analytics job.
     *
     * If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri` (or `RedactedTranscriptFileUri`, if you requested transcript redaction). If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     */
    public val callAnalyticsJobStatus: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobStatus? = builder.callAnalyticsJobStatus
    /**
     * Allows you to specify which speaker is on which channel in your Call Analytics job request. For example, if your agent is the first participant to speak, you would set `ChannelId` to `0` (to indicate the first channel) and `ParticipantRole` to `AGENT` (to indicate that it's the agent speaking).
     */
    public val channelDefinitions: List<ChannelDefinition>? = builder.channelDefinitions
    /**
     * The date and time the specified Call Analytics job finished processing.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:33:13.922000-07:00` represents a transcription job that started processing at 12:33 PM UTC-7 on May 4, 2022.
     */
    public val completionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completionTime
    /**
     * The date and time the specified Call Analytics job request was made.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.
     *
     * IAM role ARNs have the format `arn:partition:iam::account:role/role-name-with-path`. For example: `arn:aws:iam::111122223333:role/Admin`.
     *
     * For more information, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
     */
    public val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * If `CallAnalyticsJobStatus` is `FAILED`, `FailureReason` contains information about why the Call Analytics job request failed.
     *
     * The `FailureReason` field contains one of the following values:
     * + `Unsupported media format`.The media format specified in `MediaFormat` isn't valid. Refer to **MediaFormat** for a list of supported formats.
     * + `The media format provided does not match the detected media format`.The media format specified in `MediaFormat` doesn't match the format of the input file. Check the media format of your media file and correct the specified value.
     * + `Invalid sample rate for audio file`.The sample rate specified in `MediaSampleRateHertz` isn't valid. The sample rate must be between 8,000 and 48,000 Hertz.
     * + `The sample rate provided does not match the detected sample rate`.The sample rate specified in `MediaSampleRateHertz` doesn't match the sample rate detected in your input media file. Check the sample rate of your media file and correct the specified value.
     * + `Invalid file size: file size too large`.The size of your media file is larger than what Amazon Transcribe can process. For more information, refer to [Guidelines and quotas](https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits).
     * + `Invalid number of channels: number of channels too large`.Your audio contains more channels than Amazon Transcribe is able to process. For more information, refer to [Guidelines and quotas](https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits).
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The confidence score associated with the language identified in your media file.
     *
     * Confidence scores are values between 0 and 1; a larger value indicates a higher probability that the identified language correctly matches the language spoken in your media.
     */
    public val identifiedLanguageScore: kotlin.Float? = builder.identifiedLanguageScore
    /**
     * The language code used to create your Call Analytics job. For a list of supported languages and their associated language codes, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table.
     *
     * If you don't know the language spoken in your media file, you can omit this field and let Amazon Transcribe automatically identify the language of your media. To improve the accuracy of language identification, you can include several language codes and Amazon Transcribe chooses the closest match for your transcription.
     */
    public val languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = builder.languageCode
    /**
     * Describes the Amazon S3 location of the media file you want to use in your request.
     */
    public val media: aws.sdk.kotlin.services.transcribe.model.Media? = builder.media
    /**
     * The format of the input media file.
     */
    public val mediaFormat: aws.sdk.kotlin.services.transcribe.model.MediaFormat? = builder.mediaFormat
    /**
     * The sample rate, in Hertz, of the audio track in your input media file.
     */
    public val mediaSampleRateHertz: kotlin.Int? = builder.mediaSampleRateHertz
    /**
     * Allows additional optional settings in your request, including content redaction; allows you to apply custom language models, vocabulary filters, and custom vocabularies to your Call Analytics job.
     */
    public val settings: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSettings? = builder.settings
    /**
     * The date and time the specified Call Analytics job began processing.
     *
     * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.789000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Provides you with the Amazon S3 URI you can use to access your transcript.
     */
    public val transcript: aws.sdk.kotlin.services.transcribe.model.Transcript? = builder.transcript

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CallAnalyticsJob(")
        append("callAnalyticsJobName=$callAnalyticsJobName,")
        append("callAnalyticsJobStatus=$callAnalyticsJobStatus,")
        append("channelDefinitions=$channelDefinitions,")
        append("completionTime=$completionTime,")
        append("creationTime=$creationTime,")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("failureReason=$failureReason,")
        append("identifiedLanguageScore=$identifiedLanguageScore,")
        append("languageCode=$languageCode,")
        append("media=$media,")
        append("mediaFormat=$mediaFormat,")
        append("mediaSampleRateHertz=$mediaSampleRateHertz,")
        append("settings=$settings,")
        append("startTime=$startTime,")
        append("transcript=$transcript)")
    }

    override fun hashCode(): kotlin.Int {
        var result = callAnalyticsJobName?.hashCode() ?: 0
        result = 31 * result + (callAnalyticsJobStatus?.hashCode() ?: 0)
        result = 31 * result + (channelDefinitions?.hashCode() ?: 0)
        result = 31 * result + (completionTime?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (dataAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (identifiedLanguageScore?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (media?.hashCode() ?: 0)
        result = 31 * result + (mediaFormat?.hashCode() ?: 0)
        result = 31 * result + (mediaSampleRateHertz ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (transcript?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CallAnalyticsJob

        if (callAnalyticsJobName != other.callAnalyticsJobName) return false
        if (callAnalyticsJobStatus != other.callAnalyticsJobStatus) return false
        if (channelDefinitions != other.channelDefinitions) return false
        if (completionTime != other.completionTime) return false
        if (creationTime != other.creationTime) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (failureReason != other.failureReason) return false
        if (identifiedLanguageScore != other.identifiedLanguageScore) return false
        if (languageCode != other.languageCode) return false
        if (media != other.media) return false
        if (mediaFormat != other.mediaFormat) return false
        if (mediaSampleRateHertz != other.mediaSampleRateHertz) return false
        if (settings != other.settings) return false
        if (startTime != other.startTime) return false
        if (transcript != other.transcript) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJob = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Call Analytics job. Job names are case sensitive and must be unique within an Amazon Web Services account.
         */
        public var callAnalyticsJobName: kotlin.String? = null
        /**
         * Provides the status of the specified Call Analytics job.
         *
         * If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri` (or `RedactedTranscriptFileUri`, if you requested transcript redaction). If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
         */
        public var callAnalyticsJobStatus: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobStatus? = null
        /**
         * Allows you to specify which speaker is on which channel in your Call Analytics job request. For example, if your agent is the first participant to speak, you would set `ChannelId` to `0` (to indicate the first channel) and `ParticipantRole` to `AGENT` (to indicate that it's the agent speaking).
         */
        public var channelDefinitions: List<ChannelDefinition>? = null
        /**
         * The date and time the specified Call Analytics job finished processing.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:33:13.922000-07:00` represents a transcription job that started processing at 12:33 PM UTC-7 on May 4, 2022.
         */
        public var completionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time the specified Call Analytics job request was made.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.761000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.
         *
         * IAM role ARNs have the format `arn:partition:iam::account:role/role-name-with-path`. For example: `arn:aws:iam::111122223333:role/Admin`.
         *
         * For more information, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * If `CallAnalyticsJobStatus` is `FAILED`, `FailureReason` contains information about why the Call Analytics job request failed.
         *
         * The `FailureReason` field contains one of the following values:
         * + `Unsupported media format`.The media format specified in `MediaFormat` isn't valid. Refer to **MediaFormat** for a list of supported formats.
         * + `The media format provided does not match the detected media format`.The media format specified in `MediaFormat` doesn't match the format of the input file. Check the media format of your media file and correct the specified value.
         * + `Invalid sample rate for audio file`.The sample rate specified in `MediaSampleRateHertz` isn't valid. The sample rate must be between 8,000 and 48,000 Hertz.
         * + `The sample rate provided does not match the detected sample rate`.The sample rate specified in `MediaSampleRateHertz` doesn't match the sample rate detected in your input media file. Check the sample rate of your media file and correct the specified value.
         * + `Invalid file size: file size too large`.The size of your media file is larger than what Amazon Transcribe can process. For more information, refer to [Guidelines and quotas](https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits).
         * + `Invalid number of channels: number of channels too large`.Your audio contains more channels than Amazon Transcribe is able to process. For more information, refer to [Guidelines and quotas](https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits).
         */
        public var failureReason: kotlin.String? = null
        /**
         * The confidence score associated with the language identified in your media file.
         *
         * Confidence scores are values between 0 and 1; a larger value indicates a higher probability that the identified language correctly matches the language spoken in your media.
         */
        public var identifiedLanguageScore: kotlin.Float? = null
        /**
         * The language code used to create your Call Analytics job. For a list of supported languages and their associated language codes, refer to the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table.
         *
         * If you don't know the language spoken in your media file, you can omit this field and let Amazon Transcribe automatically identify the language of your media. To improve the accuracy of language identification, you can include several language codes and Amazon Transcribe chooses the closest match for your transcription.
         */
        public var languageCode: aws.sdk.kotlin.services.transcribe.model.LanguageCode? = null
        /**
         * Describes the Amazon S3 location of the media file you want to use in your request.
         */
        public var media: aws.sdk.kotlin.services.transcribe.model.Media? = null
        /**
         * The format of the input media file.
         */
        public var mediaFormat: aws.sdk.kotlin.services.transcribe.model.MediaFormat? = null
        /**
         * The sample rate, in Hertz, of the audio track in your input media file.
         */
        public var mediaSampleRateHertz: kotlin.Int? = null
        /**
         * Allows additional optional settings in your request, including content redaction; allows you to apply custom language models, vocabulary filters, and custom vocabularies to your Call Analytics job.
         */
        public var settings: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSettings? = null
        /**
         * The date and time the specified Call Analytics job began processing.
         *
         * Timestamps are in the format `YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC`. For example, `2022-05-04T12:32:58.789000-07:00` represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Provides you with the Amazon S3 URI you can use to access your transcript.
         */
        public var transcript: aws.sdk.kotlin.services.transcribe.model.Transcript? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJob) : this() {
            this.callAnalyticsJobName = x.callAnalyticsJobName
            this.callAnalyticsJobStatus = x.callAnalyticsJobStatus
            this.channelDefinitions = x.channelDefinitions
            this.completionTime = x.completionTime
            this.creationTime = x.creationTime
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.failureReason = x.failureReason
            this.identifiedLanguageScore = x.identifiedLanguageScore
            this.languageCode = x.languageCode
            this.media = x.media
            this.mediaFormat = x.mediaFormat
            this.mediaSampleRateHertz = x.mediaSampleRateHertz
            this.settings = x.settings
            this.startTime = x.startTime
            this.transcript = x.transcript
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJob = CallAnalyticsJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.Media] inside the given [block]
         */
        public fun media(block: aws.sdk.kotlin.services.transcribe.model.Media.Builder.() -> kotlin.Unit) {
            this.media = aws.sdk.kotlin.services.transcribe.model.Media.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSettings] inside the given [block]
         */
        public fun settings(block: aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSettings.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.transcribe.model.CallAnalyticsJobSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transcribe.model.Transcript] inside the given [block]
         */
        public fun transcript(block: aws.sdk.kotlin.services.transcribe.model.Transcript.Builder.() -> kotlin.Unit) {
            this.transcript = aws.sdk.kotlin.services.transcribe.model.Transcript.invoke(block)
        }
    }
}
