// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribe

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.transcribe.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.transcribe.model.*
import aws.sdk.kotlin.services.transcribe.model.CreateCallAnalyticsCategoryRequest
import aws.sdk.kotlin.services.transcribe.model.CreateCallAnalyticsCategoryResponse
import aws.sdk.kotlin.services.transcribe.model.CreateLanguageModelRequest
import aws.sdk.kotlin.services.transcribe.model.CreateLanguageModelResponse
import aws.sdk.kotlin.services.transcribe.model.CreateMedicalVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.CreateMedicalVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.CreateVocabularyFilterRequest
import aws.sdk.kotlin.services.transcribe.model.CreateVocabularyFilterResponse
import aws.sdk.kotlin.services.transcribe.model.CreateVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.CreateVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteCallAnalyticsCategoryRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteCallAnalyticsCategoryResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteCallAnalyticsJobRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteCallAnalyticsJobResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteLanguageModelRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteLanguageModelResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteMedicalTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteMedicalTranscriptionJobResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteMedicalVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteMedicalVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteTranscriptionJobResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteVocabularyFilterRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteVocabularyFilterResponse
import aws.sdk.kotlin.services.transcribe.model.DeleteVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.DeleteVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.DescribeLanguageModelRequest
import aws.sdk.kotlin.services.transcribe.model.DescribeLanguageModelResponse
import aws.sdk.kotlin.services.transcribe.model.GetCallAnalyticsCategoryRequest
import aws.sdk.kotlin.services.transcribe.model.GetCallAnalyticsCategoryResponse
import aws.sdk.kotlin.services.transcribe.model.GetCallAnalyticsJobRequest
import aws.sdk.kotlin.services.transcribe.model.GetCallAnalyticsJobResponse
import aws.sdk.kotlin.services.transcribe.model.GetMedicalTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.GetMedicalTranscriptionJobResponse
import aws.sdk.kotlin.services.transcribe.model.GetMedicalVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.GetMedicalVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.GetTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.GetTranscriptionJobResponse
import aws.sdk.kotlin.services.transcribe.model.GetVocabularyFilterRequest
import aws.sdk.kotlin.services.transcribe.model.GetVocabularyFilterResponse
import aws.sdk.kotlin.services.transcribe.model.GetVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.GetVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.ListCallAnalyticsCategoriesRequest
import aws.sdk.kotlin.services.transcribe.model.ListCallAnalyticsCategoriesResponse
import aws.sdk.kotlin.services.transcribe.model.ListCallAnalyticsJobsRequest
import aws.sdk.kotlin.services.transcribe.model.ListCallAnalyticsJobsResponse
import aws.sdk.kotlin.services.transcribe.model.ListLanguageModelsRequest
import aws.sdk.kotlin.services.transcribe.model.ListLanguageModelsResponse
import aws.sdk.kotlin.services.transcribe.model.ListMedicalTranscriptionJobsRequest
import aws.sdk.kotlin.services.transcribe.model.ListMedicalTranscriptionJobsResponse
import aws.sdk.kotlin.services.transcribe.model.ListMedicalVocabulariesRequest
import aws.sdk.kotlin.services.transcribe.model.ListMedicalVocabulariesResponse
import aws.sdk.kotlin.services.transcribe.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.transcribe.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.transcribe.model.ListTranscriptionJobsRequest
import aws.sdk.kotlin.services.transcribe.model.ListTranscriptionJobsResponse
import aws.sdk.kotlin.services.transcribe.model.ListVocabulariesRequest
import aws.sdk.kotlin.services.transcribe.model.ListVocabulariesResponse
import aws.sdk.kotlin.services.transcribe.model.ListVocabularyFiltersRequest
import aws.sdk.kotlin.services.transcribe.model.ListVocabularyFiltersResponse
import aws.sdk.kotlin.services.transcribe.model.StartCallAnalyticsJobRequest
import aws.sdk.kotlin.services.transcribe.model.StartCallAnalyticsJobResponse
import aws.sdk.kotlin.services.transcribe.model.StartMedicalTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.StartMedicalTranscriptionJobResponse
import aws.sdk.kotlin.services.transcribe.model.StartTranscriptionJobRequest
import aws.sdk.kotlin.services.transcribe.model.StartTranscriptionJobResponse
import aws.sdk.kotlin.services.transcribe.model.TagResourceRequest
import aws.sdk.kotlin.services.transcribe.model.TagResourceResponse
import aws.sdk.kotlin.services.transcribe.model.UntagResourceRequest
import aws.sdk.kotlin.services.transcribe.model.UntagResourceResponse
import aws.sdk.kotlin.services.transcribe.model.UpdateCallAnalyticsCategoryRequest
import aws.sdk.kotlin.services.transcribe.model.UpdateCallAnalyticsCategoryResponse
import aws.sdk.kotlin.services.transcribe.model.UpdateMedicalVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.UpdateMedicalVocabularyResponse
import aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyFilterRequest
import aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyFilterResponse
import aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyRequest
import aws.sdk.kotlin.services.transcribe.model.UpdateVocabularyResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Transcribe offers three main types of batch transcription: **Standard**, **Medical**, and **Call Analytics**.
 * + **Standard transcriptions** are the most common option. Refer to for details.
 * + **Medical transcriptions** are tailored to medical professionals and incorporate medical terms. A common use case for this service is transcribing doctor-patient dialogue into after-visit notes. Refer to for details.
 * + **Call Analytics transcriptions** are designed for use with call center audio on two different channels; if you're looking for insight into customer service calls, use this option. Refer to for details.
 */
public interface TranscribeClient : SdkClient {

    override val serviceName: String
        get() = "Transcribe"
    /**
     * TranscribeClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): TranscribeClient {
            val config = Config.Builder().apply(block).build()
            return DefaultTranscribeClient(config)
        }

        public operator fun invoke(config: Config): TranscribeClient = DefaultTranscribeClient(config)

        /**
         * Construct a [TranscribeClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): TranscribeClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultTranscribeClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new Call Analytics category.
     *
     * All categories are automatically applied to your Call Analytics jobs. Note that in order to apply your categories to your jobs, you must create them before submitting your job request, as categories cannot be applied retroactively.
     *
     * Call Analytics categories are composed of rules. For each category, you must create between 1 and 20 rules. Rules can include these parameters: , , , and .
     *
     * To update an existing category, see .
     *
     * To learn more about:
     * + Call Analytics categories, see [Creating categories](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html)
     * + Using rules, see [Rule criteria](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html#call-analytics-create-categories-rules) and refer to the data type
     * + Call Analytics, see [Analyzing call center audio with Call Analytics](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html)
     */
    public suspend fun createCallAnalyticsCategory(input: CreateCallAnalyticsCategoryRequest): CreateCallAnalyticsCategoryResponse

    /**
     * Creates a new custom language model.
     *
     * When creating a new language model, you must specify:
     * + If you want a Wideband (audio sample rates over 16,000 Hz) or Narrowband (audio sample rates under 16,000 Hz) base model
     * + The location of your training and tuning files (this must be an Amazon S3 URI)
     * + The language of your model
     * + A unique name for your model
     *
     * For more information, see [Custom language models](https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html).
     */
    public suspend fun createLanguageModel(input: CreateLanguageModelRequest): CreateLanguageModelResponse

    /**
     * Creates a new custom medical vocabulary.
     *
     * Prior to creating a new medical vocabulary, you must first upload a text file that contains your new entries, phrases, and terms into an Amazon S3 bucket. Note that this differs from , where you can include a list of terms within your request using the `Phrases` flag; `CreateMedicalVocabulary` does not support the `Phrases` flag.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your vocabulary request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     *
     * For more information, see [Creating a custom vocabulary](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary-create.html).
     */
    public suspend fun createMedicalVocabulary(input: CreateMedicalVocabularyRequest): CreateMedicalVocabularyResponse

    /**
     * Creates a new custom vocabulary.
     *
     * When creating a new vocabulary, you can either upload a text file that contains your new entries, phrases, and terms into an Amazon S3 bucket and include the URI in your request, or you can include a list of terms directly in your request using the `Phrases` flag.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your vocabulary request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     *
     * For more information, see [Creating a custom vocabulary](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary-create.html).
     */
    public suspend fun createVocabulary(input: CreateVocabularyRequest): CreateVocabularyResponse

    /**
     * Creates a new custom vocabulary filter.
     *
     * You can use vocabulary filters to mask, delete, or flag specific words from your transcript. Vocabulary filters are commonly used to mask profanity in transcripts.
     *
     * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your vocabulary filter request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
     *
     * For more information, see [Using vocabulary filtering with unwanted words](https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html).
     */
    public suspend fun createVocabularyFilter(input: CreateVocabularyFilterRequest): CreateVocabularyFilterResponse

    /**
     * Deletes a Call Analytics category. To use this operation, specify the name of the category you want to delete using `CategoryName`. Category names are case sensitive.
     */
    public suspend fun deleteCallAnalyticsCategory(input: DeleteCallAnalyticsCategoryRequest): DeleteCallAnalyticsCategoryResponse

    /**
     * Deletes a Call Analytics job. To use this operation, specify the name of the job you want to delete using `CallAnalyticsJobName`. Job names are case sensitive.
     */
    public suspend fun deleteCallAnalyticsJob(input: DeleteCallAnalyticsJobRequest): DeleteCallAnalyticsJobResponse

    /**
     * Deletes a custom language model. To use this operation, specify the name of the language model you want to delete using `ModelName`. Language model names are case sensitive.
     */
    public suspend fun deleteLanguageModel(input: DeleteLanguageModelRequest): DeleteLanguageModelResponse

    /**
     * Deletes a medical transcription job. To use this operation, specify the name of the job you want to delete using `MedicalTranscriptionJobName`. Job names are case sensitive.
     */
    public suspend fun deleteMedicalTranscriptionJob(input: DeleteMedicalTranscriptionJobRequest): DeleteMedicalTranscriptionJobResponse

    /**
     * Deletes a custom medical vocabulary. To use this operation, specify the name of the vocabulary you want to delete using `VocabularyName`. Vocabulary names are case sensitive.
     */
    public suspend fun deleteMedicalVocabulary(input: DeleteMedicalVocabularyRequest): DeleteMedicalVocabularyResponse

    /**
     * Deletes a transcription job. To use this operation, specify the name of the job you want to delete using `TranscriptionJobName`. Job names are case sensitive.
     */
    public suspend fun deleteTranscriptionJob(input: DeleteTranscriptionJobRequest): DeleteTranscriptionJobResponse

    /**
     * Deletes a custom vocabulary. To use this operation, specify the name of the vocabulary you want to delete using `VocabularyName`. Vocabulary names are case sensitive.
     */
    public suspend fun deleteVocabulary(input: DeleteVocabularyRequest): DeleteVocabularyResponse

    /**
     * Deletes a vocabulary filter. To use this operation, specify the name of the vocabulary filter you want to delete using `VocabularyFilterName`. Vocabulary filter names are case sensitive.
     */
    public suspend fun deleteVocabularyFilter(input: DeleteVocabularyFilterRequest): DeleteVocabularyFilterResponse

    /**
     * Provides information about the specified custom language model.
     *
     * This operation also shows if the base language model you used to create your custom language model has been updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the updated base model.
     *
     * If you tried to create a new custom language model and the request wasn't successful, you can use `DescribeLanguageModel` to help identify the reason for this failure.
     *
     * To get a list of your custom language models, use the operation.
     */
    public suspend fun describeLanguageModel(input: DescribeLanguageModelRequest): DescribeLanguageModelResponse

    /**
     * Provides information about the specified Call Analytics category.
     *
     * To get a list of your Call Analytics categories, use the operation.
     */
    public suspend fun getCallAnalyticsCategory(input: GetCallAnalyticsCategoryRequest): GetCallAnalyticsCategoryResponse

    /**
     * Provides information about the specified Call Analytics job.
     *
     * To view the job's status, refer to `CallAnalyticsJobStatus`. If the status is `COMPLETED`, the job is finished. You can find your completed transcript at the URI specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     *
     * If you enabled personally identifiable information (PII) redaction, the redacted transcript appears at the location specified in `RedactedTranscriptFileUri`.
     *
     * If you chose to redact the audio in your media file, you can find your redacted media file at the location specified in `RedactedMediaFileUri`.
     *
     * To get a list of your Call Analytics jobs, use the operation.
     */
    public suspend fun getCallAnalyticsJob(input: GetCallAnalyticsJobRequest): GetCallAnalyticsJobResponse

    /**
     * Provides information about the specified medical transcription job.
     *
     * To view the status of the specified medical transcription job, check the `TranscriptionJobStatus` field. If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     *
     * To get a list of your medical transcription jobs, use the operation.
     */
    public suspend fun getMedicalTranscriptionJob(input: GetMedicalTranscriptionJobRequest): GetMedicalTranscriptionJobResponse

    /**
     * Provides information about the specified custom medical vocabulary.
     *
     * To view the status of the specified medical vocabulary, check the `VocabularyState` field. If the status is `READY`, your vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your vocabulary failed.
     *
     * To get a list of your custom medical vocabularies, use the operation.
     */
    public suspend fun getMedicalVocabulary(input: GetMedicalVocabularyRequest): GetMedicalVocabularyResponse

    /**
     * Provides information about the specified transcription job.
     *
     * To view the status of the specified transcription job, check the `TranscriptionJobStatus` field. If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
     *
     * If you enabled content redaction, the redacted transcript can be found at the location specified in `RedactedTranscriptFileUri`.
     *
     * To get a list of your transcription jobs, use the operation.
     */
    public suspend fun getTranscriptionJob(input: GetTranscriptionJobRequest): GetTranscriptionJobResponse

    /**
     * Provides information about the specified custom vocabulary.
     *
     * To view the status of the specified vocabulary, check the `VocabularyState` field. If the status is `READY`, your vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your vocabulary failed.
     *
     * To get a list of your custom vocabularies, use the operation.
     */
    public suspend fun getVocabulary(input: GetVocabularyRequest): GetVocabularyResponse

    /**
     * Provides information about the specified custom vocabulary filter.
     *
     * To view the status of the specified vocabulary filter, check the `VocabularyState` field. If the status is `READY`, your vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your vocabulary filter failed.
     *
     * To get a list of your custom vocabulary filters, use the operation.
     */
    public suspend fun getVocabularyFilter(input: GetVocabularyFilterRequest): GetVocabularyFilterResponse

    /**
     * Provides a list of Call Analytics categories, including all rules that make up each category.
     *
     * To get detailed information about a specific Call Analytics category, use the operation.
     */
    public suspend fun listCallAnalyticsCategories(input: ListCallAnalyticsCategoriesRequest = ListCallAnalyticsCategoriesRequest {}): ListCallAnalyticsCategoriesResponse

    /**
     * Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call Analytics jobs are returned.
     *
     * To get detailed information about a specific Call Analytics job, use the operation.
     */
    public suspend fun listCallAnalyticsJobs(input: ListCallAnalyticsJobsRequest = ListCallAnalyticsJobsRequest {}): ListCallAnalyticsJobsResponse

    /**
     * Provides a list of custom language models that match the specified criteria. If no criteria are specified, all language models are returned.
     *
     * To get detailed information about a specific custom language model, use the operation.
     */
    public suspend fun listLanguageModels(input: ListLanguageModelsRequest = ListLanguageModelsRequest {}): ListLanguageModelsResponse

    /**
     * Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified, all medical transcription jobs are returned.
     *
     * To get detailed information about a specific medical transcription job, use the operation.
     */
    public suspend fun listMedicalTranscriptionJobs(input: ListMedicalTranscriptionJobsRequest = ListMedicalTranscriptionJobsRequest {}): ListMedicalTranscriptionJobsResponse

    /**
     * Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified, all custom medical vocabularies are returned.
     *
     * To get detailed information about a specific custom medical vocabulary, use the operation.
     */
    public suspend fun listMedicalVocabularies(input: ListMedicalVocabulariesRequest = ListMedicalVocabulariesRequest {}): ListMedicalVocabulariesResponse

    /**
     * Lists all tags associated with the specified transcription job, vocabulary, model, or resource.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all transcription jobs are returned.
     *
     * To get detailed information about a specific transcription job, use the operation.
     */
    public suspend fun listTranscriptionJobs(input: ListTranscriptionJobsRequest = ListTranscriptionJobsRequest {}): ListTranscriptionJobsResponse

    /**
     * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.
     *
     * To get detailed information about a specific custom vocabulary, use the operation.
     */
    public suspend fun listVocabularies(input: ListVocabulariesRequest = ListVocabulariesRequest {}): ListVocabulariesResponse

    /**
     * Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.
     *
     * To get detailed information about a specific custom vocabulary filter, use the operation.
     */
    public suspend fun listVocabularyFilters(input: ListVocabularyFiltersRequest = ListVocabularyFiltersRequest {}): ListVocabularyFiltersResponse

    /**
     * Transcribes the audio from a customer service call and applies any additional Request Parameters you choose to include in your request.
     *
     * In addition to many of the standard transcription features, Call Analytics provides you with call characteristics, call summarization, speaker sentiment, and optional redaction of your text transcript and your audio file. You can also apply custom categories to flag specified conditions. To learn more about these features and insights, refer to [Analyzing call center audio with Call Analytics](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html).
     *
     * If you want to apply categories to your Call Analytics job, you must create them before submitting your job request. Categories cannot be retroactively applied to a job. To create a new category, use the operation. To learn more about Call Analytics categories, see [Creating categories](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html).
     *
     * To make a `StartCallAnalyticsJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
     *
     * You must include the following parameters in your `StartCallAnalyticsJob` request:
     * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
     * + `CallAnalyticsJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
     * + `DataAccessRoleArn`: The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files.
     * + `Media` (`MediaFileUri` or `RedactedMediaFileUri`): The Amazon S3 location of your media file.
     *
     * With Call Analytics, you can redact the audio contained in your media file by including `RedactedMediaFileUri`, instead of `MediaFileUri`, to specify the location of your input audio. If you choose to redact your audio, you can find your redacted media at the location specified in the `RedactedMediaFileUri` field of your response.
     */
    public suspend fun startCallAnalyticsJob(input: StartCallAnalyticsJobRequest): StartCallAnalyticsJobResponse

    /**
     * Transcribes the audio from a medical dictation or conversation and applies any additional Request Parameters you choose to include in your request.
     *
     * In addition to many of the standard transcription features, Amazon Transcribe Medical provides you with a robust medical vocabulary and, optionally, content identification, which adds flags to personal health information (PHI). To learn more about these features, refer to [How Amazon Transcribe Medical works](https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works-med.html).
     *
     * To make a `StartMedicalTranscriptionJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the S3 location of the file using the `Media` parameter.
     *
     * You must include the following parameters in your `StartMedicalTranscriptionJob` request:
     * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
     * + `MedicalTranscriptionJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
     * + `Media` (`MediaFileUri`): The Amazon S3 location of your media file.
     * + `LanguageCode`: This must be `en-US`.
     * + `OutputBucketName`: The Amazon S3 bucket where you want your transcript stored. If you want your output stored in a sub-folder of this bucket, you must also include `OutputKey`.
     * + `Specialty`: This must be `PRIMARYCARE`.
     * + `Type`: Choose whether your audio is a conversation or a dictation.
     */
    public suspend fun startMedicalTranscriptionJob(input: StartMedicalTranscriptionJobRequest): StartMedicalTranscriptionJobResponse

    /**
     * Transcribes the audio from a media file and applies any additional Request Parameters you choose to include in your request.
     *
     * To make a `StartTranscriptionJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
     *
     * You must include the following parameters in your `StartTranscriptionJob` request:
     * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
     * + `TranscriptionJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
     * + `Media` (`MediaFileUri`): The Amazon S3 location of your media file.
     * + One of `LanguageCode`, `IdentifyLanguage`, or `IdentifyMultipleLanguages`: If you know the language of your media file, specify it using the `LanguageCode` parameter; you can find all valid language codes in the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table. If you don't know the languages spoken in your media, use either `IdentifyLanguage` or `IdentifyMultipleLanguages` and let Amazon Transcribe identify the languages for you.
     */
    public suspend fun startTranscriptionJob(input: StartTranscriptionJobRequest): StartTranscriptionJobResponse

    /**
     * Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.
     *
     * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified Amazon Transcribe resource.
     *
     * If you include `UntagResource` in your request, you must also include `ResourceArn` and `TagKeys`.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified Call Analytics category with new rules. Note that the `UpdateCallAnalyticsCategory` operation overwrites all existing rules contained in the specified category. You cannot append additional rules onto an existing category.
     *
     * To create a new category, see .
     */
    public suspend fun updateCallAnalyticsCategory(input: UpdateCallAnalyticsCategoryRequest): UpdateCallAnalyticsCategoryResponse

    /**
     * Updates an existing custom medical vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing vocabulary.
     */
    public suspend fun updateMedicalVocabulary(input: UpdateMedicalVocabularyRequest): UpdateMedicalVocabularyResponse

    /**
     * Updates an existing custom vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing vocabulary.
     */
    public suspend fun updateVocabulary(input: UpdateVocabularyRequest): UpdateVocabularyResponse

    /**
     * Updates an existing custom vocabulary filter with a new list of words. The new list you provide overwrites all previous entries; you cannot append new terms onto an existing vocabulary filter.
     */
    public suspend fun updateVocabularyFilter(input: UpdateVocabularyFilterRequest): UpdateVocabularyFilterResponse
}

/**
 * Creates a new Call Analytics category.
 *
 * All categories are automatically applied to your Call Analytics jobs. Note that in order to apply your categories to your jobs, you must create them before submitting your job request, as categories cannot be applied retroactively.
 *
 * Call Analytics categories are composed of rules. For each category, you must create between 1 and 20 rules. Rules can include these parameters: , , , and .
 *
 * To update an existing category, see .
 *
 * To learn more about:
 * + Call Analytics categories, see [Creating categories](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html)
 * + Using rules, see [Rule criteria](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html#call-analytics-create-categories-rules) and refer to the data type
 * + Call Analytics, see [Analyzing call center audio with Call Analytics](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html)
 */
public suspend inline fun TranscribeClient.createCallAnalyticsCategory(crossinline block: CreateCallAnalyticsCategoryRequest.Builder.() -> Unit): CreateCallAnalyticsCategoryResponse = createCallAnalyticsCategory(CreateCallAnalyticsCategoryRequest.Builder().apply(block).build())

/**
 * Creates a new custom language model.
 *
 * When creating a new language model, you must specify:
 * + If you want a Wideband (audio sample rates over 16,000 Hz) or Narrowband (audio sample rates under 16,000 Hz) base model
 * + The location of your training and tuning files (this must be an Amazon S3 URI)
 * + The language of your model
 * + A unique name for your model
 *
 * For more information, see [Custom language models](https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html).
 */
public suspend inline fun TranscribeClient.createLanguageModel(crossinline block: CreateLanguageModelRequest.Builder.() -> Unit): CreateLanguageModelResponse = createLanguageModel(CreateLanguageModelRequest.Builder().apply(block).build())

/**
 * Creates a new custom medical vocabulary.
 *
 * Prior to creating a new medical vocabulary, you must first upload a text file that contains your new entries, phrases, and terms into an Amazon S3 bucket. Note that this differs from , where you can include a list of terms within your request using the `Phrases` flag; `CreateMedicalVocabulary` does not support the `Phrases` flag.
 *
 * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your vocabulary request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
 *
 * For more information, see [Creating a custom vocabulary](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary-create.html).
 */
public suspend inline fun TranscribeClient.createMedicalVocabulary(crossinline block: CreateMedicalVocabularyRequest.Builder.() -> Unit): CreateMedicalVocabularyResponse = createMedicalVocabulary(CreateMedicalVocabularyRequest.Builder().apply(block).build())

/**
 * Creates a new custom vocabulary.
 *
 * When creating a new vocabulary, you can either upload a text file that contains your new entries, phrases, and terms into an Amazon S3 bucket and include the URI in your request, or you can include a list of terms directly in your request using the `Phrases` flag.
 *
 * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your vocabulary request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
 *
 * For more information, see [Creating a custom vocabulary](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary-create.html).
 */
public suspend inline fun TranscribeClient.createVocabulary(crossinline block: CreateVocabularyRequest.Builder.() -> Unit): CreateVocabularyResponse = createVocabulary(CreateVocabularyRequest.Builder().apply(block).build())

/**
 * Creates a new custom vocabulary filter.
 *
 * You can use vocabulary filters to mask, delete, or flag specific words from your transcript. Vocabulary filters are commonly used to mask profanity in transcripts.
 *
 * Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your vocabulary filter request fails. Refer to [Character Sets for Custom Vocabularies](https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html) to get the character set for your language.
 *
 * For more information, see [Using vocabulary filtering with unwanted words](https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html).
 */
public suspend inline fun TranscribeClient.createVocabularyFilter(crossinline block: CreateVocabularyFilterRequest.Builder.() -> Unit): CreateVocabularyFilterResponse = createVocabularyFilter(CreateVocabularyFilterRequest.Builder().apply(block).build())

/**
 * Deletes a Call Analytics category. To use this operation, specify the name of the category you want to delete using `CategoryName`. Category names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteCallAnalyticsCategory(crossinline block: DeleteCallAnalyticsCategoryRequest.Builder.() -> Unit): DeleteCallAnalyticsCategoryResponse = deleteCallAnalyticsCategory(DeleteCallAnalyticsCategoryRequest.Builder().apply(block).build())

/**
 * Deletes a Call Analytics job. To use this operation, specify the name of the job you want to delete using `CallAnalyticsJobName`. Job names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteCallAnalyticsJob(crossinline block: DeleteCallAnalyticsJobRequest.Builder.() -> Unit): DeleteCallAnalyticsJobResponse = deleteCallAnalyticsJob(DeleteCallAnalyticsJobRequest.Builder().apply(block).build())

/**
 * Deletes a custom language model. To use this operation, specify the name of the language model you want to delete using `ModelName`. Language model names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteLanguageModel(crossinline block: DeleteLanguageModelRequest.Builder.() -> Unit): DeleteLanguageModelResponse = deleteLanguageModel(DeleteLanguageModelRequest.Builder().apply(block).build())

/**
 * Deletes a medical transcription job. To use this operation, specify the name of the job you want to delete using `MedicalTranscriptionJobName`. Job names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteMedicalTranscriptionJob(crossinline block: DeleteMedicalTranscriptionJobRequest.Builder.() -> Unit): DeleteMedicalTranscriptionJobResponse = deleteMedicalTranscriptionJob(DeleteMedicalTranscriptionJobRequest.Builder().apply(block).build())

/**
 * Deletes a custom medical vocabulary. To use this operation, specify the name of the vocabulary you want to delete using `VocabularyName`. Vocabulary names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteMedicalVocabulary(crossinline block: DeleteMedicalVocabularyRequest.Builder.() -> Unit): DeleteMedicalVocabularyResponse = deleteMedicalVocabulary(DeleteMedicalVocabularyRequest.Builder().apply(block).build())

/**
 * Deletes a transcription job. To use this operation, specify the name of the job you want to delete using `TranscriptionJobName`. Job names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteTranscriptionJob(crossinline block: DeleteTranscriptionJobRequest.Builder.() -> Unit): DeleteTranscriptionJobResponse = deleteTranscriptionJob(DeleteTranscriptionJobRequest.Builder().apply(block).build())

/**
 * Deletes a custom vocabulary. To use this operation, specify the name of the vocabulary you want to delete using `VocabularyName`. Vocabulary names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteVocabulary(crossinline block: DeleteVocabularyRequest.Builder.() -> Unit): DeleteVocabularyResponse = deleteVocabulary(DeleteVocabularyRequest.Builder().apply(block).build())

/**
 * Deletes a vocabulary filter. To use this operation, specify the name of the vocabulary filter you want to delete using `VocabularyFilterName`. Vocabulary filter names are case sensitive.
 */
public suspend inline fun TranscribeClient.deleteVocabularyFilter(crossinline block: DeleteVocabularyFilterRequest.Builder.() -> Unit): DeleteVocabularyFilterResponse = deleteVocabularyFilter(DeleteVocabularyFilterRequest.Builder().apply(block).build())

/**
 * Provides information about the specified custom language model.
 *
 * This operation also shows if the base language model you used to create your custom language model has been updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the updated base model.
 *
 * If you tried to create a new custom language model and the request wasn't successful, you can use `DescribeLanguageModel` to help identify the reason for this failure.
 *
 * To get a list of your custom language models, use the operation.
 */
public suspend inline fun TranscribeClient.describeLanguageModel(crossinline block: DescribeLanguageModelRequest.Builder.() -> Unit): DescribeLanguageModelResponse = describeLanguageModel(DescribeLanguageModelRequest.Builder().apply(block).build())

/**
 * Provides information about the specified Call Analytics category.
 *
 * To get a list of your Call Analytics categories, use the operation.
 */
public suspend inline fun TranscribeClient.getCallAnalyticsCategory(crossinline block: GetCallAnalyticsCategoryRequest.Builder.() -> Unit): GetCallAnalyticsCategoryResponse = getCallAnalyticsCategory(GetCallAnalyticsCategoryRequest.Builder().apply(block).build())

/**
 * Provides information about the specified Call Analytics job.
 *
 * To view the job's status, refer to `CallAnalyticsJobStatus`. If the status is `COMPLETED`, the job is finished. You can find your completed transcript at the URI specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
 *
 * If you enabled personally identifiable information (PII) redaction, the redacted transcript appears at the location specified in `RedactedTranscriptFileUri`.
 *
 * If you chose to redact the audio in your media file, you can find your redacted media file at the location specified in `RedactedMediaFileUri`.
 *
 * To get a list of your Call Analytics jobs, use the operation.
 */
public suspend inline fun TranscribeClient.getCallAnalyticsJob(crossinline block: GetCallAnalyticsJobRequest.Builder.() -> Unit): GetCallAnalyticsJobResponse = getCallAnalyticsJob(GetCallAnalyticsJobRequest.Builder().apply(block).build())

/**
 * Provides information about the specified medical transcription job.
 *
 * To view the status of the specified medical transcription job, check the `TranscriptionJobStatus` field. If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
 *
 * To get a list of your medical transcription jobs, use the operation.
 */
public suspend inline fun TranscribeClient.getMedicalTranscriptionJob(crossinline block: GetMedicalTranscriptionJobRequest.Builder.() -> Unit): GetMedicalTranscriptionJobResponse = getMedicalTranscriptionJob(GetMedicalTranscriptionJobRequest.Builder().apply(block).build())

/**
 * Provides information about the specified custom medical vocabulary.
 *
 * To view the status of the specified medical vocabulary, check the `VocabularyState` field. If the status is `READY`, your vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your vocabulary failed.
 *
 * To get a list of your custom medical vocabularies, use the operation.
 */
public suspend inline fun TranscribeClient.getMedicalVocabulary(crossinline block: GetMedicalVocabularyRequest.Builder.() -> Unit): GetMedicalVocabularyResponse = getMedicalVocabulary(GetMedicalVocabularyRequest.Builder().apply(block).build())

/**
 * Provides information about the specified transcription job.
 *
 * To view the status of the specified transcription job, check the `TranscriptionJobStatus` field. If the status is `COMPLETED`, the job is finished and you can find the results at the location specified in `TranscriptFileUri`. If the status is `FAILED`, `FailureReason` provides details on why your transcription job failed.
 *
 * If you enabled content redaction, the redacted transcript can be found at the location specified in `RedactedTranscriptFileUri`.
 *
 * To get a list of your transcription jobs, use the operation.
 */
public suspend inline fun TranscribeClient.getTranscriptionJob(crossinline block: GetTranscriptionJobRequest.Builder.() -> Unit): GetTranscriptionJobResponse = getTranscriptionJob(GetTranscriptionJobRequest.Builder().apply(block).build())

/**
 * Provides information about the specified custom vocabulary.
 *
 * To view the status of the specified vocabulary, check the `VocabularyState` field. If the status is `READY`, your vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your vocabulary failed.
 *
 * To get a list of your custom vocabularies, use the operation.
 */
public suspend inline fun TranscribeClient.getVocabulary(crossinline block: GetVocabularyRequest.Builder.() -> Unit): GetVocabularyResponse = getVocabulary(GetVocabularyRequest.Builder().apply(block).build())

/**
 * Provides information about the specified custom vocabulary filter.
 *
 * To view the status of the specified vocabulary filter, check the `VocabularyState` field. If the status is `READY`, your vocabulary is available to use. If the status is `FAILED`, `FailureReason` provides details on why your vocabulary filter failed.
 *
 * To get a list of your custom vocabulary filters, use the operation.
 */
public suspend inline fun TranscribeClient.getVocabularyFilter(crossinline block: GetVocabularyFilterRequest.Builder.() -> Unit): GetVocabularyFilterResponse = getVocabularyFilter(GetVocabularyFilterRequest.Builder().apply(block).build())

/**
 * Provides a list of Call Analytics categories, including all rules that make up each category.
 *
 * To get detailed information about a specific Call Analytics category, use the operation.
 */
public suspend inline fun TranscribeClient.listCallAnalyticsCategories(crossinline block: ListCallAnalyticsCategoriesRequest.Builder.() -> Unit): ListCallAnalyticsCategoriesResponse = listCallAnalyticsCategories(ListCallAnalyticsCategoriesRequest.Builder().apply(block).build())

/**
 * Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call Analytics jobs are returned.
 *
 * To get detailed information about a specific Call Analytics job, use the operation.
 */
public suspend inline fun TranscribeClient.listCallAnalyticsJobs(crossinline block: ListCallAnalyticsJobsRequest.Builder.() -> Unit): ListCallAnalyticsJobsResponse = listCallAnalyticsJobs(ListCallAnalyticsJobsRequest.Builder().apply(block).build())

/**
 * Provides a list of custom language models that match the specified criteria. If no criteria are specified, all language models are returned.
 *
 * To get detailed information about a specific custom language model, use the operation.
 */
public suspend inline fun TranscribeClient.listLanguageModels(crossinline block: ListLanguageModelsRequest.Builder.() -> Unit): ListLanguageModelsResponse = listLanguageModels(ListLanguageModelsRequest.Builder().apply(block).build())

/**
 * Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified, all medical transcription jobs are returned.
 *
 * To get detailed information about a specific medical transcription job, use the operation.
 */
public suspend inline fun TranscribeClient.listMedicalTranscriptionJobs(crossinline block: ListMedicalTranscriptionJobsRequest.Builder.() -> Unit): ListMedicalTranscriptionJobsResponse = listMedicalTranscriptionJobs(ListMedicalTranscriptionJobsRequest.Builder().apply(block).build())

/**
 * Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified, all custom medical vocabularies are returned.
 *
 * To get detailed information about a specific custom medical vocabulary, use the operation.
 */
public suspend inline fun TranscribeClient.listMedicalVocabularies(crossinline block: ListMedicalVocabulariesRequest.Builder.() -> Unit): ListMedicalVocabulariesResponse = listMedicalVocabularies(ListMedicalVocabulariesRequest.Builder().apply(block).build())

/**
 * Lists all tags associated with the specified transcription job, vocabulary, model, or resource.
 *
 * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
 */
public suspend inline fun TranscribeClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all transcription jobs are returned.
 *
 * To get detailed information about a specific transcription job, use the operation.
 */
public suspend inline fun TranscribeClient.listTranscriptionJobs(crossinline block: ListTranscriptionJobsRequest.Builder.() -> Unit): ListTranscriptionJobsResponse = listTranscriptionJobs(ListTranscriptionJobsRequest.Builder().apply(block).build())

/**
 * Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.
 *
 * To get detailed information about a specific custom vocabulary, use the operation.
 */
public suspend inline fun TranscribeClient.listVocabularies(crossinline block: ListVocabulariesRequest.Builder.() -> Unit): ListVocabulariesResponse = listVocabularies(ListVocabulariesRequest.Builder().apply(block).build())

/**
 * Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.
 *
 * To get detailed information about a specific custom vocabulary filter, use the operation.
 */
public suspend inline fun TranscribeClient.listVocabularyFilters(crossinline block: ListVocabularyFiltersRequest.Builder.() -> Unit): ListVocabularyFiltersResponse = listVocabularyFilters(ListVocabularyFiltersRequest.Builder().apply(block).build())

/**
 * Transcribes the audio from a customer service call and applies any additional Request Parameters you choose to include in your request.
 *
 * In addition to many of the standard transcription features, Call Analytics provides you with call characteristics, call summarization, speaker sentiment, and optional redaction of your text transcript and your audio file. You can also apply custom categories to flag specified conditions. To learn more about these features and insights, refer to [Analyzing call center audio with Call Analytics](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html).
 *
 * If you want to apply categories to your Call Analytics job, you must create them before submitting your job request. Categories cannot be retroactively applied to a job. To create a new category, use the operation. To learn more about Call Analytics categories, see [Creating categories](https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics-create-categories.html).
 *
 * To make a `StartCallAnalyticsJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
 *
 * You must include the following parameters in your `StartCallAnalyticsJob` request:
 * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
 * + `CallAnalyticsJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
 * + `DataAccessRoleArn`: The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files.
 * + `Media` (`MediaFileUri` or `RedactedMediaFileUri`): The Amazon S3 location of your media file.
 *
 * With Call Analytics, you can redact the audio contained in your media file by including `RedactedMediaFileUri`, instead of `MediaFileUri`, to specify the location of your input audio. If you choose to redact your audio, you can find your redacted media at the location specified in the `RedactedMediaFileUri` field of your response.
 */
public suspend inline fun TranscribeClient.startCallAnalyticsJob(crossinline block: StartCallAnalyticsJobRequest.Builder.() -> Unit): StartCallAnalyticsJobResponse = startCallAnalyticsJob(StartCallAnalyticsJobRequest.Builder().apply(block).build())

/**
 * Transcribes the audio from a medical dictation or conversation and applies any additional Request Parameters you choose to include in your request.
 *
 * In addition to many of the standard transcription features, Amazon Transcribe Medical provides you with a robust medical vocabulary and, optionally, content identification, which adds flags to personal health information (PHI). To learn more about these features, refer to [How Amazon Transcribe Medical works](https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works-med.html).
 *
 * To make a `StartMedicalTranscriptionJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the S3 location of the file using the `Media` parameter.
 *
 * You must include the following parameters in your `StartMedicalTranscriptionJob` request:
 * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
 * + `MedicalTranscriptionJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
 * + `Media` (`MediaFileUri`): The Amazon S3 location of your media file.
 * + `LanguageCode`: This must be `en-US`.
 * + `OutputBucketName`: The Amazon S3 bucket where you want your transcript stored. If you want your output stored in a sub-folder of this bucket, you must also include `OutputKey`.
 * + `Specialty`: This must be `PRIMARYCARE`.
 * + `Type`: Choose whether your audio is a conversation or a dictation.
 */
public suspend inline fun TranscribeClient.startMedicalTranscriptionJob(crossinline block: StartMedicalTranscriptionJobRequest.Builder.() -> Unit): StartMedicalTranscriptionJobResponse = startMedicalTranscriptionJob(StartMedicalTranscriptionJobRequest.Builder().apply(block).build())

/**
 * Transcribes the audio from a media file and applies any additional Request Parameters you choose to include in your request.
 *
 * To make a `StartTranscriptionJob` request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the `Media` parameter.
 *
 * You must include the following parameters in your `StartTranscriptionJob` request:
 * + `region`: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to [Amazon Transcribe endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
 * + `TranscriptionJobName`: A custom name you create for your transcription job that is unique within your Amazon Web Services account.
 * + `Media` (`MediaFileUri`): The Amazon S3 location of your media file.
 * + One of `LanguageCode`, `IdentifyLanguage`, or `IdentifyMultipleLanguages`: If you know the language of your media file, specify it using the `LanguageCode` parameter; you can find all valid language codes in the [Supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) table. If you don't know the languages spoken in your media, use either `IdentifyLanguage` or `IdentifyMultipleLanguages` and let Amazon Transcribe identify the languages for you.
 */
public suspend inline fun TranscribeClient.startTranscriptionJob(crossinline block: StartTranscriptionJobRequest.Builder.() -> Unit): StartTranscriptionJobResponse = startTranscriptionJob(StartTranscriptionJobRequest.Builder().apply(block).build())

/**
 * Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.
 *
 * To learn more about using tags with Amazon Transcribe, refer to [Tagging resources](https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
 */
public suspend inline fun TranscribeClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified Amazon Transcribe resource.
 *
 * If you include `UntagResource` in your request, you must also include `ResourceArn` and `TagKeys`.
 */
public suspend inline fun TranscribeClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified Call Analytics category with new rules. Note that the `UpdateCallAnalyticsCategory` operation overwrites all existing rules contained in the specified category. You cannot append additional rules onto an existing category.
 *
 * To create a new category, see .
 */
public suspend inline fun TranscribeClient.updateCallAnalyticsCategory(crossinline block: UpdateCallAnalyticsCategoryRequest.Builder.() -> Unit): UpdateCallAnalyticsCategoryResponse = updateCallAnalyticsCategory(UpdateCallAnalyticsCategoryRequest.Builder().apply(block).build())

/**
 * Updates an existing custom medical vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing vocabulary.
 */
public suspend inline fun TranscribeClient.updateMedicalVocabulary(crossinline block: UpdateMedicalVocabularyRequest.Builder.() -> Unit): UpdateMedicalVocabularyResponse = updateMedicalVocabulary(UpdateMedicalVocabularyRequest.Builder().apply(block).build())

/**
 * Updates an existing custom vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing vocabulary.
 */
public suspend inline fun TranscribeClient.updateVocabulary(crossinline block: UpdateVocabularyRequest.Builder.() -> Unit): UpdateVocabularyResponse = updateVocabulary(UpdateVocabularyRequest.Builder().apply(block).build())

/**
 * Updates an existing custom vocabulary filter with a new list of words. The new list you provide overwrites all previous entries; you cannot append new terms onto an existing vocabulary filter.
 */
public suspend inline fun TranscribeClient.updateVocabularyFilter(crossinline block: UpdateVocabularyFilterRequest.Builder.() -> Unit): UpdateVocabularyFilterResponse = updateVocabularyFilter(UpdateVocabularyFilterRequest.Builder().apply(block).build())
