// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.serde

import aws.sdk.kotlin.services.tnb.model.PackageContentType
import aws.sdk.kotlin.services.tnb.model.ValidateSolNetworkPackageContentRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class ValidateSolNetworkPackageContentOperationSerializer: HttpSerializer.NonStreaming<ValidateSolNetworkPackageContentRequest> {
    override fun serialize(context: ExecutionContext, input: ValidateSolNetworkPackageContentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.nsdInfoId) { "nsdInfoId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("sol"))
                add(PercentEncoding.Path.encode("nsd"))
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("ns_descriptors"))
                add(PercentEncoding.SmithyLabel.encode(input.nsdInfoId))
                add(PercentEncoding.Path.encode("nsd_content"))
                add(PercentEncoding.Path.encode("validate"))
            }
        }

        builder.headers {
            if (input.contentType != null) append("Content-Type", input.contentType.value)
        }

        if (input.file != null) {
            builder.body = HttpBody.fromBytes(input.file)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.file == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
