// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.serde

import aws.sdk.kotlin.services.tnb.model.TnbException
import aws.sdk.kotlin.services.tnb.model.ValidateSolNetworkPackageContentMetadata
import aws.sdk.kotlin.services.tnb.model.ValidateSolNetworkPackageContentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ValidateSolNetworkPackageContentOperationDeserializer: HttpDeserializer.NonStreaming<ValidateSolNetworkPackageContentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ValidateSolNetworkPackageContentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwValidateSolNetworkPackageContentError(context, call, payload)
        }
        val builder = ValidateSolNetworkPackageContentResponse.Builder()

        if (payload != null) {
            deserializeValidateSolNetworkPackageContentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwValidateSolNetworkPackageContentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TnbException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> TnbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeValidateSolNetworkPackageContentOperationBody(builder: ValidateSolNetworkPackageContentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("metadata"))
    val NSDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nsdId"))
    val NSDNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nsdName"))
    val NSDVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nsdVersion"))
    val VNFPKGIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("vnfPkgIds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
        field(NSDID_DESCRIPTOR)
        field(NSDNAME_DESCRIPTOR)
        field(NSDVERSION_DESCRIPTOR)
        field(VNFPKGIDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                METADATA_DESCRIPTOR.index -> builder.metadata = deserializeValidateSolNetworkPackageContentMetadataDocument(deserializer)
                NSDID_DESCRIPTOR.index -> builder.nsdId = deserializeString()
                NSDNAME_DESCRIPTOR.index -> builder.nsdName = deserializeString()
                NSDVERSION_DESCRIPTOR.index -> builder.nsdVersion = deserializeString()
                VNFPKGIDS_DESCRIPTOR.index -> builder.vnfPkgIds =
                    deserializer.deserializeList(VNFPKGIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
