// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.serde

import aws.sdk.kotlin.services.tnb.model.GetSolNetworkOperationMetadata
import aws.sdk.kotlin.services.tnb.model.GetSolNetworkOperationResponse
import aws.sdk.kotlin.services.tnb.model.GetSolNetworkOperationTaskDetails
import aws.sdk.kotlin.services.tnb.model.LcmOperationType
import aws.sdk.kotlin.services.tnb.model.NsLcmOperationState
import aws.sdk.kotlin.services.tnb.model.ProblemDetails
import aws.sdk.kotlin.services.tnb.model.TnbException
import aws.sdk.kotlin.services.tnb.model.UpdateSolNetworkType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetSolNetworkOperationOperationDeserializer: HttpDeserializer.NonStreaming<GetSolNetworkOperationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetSolNetworkOperationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSolNetworkOperationError(context, call, payload)
        }
        val builder = GetSolNetworkOperationResponse.Builder()

        if (payload != null) {
            deserializeGetSolNetworkOperationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetSolNetworkOperationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TnbException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> TnbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSolNetworkOperationOperationBody(builder: GetSolNetworkOperationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("error"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val LCMOPERATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("lcmOperationType"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("metadata"))
    val NSINSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nsInstanceId"))
    val OPERATIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("operationState"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TASKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tasks"))
    val UPDATETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("updateType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(ERROR_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LCMOPERATIONTYPE_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
        field(NSINSTANCEID_DESCRIPTOR)
        field(OPERATIONSTATE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TASKS_DESCRIPTOR)
        field(UPDATETYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ERROR_DESCRIPTOR.index -> builder.error = deserializeProblemDetailsDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LCMOPERATIONTYPE_DESCRIPTOR.index -> builder.lcmOperationType = deserializeString().let { LcmOperationType.fromValue(it) }
                METADATA_DESCRIPTOR.index -> builder.metadata = deserializeGetSolNetworkOperationMetadataDocument(deserializer)
                NSINSTANCEID_DESCRIPTOR.index -> builder.nsInstanceId = deserializeString()
                OPERATIONSTATE_DESCRIPTOR.index -> builder.operationState = deserializeString().let { NsLcmOperationState.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TASKS_DESCRIPTOR.index -> builder.tasks =
                    deserializer.deserializeList(TASKS_DESCRIPTOR) {
                        val col0 = mutableListOf<GetSolNetworkOperationTaskDetails>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGetSolNetworkOperationTaskDetailsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UPDATETYPE_DESCRIPTOR.index -> builder.updateType = deserializeString().let { UpdateSolNetworkType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
