// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Metadata related to a network operation.
 *
 * A network operation is any operation that is done to your network, such as network instance instantiation or termination.
 */
public class ListSolNetworkOperationsMetadata private constructor(builder: Builder) {
    /**
     * The date that the resource was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The date that the resource was last modified.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModified) { "A non-null value must be provided for lastModified" }
    /**
     * The network service descriptor id used for the operation.
     *
     * Only present if the updateType is `UPDATE_NS`.
     */
    public val nsdInfoId: kotlin.String? = builder.nsdInfoId
    /**
     * The network function id used for the operation.
     *
     * Only present if the updateType is `MODIFY_VNF_INFO`.
     */
    public val vnfInstanceId: kotlin.String? = builder.vnfInstanceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.tnb.model.ListSolNetworkOperationsMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSolNetworkOperationsMetadata(")
        append("createdAt=$createdAt,")
        append("lastModified=$lastModified,")
        append("nsdInfoId=$nsdInfoId,")
        append("vnfInstanceId=$vnfInstanceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (lastModified.hashCode())
        result = 31 * result + (nsdInfoId?.hashCode() ?: 0)
        result = 31 * result + (vnfInstanceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSolNetworkOperationsMetadata

        if (createdAt != other.createdAt) return false
        if (lastModified != other.lastModified) return false
        if (nsdInfoId != other.nsdInfoId) return false
        if (vnfInstanceId != other.vnfInstanceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.tnb.model.ListSolNetworkOperationsMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date that the resource was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date that the resource was last modified.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The network service descriptor id used for the operation.
         *
         * Only present if the updateType is `UPDATE_NS`.
         */
        public var nsdInfoId: kotlin.String? = null
        /**
         * The network function id used for the operation.
         *
         * Only present if the updateType is `MODIFY_VNF_INFO`.
         */
        public var vnfInstanceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.tnb.model.ListSolNetworkOperationsMetadata) : this() {
            this.createdAt = x.createdAt
            this.lastModified = x.lastModified
            this.nsdInfoId = x.nsdInfoId
            this.vnfInstanceId = x.vnfInstanceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.tnb.model.ListSolNetworkOperationsMetadata = ListSolNetworkOperationsMetadata(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (lastModified == null) lastModified = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
