// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a function package.
 *
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
 */
public class ListSolFunctionPackageInfo private constructor(builder: Builder) {
    /**
     * Function package ARN.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * ID of the function package.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The metadata of the function package.
     */
    public val metadata: aws.sdk.kotlin.services.tnb.model.ListSolFunctionPackageMetadata? = builder.metadata
    /**
     * Onboarding state of the function package.
     */
    public val onboardingState: aws.sdk.kotlin.services.tnb.model.OnboardingState = requireNotNull(builder.onboardingState) { "A non-null value must be provided for onboardingState" }
    /**
     * Operational state of the function package.
     */
    public val operationalState: aws.sdk.kotlin.services.tnb.model.OperationalState = requireNotNull(builder.operationalState) { "A non-null value must be provided for operationalState" }
    /**
     * Usage state of the function package.
     */
    public val usageState: aws.sdk.kotlin.services.tnb.model.UsageState = requireNotNull(builder.usageState) { "A non-null value must be provided for usageState" }
    /**
     * The product name for the network function.
     */
    public val vnfProductName: kotlin.String? = builder.vnfProductName
    /**
     * Provider of the function package and the function package descriptor.
     */
    public val vnfProvider: kotlin.String? = builder.vnfProvider
    /**
     * Identifies the function package and the function package descriptor.
     */
    public val vnfdId: kotlin.String? = builder.vnfdId
    /**
     * Identifies the version of the function package descriptor.
     */
    public val vnfdVersion: kotlin.String? = builder.vnfdVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.tnb.model.ListSolFunctionPackageInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSolFunctionPackageInfo(")
        append("arn=$arn,")
        append("id=$id,")
        append("metadata=$metadata,")
        append("onboardingState=$onboardingState,")
        append("operationalState=$operationalState,")
        append("usageState=$usageState,")
        append("vnfProductName=$vnfProductName,")
        append("vnfProvider=$vnfProvider,")
        append("vnfdId=$vnfdId,")
        append("vnfdVersion=$vnfdVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (id.hashCode())
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (onboardingState.hashCode())
        result = 31 * result + (operationalState.hashCode())
        result = 31 * result + (usageState.hashCode())
        result = 31 * result + (vnfProductName?.hashCode() ?: 0)
        result = 31 * result + (vnfProvider?.hashCode() ?: 0)
        result = 31 * result + (vnfdId?.hashCode() ?: 0)
        result = 31 * result + (vnfdVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSolFunctionPackageInfo

        if (arn != other.arn) return false
        if (id != other.id) return false
        if (metadata != other.metadata) return false
        if (onboardingState != other.onboardingState) return false
        if (operationalState != other.operationalState) return false
        if (usageState != other.usageState) return false
        if (vnfProductName != other.vnfProductName) return false
        if (vnfProvider != other.vnfProvider) return false
        if (vnfdId != other.vnfdId) return false
        if (vnfdVersion != other.vnfdVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.tnb.model.ListSolFunctionPackageInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Function package ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * ID of the function package.
         */
        public var id: kotlin.String? = null
        /**
         * The metadata of the function package.
         */
        public var metadata: aws.sdk.kotlin.services.tnb.model.ListSolFunctionPackageMetadata? = null
        /**
         * Onboarding state of the function package.
         */
        public var onboardingState: aws.sdk.kotlin.services.tnb.model.OnboardingState? = null
        /**
         * Operational state of the function package.
         */
        public var operationalState: aws.sdk.kotlin.services.tnb.model.OperationalState? = null
        /**
         * Usage state of the function package.
         */
        public var usageState: aws.sdk.kotlin.services.tnb.model.UsageState? = null
        /**
         * The product name for the network function.
         */
        public var vnfProductName: kotlin.String? = null
        /**
         * Provider of the function package and the function package descriptor.
         */
        public var vnfProvider: kotlin.String? = null
        /**
         * Identifies the function package and the function package descriptor.
         */
        public var vnfdId: kotlin.String? = null
        /**
         * Identifies the version of the function package descriptor.
         */
        public var vnfdVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.tnb.model.ListSolFunctionPackageInfo) : this() {
            this.arn = x.arn
            this.id = x.id
            this.metadata = x.metadata
            this.onboardingState = x.onboardingState
            this.operationalState = x.operationalState
            this.usageState = x.usageState
            this.vnfProductName = x.vnfProductName
            this.vnfProvider = x.vnfProvider
            this.vnfdId = x.vnfdId
            this.vnfdVersion = x.vnfdVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.tnb.model.ListSolFunctionPackageInfo = ListSolFunctionPackageInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.tnb.model.ListSolFunctionPackageMetadata] inside the given [block]
         */
        public fun metadata(block: aws.sdk.kotlin.services.tnb.model.ListSolFunctionPackageMetadata.Builder.() -> kotlin.Unit) {
            this.metadata = aws.sdk.kotlin.services.tnb.model.ListSolFunctionPackageMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (onboardingState == null) onboardingState = OnboardingState.SdkUnknown("no value provided")
            if (operationalState == null) operationalState = OperationalState.SdkUnknown("no value provided")
            if (usageState == null) usageState = UsageState.SdkUnknown("no value provided")
            return this
        }
    }
}
