// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Lists information about a network function instance.
 *
 * A network function instance is a function in a function package .
 */
public class ListSolFunctionInstanceInfo private constructor(builder: Builder) {
    /**
     * Network function instance ARN.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * Network function instance ID.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Information about a network function.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
     */
    public val instantiatedVnfInfo: aws.sdk.kotlin.services.tnb.model.GetSolInstantiatedVnfInfo? = builder.instantiatedVnfInfo
    /**
     * Network function instance instantiation state.
     */
    public val instantiationState: aws.sdk.kotlin.services.tnb.model.VnfInstantiationState = requireNotNull(builder.instantiationState) { "A non-null value must be provided for instantiationState" }
    /**
     * Network function instance metadata.
     */
    public val metadata: aws.sdk.kotlin.services.tnb.model.ListSolFunctionInstanceMetadata? = builder.metadata
    /**
     * Network instance ID.
     */
    public val nsInstanceId: kotlin.String = requireNotNull(builder.nsInstanceId) { "A non-null value must be provided for nsInstanceId" }
    /**
     * Function package ID.
     */
    public val vnfPkgId: kotlin.String = requireNotNull(builder.vnfPkgId) { "A non-null value must be provided for vnfPkgId" }
    /**
     * Function package name.
     */
    public val vnfPkgName: kotlin.String? = builder.vnfPkgName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.tnb.model.ListSolFunctionInstanceInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSolFunctionInstanceInfo(")
        append("arn=$arn,")
        append("id=$id,")
        append("instantiatedVnfInfo=$instantiatedVnfInfo,")
        append("instantiationState=$instantiationState,")
        append("metadata=$metadata,")
        append("nsInstanceId=$nsInstanceId,")
        append("vnfPkgId=$vnfPkgId,")
        append("vnfPkgName=$vnfPkgName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (id.hashCode())
        result = 31 * result + (instantiatedVnfInfo?.hashCode() ?: 0)
        result = 31 * result + (instantiationState.hashCode())
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (nsInstanceId.hashCode())
        result = 31 * result + (vnfPkgId.hashCode())
        result = 31 * result + (vnfPkgName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSolFunctionInstanceInfo

        if (arn != other.arn) return false
        if (id != other.id) return false
        if (instantiatedVnfInfo != other.instantiatedVnfInfo) return false
        if (instantiationState != other.instantiationState) return false
        if (metadata != other.metadata) return false
        if (nsInstanceId != other.nsInstanceId) return false
        if (vnfPkgId != other.vnfPkgId) return false
        if (vnfPkgName != other.vnfPkgName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.tnb.model.ListSolFunctionInstanceInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Network function instance ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * Network function instance ID.
         */
        public var id: kotlin.String? = null
        /**
         * Information about a network function.
         *
         * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
         */
        public var instantiatedVnfInfo: aws.sdk.kotlin.services.tnb.model.GetSolInstantiatedVnfInfo? = null
        /**
         * Network function instance instantiation state.
         */
        public var instantiationState: aws.sdk.kotlin.services.tnb.model.VnfInstantiationState? = null
        /**
         * Network function instance metadata.
         */
        public var metadata: aws.sdk.kotlin.services.tnb.model.ListSolFunctionInstanceMetadata? = null
        /**
         * Network instance ID.
         */
        public var nsInstanceId: kotlin.String? = null
        /**
         * Function package ID.
         */
        public var vnfPkgId: kotlin.String? = null
        /**
         * Function package name.
         */
        public var vnfPkgName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.tnb.model.ListSolFunctionInstanceInfo) : this() {
            this.arn = x.arn
            this.id = x.id
            this.instantiatedVnfInfo = x.instantiatedVnfInfo
            this.instantiationState = x.instantiationState
            this.metadata = x.metadata
            this.nsInstanceId = x.nsInstanceId
            this.vnfPkgId = x.vnfPkgId
            this.vnfPkgName = x.vnfPkgName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.tnb.model.ListSolFunctionInstanceInfo = ListSolFunctionInstanceInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.tnb.model.GetSolInstantiatedVnfInfo] inside the given [block]
         */
        public fun instantiatedVnfInfo(block: aws.sdk.kotlin.services.tnb.model.GetSolInstantiatedVnfInfo.Builder.() -> kotlin.Unit) {
            this.instantiatedVnfInfo = aws.sdk.kotlin.services.tnb.model.GetSolInstantiatedVnfInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.tnb.model.ListSolFunctionInstanceMetadata] inside the given [block]
         */
        public fun metadata(block: aws.sdk.kotlin.services.tnb.model.ListSolFunctionInstanceMetadata.Builder.() -> kotlin.Unit) {
            this.metadata = aws.sdk.kotlin.services.tnb.model.ListSolFunctionInstanceMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (instantiationState == null) instantiationState = VnfInstantiationState.SdkUnknown("no value provided")
            if (nsInstanceId == null) nsInstanceId = ""
            if (vnfPkgId == null) vnfPkgId = ""
            return this
        }
    }
}
