// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetSolFunctionPackageResponse private constructor(builder: Builder) {
    /**
     * Function package ARN.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * Function package ID.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Metadata related to the function package.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     */
    public val metadata: aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageMetadata? = builder.metadata
    /**
     * Function package onboarding state.
     */
    public val onboardingState: aws.sdk.kotlin.services.tnb.model.OnboardingState = requireNotNull(builder.onboardingState) { "A non-null value must be provided for onboardingState" }
    /**
     * Function package operational state.
     */
    public val operationalState: aws.sdk.kotlin.services.tnb.model.OperationalState = requireNotNull(builder.operationalState) { "A non-null value must be provided for operationalState" }
    /**
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Function package usage state.
     */
    public val usageState: aws.sdk.kotlin.services.tnb.model.UsageState = requireNotNull(builder.usageState) { "A non-null value must be provided for usageState" }
    /**
     * Network function product name.
     */
    public val vnfProductName: kotlin.String? = builder.vnfProductName
    /**
     * Network function provider.
     */
    public val vnfProvider: kotlin.String? = builder.vnfProvider
    /**
     * Function package descriptor ID.
     */
    public val vnfdId: kotlin.String? = builder.vnfdId
    /**
     * Function package descriptor version.
     */
    public val vnfdVersion: kotlin.String? = builder.vnfdVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSolFunctionPackageResponse(")
        append("arn=$arn,")
        append("id=$id,")
        append("metadata=$metadata,")
        append("onboardingState=$onboardingState,")
        append("operationalState=$operationalState,")
        append("tags=*** Sensitive Data Redacted ***,")
        append("usageState=$usageState,")
        append("vnfProductName=$vnfProductName,")
        append("vnfProvider=$vnfProvider,")
        append("vnfdId=$vnfdId,")
        append("vnfdVersion=$vnfdVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (id.hashCode())
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (onboardingState.hashCode())
        result = 31 * result + (operationalState.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (usageState.hashCode())
        result = 31 * result + (vnfProductName?.hashCode() ?: 0)
        result = 31 * result + (vnfProvider?.hashCode() ?: 0)
        result = 31 * result + (vnfdId?.hashCode() ?: 0)
        result = 31 * result + (vnfdVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSolFunctionPackageResponse

        if (arn != other.arn) return false
        if (id != other.id) return false
        if (metadata != other.metadata) return false
        if (onboardingState != other.onboardingState) return false
        if (operationalState != other.operationalState) return false
        if (tags != other.tags) return false
        if (usageState != other.usageState) return false
        if (vnfProductName != other.vnfProductName) return false
        if (vnfProvider != other.vnfProvider) return false
        if (vnfdId != other.vnfdId) return false
        if (vnfdVersion != other.vnfdVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Function package ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * Function package ID.
         */
        public var id: kotlin.String? = null
        /**
         * Metadata related to the function package.
         *
         * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
         */
        public var metadata: aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageMetadata? = null
        /**
         * Function package onboarding state.
         */
        public var onboardingState: aws.sdk.kotlin.services.tnb.model.OnboardingState? = null
        /**
         * Function package operational state.
         */
        public var operationalState: aws.sdk.kotlin.services.tnb.model.OperationalState? = null
        /**
         * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
         */
        public var tags: Map<String, String>? = null
        /**
         * Function package usage state.
         */
        public var usageState: aws.sdk.kotlin.services.tnb.model.UsageState? = null
        /**
         * Network function product name.
         */
        public var vnfProductName: kotlin.String? = null
        /**
         * Network function provider.
         */
        public var vnfProvider: kotlin.String? = null
        /**
         * Function package descriptor ID.
         */
        public var vnfdId: kotlin.String? = null
        /**
         * Function package descriptor version.
         */
        public var vnfdVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageResponse) : this() {
            this.arn = x.arn
            this.id = x.id
            this.metadata = x.metadata
            this.onboardingState = x.onboardingState
            this.operationalState = x.operationalState
            this.tags = x.tags
            this.usageState = x.usageState
            this.vnfProductName = x.vnfProductName
            this.vnfProvider = x.vnfProvider
            this.vnfdId = x.vnfdId
            this.vnfdVersion = x.vnfdVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageResponse = GetSolFunctionPackageResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageMetadata] inside the given [block]
         */
        public fun metadata(block: aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageMetadata.Builder.() -> kotlin.Unit) {
            this.metadata = aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (onboardingState == null) onboardingState = OnboardingState.SdkUnknown("no value provided")
            if (operationalState == null) operationalState = OperationalState.SdkUnknown("no value provided")
            if (usageState == null) usageState = UsageState.SdkUnknown("no value provided")
            return this
        }
    }
}
