// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.tnb.auth.TnbAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.tnb.auth.TnbIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.tnb.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.tnb.model.*
import aws.sdk.kotlin.services.tnb.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultTnbClient(override val config: TnbClient.Config) : TnbClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = TnbIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "tnb")
        }
        toMap()
    }
    private val authSchemeAdapter = TnbAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.tnb"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Cancels a network operation.
     *
     * A network operation is any operation that is done to your network, such as network instance instantiation or termination.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.CancelSolNetworkOperation.sample
     */
    override suspend fun cancelSolNetworkOperation(input: CancelSolNetworkOperationRequest): CancelSolNetworkOperationResponse {
        val op = SdkHttpOperation.build<CancelSolNetworkOperationRequest, CancelSolNetworkOperationResponse> {
            serializeWith = CancelSolNetworkOperationOperationSerializer()
            deserializeWith = CancelSolNetworkOperationOperationDeserializer()
            operationName = "CancelSolNetworkOperation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a function package.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network. For more information, see [Function packages](https://docs.aws.amazon.com/tnb/latest/ug/function-packages.html) in the *Amazon Web Services Telco Network Builder User Guide*.
     *
     * Creating a function package is the first step for creating a network in AWS TNB. This request creates an empty container with an ID. The next step is to upload the actual CSAR zip file into that empty container. To upload function package content, see [PutSolFunctionPackageContent](https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html).
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.CreateSolFunctionPackage.sample
     */
    override suspend fun createSolFunctionPackage(input: CreateSolFunctionPackageRequest): CreateSolFunctionPackageResponse {
        val op = SdkHttpOperation.build<CreateSolFunctionPackageRequest, CreateSolFunctionPackageResponse> {
            serializeWith = CreateSolFunctionPackageOperationSerializer()
            deserializeWith = CreateSolFunctionPackageOperationDeserializer()
            operationName = "CreateSolFunctionPackage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a network instance.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed. Creating a network instance is the third step after creating a network package. For more information about network instances, [Network instances](https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html) in the *Amazon Web Services Telco Network Builder User Guide*.
     *
     * Once you create a network instance, you can instantiate it. To instantiate a network, see [InstantiateSolNetworkInstance](https://docs.aws.amazon.com/tnb/latest/APIReference/API_InstantiateSolNetworkInstance.html).
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.CreateSolNetworkInstance.sample
     */
    override suspend fun createSolNetworkInstance(input: CreateSolNetworkInstanceRequest): CreateSolNetworkInstanceResponse {
        val op = SdkHttpOperation.build<CreateSolNetworkInstanceRequest, CreateSolNetworkInstanceResponse> {
            serializeWith = CreateSolNetworkInstanceOperationSerializer()
            deserializeWith = CreateSolNetworkInstanceOperationDeserializer()
            operationName = "CreateSolNetworkInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a network package.
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on. For more information, see [Network instances](https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html) in the *Amazon Web Services Telco Network Builder User Guide*.
     *
     * A network package consists of a network service descriptor (NSD) file (required) and any additional files (optional), such as scripts specific to your needs. For example, if you have multiple function packages in your network package, you can use the NSD to define which network functions should run in certain VPCs, subnets, or EKS clusters.
     *
     * This request creates an empty network package container with an ID. Once you create a network package, you can upload the network package content using [PutSolNetworkPackageContent](https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html).
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.CreateSolNetworkPackage.sample
     */
    override suspend fun createSolNetworkPackage(input: CreateSolNetworkPackageRequest): CreateSolNetworkPackageResponse {
        val op = SdkHttpOperation.build<CreateSolNetworkPackageRequest, CreateSolNetworkPackageResponse> {
            serializeWith = CreateSolNetworkPackageOperationSerializer()
            deserializeWith = CreateSolNetworkPackageOperationDeserializer()
            operationName = "CreateSolNetworkPackage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a function package.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     *
     * To delete a function package, the package must be in a disabled state. To disable a function package, see [UpdateSolFunctionPackage](https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolFunctionPackage.html).
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.DeleteSolFunctionPackage.sample
     */
    override suspend fun deleteSolFunctionPackage(input: DeleteSolFunctionPackageRequest): DeleteSolFunctionPackageResponse {
        val op = SdkHttpOperation.build<DeleteSolFunctionPackageRequest, DeleteSolFunctionPackageResponse> {
            serializeWith = DeleteSolFunctionPackageOperationSerializer()
            deserializeWith = DeleteSolFunctionPackageOperationDeserializer()
            operationName = "DeleteSolFunctionPackage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a network instance.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
     *
     * To delete a network instance, the instance must be in a stopped or terminated state. To terminate a network instance, see [TerminateSolNetworkInstance](https://docs.aws.amazon.com/tnb/latest/APIReference/API_TerminateSolNetworkInstance.html).
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.DeleteSolNetworkInstance.sample
     */
    override suspend fun deleteSolNetworkInstance(input: DeleteSolNetworkInstanceRequest): DeleteSolNetworkInstanceResponse {
        val op = SdkHttpOperation.build<DeleteSolNetworkInstanceRequest, DeleteSolNetworkInstanceResponse> {
            serializeWith = DeleteSolNetworkInstanceOperationSerializer()
            deserializeWith = DeleteSolNetworkInstanceOperationDeserializer()
            operationName = "DeleteSolNetworkInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes network package.
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
     *
     * To delete a network package, the package must be in a disable state. To disable a network package, see [UpdateSolNetworkPackage](https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolNetworkPackage.html).
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.DeleteSolNetworkPackage.sample
     */
    override suspend fun deleteSolNetworkPackage(input: DeleteSolNetworkPackageRequest): DeleteSolNetworkPackageResponse {
        val op = SdkHttpOperation.build<DeleteSolNetworkPackageRequest, DeleteSolNetworkPackageResponse> {
            serializeWith = DeleteSolNetworkPackageOperationSerializer()
            deserializeWith = DeleteSolNetworkPackageOperationDeserializer()
            operationName = "DeleteSolNetworkPackage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of a network function instance, including the instantiation state and metadata from the function package descriptor in the network function package.
     *
     * A network function instance is a function in a function package .
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolFunctionInstance.sample
     */
    override suspend fun getSolFunctionInstance(input: GetSolFunctionInstanceRequest): GetSolFunctionInstanceResponse {
        val op = SdkHttpOperation.build<GetSolFunctionInstanceRequest, GetSolFunctionInstanceResponse> {
            serializeWith = GetSolFunctionInstanceOperationSerializer()
            deserializeWith = GetSolFunctionInstanceOperationDeserializer()
            operationName = "GetSolFunctionInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of an individual function package, such as the operational state and whether the package is in use.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network..
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolFunctionPackage.sample
     */
    override suspend fun getSolFunctionPackage(input: GetSolFunctionPackageRequest): GetSolFunctionPackageResponse {
        val op = SdkHttpOperation.build<GetSolFunctionPackageRequest, GetSolFunctionPackageResponse> {
            serializeWith = GetSolFunctionPackageOperationSerializer()
            deserializeWith = GetSolFunctionPackageOperationDeserializer()
            operationName = "GetSolFunctionPackage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the contents of a function package.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolFunctionPackageContent.sample
     */
    override suspend fun getSolFunctionPackageContent(input: GetSolFunctionPackageContentRequest): GetSolFunctionPackageContentResponse {
        val op = SdkHttpOperation.build<GetSolFunctionPackageContentRequest, GetSolFunctionPackageContentResponse> {
            serializeWith = GetSolFunctionPackageContentOperationSerializer()
            deserializeWith = GetSolFunctionPackageContentOperationDeserializer()
            operationName = "GetSolFunctionPackageContent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets a function package descriptor in a function package.
     *
     * A function package descriptor is a .yaml file in a function package that uses the TOSCA standard to describe how the network function in the function package should run on your network.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolFunctionPackageDescriptor.sample
     */
    override suspend fun getSolFunctionPackageDescriptor(input: GetSolFunctionPackageDescriptorRequest): GetSolFunctionPackageDescriptorResponse {
        val op = SdkHttpOperation.build<GetSolFunctionPackageDescriptorRequest, GetSolFunctionPackageDescriptorResponse> {
            serializeWith = GetSolFunctionPackageDescriptorOperationSerializer()
            deserializeWith = GetSolFunctionPackageDescriptorOperationDeserializer()
            operationName = "GetSolFunctionPackageDescriptor"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of the network instance.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkInstance.sample
     */
    override suspend fun getSolNetworkInstance(input: GetSolNetworkInstanceRequest): GetSolNetworkInstanceResponse {
        val op = SdkHttpOperation.build<GetSolNetworkInstanceRequest, GetSolNetworkInstanceResponse> {
            serializeWith = GetSolNetworkInstanceOperationSerializer()
            deserializeWith = GetSolNetworkInstanceOperationDeserializer()
            operationName = "GetSolNetworkInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of a network operation, including the tasks involved in the network operation and the status of the tasks.
     *
     * A network operation is any operation that is done to your network, such as network instance instantiation or termination.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkOperation.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkOperation.sample2
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkOperation.sample3
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkOperation.sample4
     */
    override suspend fun getSolNetworkOperation(input: GetSolNetworkOperationRequest): GetSolNetworkOperationResponse {
        val op = SdkHttpOperation.build<GetSolNetworkOperationRequest, GetSolNetworkOperationResponse> {
            serializeWith = GetSolNetworkOperationOperationSerializer()
            deserializeWith = GetSolNetworkOperationOperationDeserializer()
            operationName = "GetSolNetworkOperation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of a network package.
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkPackage.sample
     */
    override suspend fun getSolNetworkPackage(input: GetSolNetworkPackageRequest): GetSolNetworkPackageResponse {
        val op = SdkHttpOperation.build<GetSolNetworkPackageRequest, GetSolNetworkPackageResponse> {
            serializeWith = GetSolNetworkPackageOperationSerializer()
            deserializeWith = GetSolNetworkPackageOperationDeserializer()
            operationName = "GetSolNetworkPackage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the contents of a network package.
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkPackageContent.sample
     */
    override suspend fun getSolNetworkPackageContent(input: GetSolNetworkPackageContentRequest): GetSolNetworkPackageContentResponse {
        val op = SdkHttpOperation.build<GetSolNetworkPackageContentRequest, GetSolNetworkPackageContentResponse> {
            serializeWith = GetSolNetworkPackageContentOperationSerializer()
            deserializeWith = GetSolNetworkPackageContentOperationDeserializer()
            operationName = "GetSolNetworkPackageContent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the content of the network service descriptor.
     *
     * A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network functions on.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkPackageDescriptor.sample
     */
    override suspend fun getSolNetworkPackageDescriptor(input: GetSolNetworkPackageDescriptorRequest): GetSolNetworkPackageDescriptorResponse {
        val op = SdkHttpOperation.build<GetSolNetworkPackageDescriptorRequest, GetSolNetworkPackageDescriptorResponse> {
            serializeWith = GetSolNetworkPackageDescriptorOperationSerializer()
            deserializeWith = GetSolNetworkPackageDescriptorOperationDeserializer()
            operationName = "GetSolNetworkPackageDescriptor"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Instantiates a network instance.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
     *
     * Before you can instantiate a network instance, you have to create a network instance. For more information, see [CreateSolNetworkInstance](https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolNetworkInstance.html).
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.InstantiateSolNetworkInstance.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.InstantiateSolNetworkInstance.sample2
     */
    override suspend fun instantiateSolNetworkInstance(input: InstantiateSolNetworkInstanceRequest): InstantiateSolNetworkInstanceResponse {
        val op = SdkHttpOperation.build<InstantiateSolNetworkInstanceRequest, InstantiateSolNetworkInstanceResponse> {
            serializeWith = InstantiateSolNetworkInstanceOperationSerializer()
            deserializeWith = InstantiateSolNetworkInstanceOperationDeserializer()
            operationName = "InstantiateSolNetworkInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists network function instances.
     *
     * A network function instance is a function in a function package .
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionInstances.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionInstances.sample2
     */
    override suspend fun listSolFunctionInstances(input: ListSolFunctionInstancesRequest): ListSolFunctionInstancesResponse {
        val op = SdkHttpOperation.build<ListSolFunctionInstancesRequest, ListSolFunctionInstancesResponse> {
            serializeWith = ListSolFunctionInstancesOperationSerializer()
            deserializeWith = ListSolFunctionInstancesOperationDeserializer()
            operationName = "ListSolFunctionInstances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about function packages.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionPackages.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionPackages.sample2
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionPackages.sample3
     */
    override suspend fun listSolFunctionPackages(input: ListSolFunctionPackagesRequest): ListSolFunctionPackagesResponse {
        val op = SdkHttpOperation.build<ListSolFunctionPackagesRequest, ListSolFunctionPackagesResponse> {
            serializeWith = ListSolFunctionPackagesOperationSerializer()
            deserializeWith = ListSolFunctionPackagesOperationDeserializer()
            operationName = "ListSolFunctionPackages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists your network instances.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkInstances.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkInstances.sample2
     */
    override suspend fun listSolNetworkInstances(input: ListSolNetworkInstancesRequest): ListSolNetworkInstancesResponse {
        val op = SdkHttpOperation.build<ListSolNetworkInstancesRequest, ListSolNetworkInstancesResponse> {
            serializeWith = ListSolNetworkInstancesOperationSerializer()
            deserializeWith = ListSolNetworkInstancesOperationDeserializer()
            operationName = "ListSolNetworkInstances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists details for a network operation, including when the operation started and the status of the operation.
     *
     * A network operation is any operation that is done to your network, such as network instance instantiation or termination.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkOperations.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkOperations.sample2
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkOperations.sample3
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkOperations.sample4
     */
    override suspend fun listSolNetworkOperations(input: ListSolNetworkOperationsRequest): ListSolNetworkOperationsResponse {
        val op = SdkHttpOperation.build<ListSolNetworkOperationsRequest, ListSolNetworkOperationsResponse> {
            serializeWith = ListSolNetworkOperationsOperationSerializer()
            deserializeWith = ListSolNetworkOperationsOperationDeserializer()
            operationName = "ListSolNetworkOperations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists network packages.
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkPackages.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkPackages.sample2
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkPackages.sample3
     */
    override suspend fun listSolNetworkPackages(input: ListSolNetworkPackagesRequest): ListSolNetworkPackagesResponse {
        val op = SdkHttpOperation.build<ListSolNetworkPackagesRequest, ListSolNetworkPackagesResponse> {
            serializeWith = ListSolNetworkPackagesOperationSerializer()
            deserializeWith = ListSolNetworkPackagesOperationDeserializer()
            operationName = "ListSolNetworkPackages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists tags for AWS TNB resources.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializeWith = ListTagsForResourceOperationSerializer()
            deserializeWith = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Uploads the contents of a function package.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.PutSolFunctionPackageContent.sample
     */
    override suspend fun putSolFunctionPackageContent(input: PutSolFunctionPackageContentRequest): PutSolFunctionPackageContentResponse {
        val op = SdkHttpOperation.build<PutSolFunctionPackageContentRequest, PutSolFunctionPackageContentResponse> {
            serializeWith = PutSolFunctionPackageContentOperationSerializer()
            deserializeWith = PutSolFunctionPackageContentOperationDeserializer()
            operationName = "PutSolFunctionPackageContent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Uploads the contents of a network package.
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.PutSolNetworkPackageContent.sample
     */
    override suspend fun putSolNetworkPackageContent(input: PutSolNetworkPackageContentRequest): PutSolNetworkPackageContentResponse {
        val op = SdkHttpOperation.build<PutSolNetworkPackageContentRequest, PutSolNetworkPackageContentResponse> {
            serializeWith = PutSolNetworkPackageContentOperationSerializer()
            deserializeWith = PutSolNetworkPackageContentOperationDeserializer()
            operationName = "PutSolNetworkPackageContent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Tags an AWS TNB resource.
     *
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializeWith = TagResourceOperationSerializer()
            deserializeWith = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Terminates a network instance.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
     *
     * You must terminate a network instance before you can delete it.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.TerminateSolNetworkInstance.sample
     */
    override suspend fun terminateSolNetworkInstance(input: TerminateSolNetworkInstanceRequest): TerminateSolNetworkInstanceResponse {
        val op = SdkHttpOperation.build<TerminateSolNetworkInstanceRequest, TerminateSolNetworkInstanceResponse> {
            serializeWith = TerminateSolNetworkInstanceOperationSerializer()
            deserializeWith = TerminateSolNetworkInstanceOperationDeserializer()
            operationName = "TerminateSolNetworkInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Untags an AWS TNB resource.
     *
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializeWith = UntagResourceOperationSerializer()
            deserializeWith = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the operational state of function package.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolFunctionPackage.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolFunctionPackage.sample2
     */
    override suspend fun updateSolFunctionPackage(input: UpdateSolFunctionPackageRequest): UpdateSolFunctionPackageResponse {
        val op = SdkHttpOperation.build<UpdateSolFunctionPackageRequest, UpdateSolFunctionPackageResponse> {
            serializeWith = UpdateSolFunctionPackageOperationSerializer()
            deserializeWith = UpdateSolFunctionPackageOperationDeserializer()
            operationName = "UpdateSolFunctionPackage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update a network instance.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
     *
     * Choose the *updateType* parameter to target the necessary update of the network instance.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolNetworkInstance.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolNetworkInstance.sample2
     */
    override suspend fun updateSolNetworkInstance(input: UpdateSolNetworkInstanceRequest): UpdateSolNetworkInstanceResponse {
        val op = SdkHttpOperation.build<UpdateSolNetworkInstanceRequest, UpdateSolNetworkInstanceResponse> {
            serializeWith = UpdateSolNetworkInstanceOperationSerializer()
            deserializeWith = UpdateSolNetworkInstanceOperationDeserializer()
            operationName = "UpdateSolNetworkInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the operational state of a network package.
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
     *
     * A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network functions on.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolNetworkPackage.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolNetworkPackage.sample2
     */
    override suspend fun updateSolNetworkPackage(input: UpdateSolNetworkPackageRequest): UpdateSolNetworkPackageResponse {
        val op = SdkHttpOperation.build<UpdateSolNetworkPackageRequest, UpdateSolNetworkPackageResponse> {
            serializeWith = UpdateSolNetworkPackageOperationSerializer()
            deserializeWith = UpdateSolNetworkPackageOperationDeserializer()
            operationName = "UpdateSolNetworkPackage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Validates function package content. This can be used as a dry run before uploading function package content with [PutSolFunctionPackageContent](https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html).
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.ValidateSolFunctionPackageContent.sample
     */
    override suspend fun validateSolFunctionPackageContent(input: ValidateSolFunctionPackageContentRequest): ValidateSolFunctionPackageContentResponse {
        val op = SdkHttpOperation.build<ValidateSolFunctionPackageContentRequest, ValidateSolFunctionPackageContentResponse> {
            serializeWith = ValidateSolFunctionPackageContentOperationSerializer()
            deserializeWith = ValidateSolFunctionPackageContentOperationDeserializer()
            operationName = "ValidateSolFunctionPackageContent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Validates network package content. This can be used as a dry run before uploading network package content with [PutSolNetworkPackageContent](https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html).
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.ValidateSolNetworkPackageContent.sample
     */
    override suspend fun validateSolNetworkPackageContent(input: ValidateSolNetworkPackageContentRequest): ValidateSolNetworkPackageContentResponse {
        val op = SdkHttpOperation.build<ValidateSolNetworkPackageContentRequest, ValidateSolNetworkPackageContentResponse> {
            serializeWith = ValidateSolNetworkPackageContentOperationSerializer()
            deserializeWith = ValidateSolNetworkPackageContentOperationDeserializer()
            operationName = "ValidateSolNetworkPackageContent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "tnb")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
