// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.serde

import aws.sdk.kotlin.services.tnb.model.TnbException
import aws.sdk.kotlin.services.tnb.model.ValidateSolFunctionPackageContentMetadata
import aws.sdk.kotlin.services.tnb.model.ValidateSolFunctionPackageContentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ValidateSolFunctionPackageContentOperationDeserializer: HttpDeserializer.NonStreaming<ValidateSolFunctionPackageContentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ValidateSolFunctionPackageContentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwValidateSolFunctionPackageContentError(context, call, payload)
        }
        val builder = ValidateSolFunctionPackageContentResponse.Builder()

        if (payload != null) {
            deserializeValidateSolFunctionPackageContentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwValidateSolFunctionPackageContentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TnbException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> TnbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeValidateSolFunctionPackageContentOperationBody(builder: ValidateSolFunctionPackageContentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("metadata"))
    val VNFPRODUCTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vnfProductName"))
    val VNFPROVIDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vnfProvider"))
    val VNFDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vnfdId"))
    val VNFDVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vnfdVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ID_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
        field(VNFPRODUCTNAME_DESCRIPTOR)
        field(VNFPROVIDER_DESCRIPTOR)
        field(VNFDID_DESCRIPTOR)
        field(VNFDVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                METADATA_DESCRIPTOR.index -> builder.metadata = deserializeValidateSolFunctionPackageContentMetadataDocument(deserializer)
                VNFPRODUCTNAME_DESCRIPTOR.index -> builder.vnfProductName = deserializeString()
                VNFPROVIDER_DESCRIPTOR.index -> builder.vnfProvider = deserializeString()
                VNFDID_DESCRIPTOR.index -> builder.vnfdId = deserializeString()
                VNFDVERSION_DESCRIPTOR.index -> builder.vnfdVersion = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
