// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.serde

import aws.sdk.kotlin.services.tnb.model.UpdateSolNetworkInstanceRequest
import aws.sdk.kotlin.services.tnb.model.UpdateSolNetworkModify
import aws.sdk.kotlin.services.tnb.model.UpdateSolNetworkServiceData
import aws.sdk.kotlin.services.tnb.model.UpdateSolNetworkType
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateSolNetworkInstanceOperationSerializer: HttpSerializer.NonStreaming<UpdateSolNetworkInstanceRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateSolNetworkInstanceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.nsInstanceId) { "nsInstanceId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("sol"))
                add(PercentEncoding.Path.encode("nslcm"))
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("ns_instances"))
                add(PercentEncoding.SmithyLabel.encode(input.nsInstanceId))
                add(PercentEncoding.Path.encode("update"))
            }
        }

        val payload = serializeUpdateSolNetworkInstanceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateSolNetworkInstanceOperationBody(context: ExecutionContext, input: UpdateSolNetworkInstanceRequest): ByteArray {
    val serializer = JsonSerializer()
    val MODIFYVNFINFODATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("modifyVnfInfoData"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val UPDATENS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("updateNs"))
    val UPDATETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("updateType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MODIFYVNFINFODATA_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(UPDATENS_DESCRIPTOR)
        field(UPDATETYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.modifyVnfInfoData?.let { field(MODIFYVNFINFODATA_DESCRIPTOR, it, ::serializeUpdateSolNetworkModifyDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.updateNs?.let { field(UPDATENS_DESCRIPTOR, it, ::serializeUpdateSolNetworkServiceDataDocument) }
        input.updateType?.let { field(UPDATETYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
