// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.serde

import aws.sdk.kotlin.services.tnb.model.GetSolNetworkInstanceMetadata
import aws.sdk.kotlin.services.tnb.model.GetSolNetworkInstanceResponse
import aws.sdk.kotlin.services.tnb.model.LcmOperationInfo
import aws.sdk.kotlin.services.tnb.model.NsState
import aws.sdk.kotlin.services.tnb.model.TnbException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class GetSolNetworkInstanceOperationDeserializer: HttpDeserializer.NonStreaming<GetSolNetworkInstanceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetSolNetworkInstanceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSolNetworkInstanceError(context, call, payload)
        }
        val builder = GetSolNetworkInstanceResponse.Builder()

        if (payload != null) {
            deserializeGetSolNetworkInstanceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetSolNetworkInstanceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TnbException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> TnbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSolNetworkInstanceOperationBody(builder: GetSolNetworkInstanceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val LCMOPINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("lcmOpInfo"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("metadata"))
    val NSINSTANCEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nsInstanceDescription"))
    val NSINSTANCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nsInstanceName"))
    val NSSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("nsState"))
    val NSDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nsdId"))
    val NSDINFOID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nsdInfoId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LCMOPINFO_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
        field(NSINSTANCEDESCRIPTION_DESCRIPTOR)
        field(NSINSTANCENAME_DESCRIPTOR)
        field(NSSTATE_DESCRIPTOR)
        field(NSDID_DESCRIPTOR)
        field(NSDINFOID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LCMOPINFO_DESCRIPTOR.index -> builder.lcmOpInfo = deserializeLcmOperationInfoDocument(deserializer)
                METADATA_DESCRIPTOR.index -> builder.metadata = deserializeGetSolNetworkInstanceMetadataDocument(deserializer)
                NSINSTANCEDESCRIPTION_DESCRIPTOR.index -> builder.nsInstanceDescription = deserializeString()
                NSINSTANCENAME_DESCRIPTOR.index -> builder.nsInstanceName = deserializeString()
                NSSTATE_DESCRIPTOR.index -> builder.nsState = deserializeString().let { NsState.fromValue(it) }
                NSDID_DESCRIPTOR.index -> builder.nsdId = deserializeString()
                NSDINFOID_DESCRIPTOR.index -> builder.nsdInfoId = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
