// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.serde

import aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageMetadata
import aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageResponse
import aws.sdk.kotlin.services.tnb.model.OnboardingState
import aws.sdk.kotlin.services.tnb.model.OperationalState
import aws.sdk.kotlin.services.tnb.model.TnbException
import aws.sdk.kotlin.services.tnb.model.UsageState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class GetSolFunctionPackageOperationDeserializer: HttpDeserializer.NonStreaming<GetSolFunctionPackageResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetSolFunctionPackageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSolFunctionPackageError(context, call, payload)
        }
        val builder = GetSolFunctionPackageResponse.Builder()

        if (payload != null) {
            deserializeGetSolFunctionPackageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetSolFunctionPackageError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TnbException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> TnbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSolFunctionPackageOperationBody(builder: GetSolFunctionPackageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("metadata"))
    val ONBOARDINGSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("onboardingState"))
    val OPERATIONALSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("operationalState"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val USAGESTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("usageState"))
    val VNFPRODUCTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vnfProductName"))
    val VNFPROVIDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vnfProvider"))
    val VNFDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vnfdId"))
    val VNFDVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vnfdVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
        field(ONBOARDINGSTATE_DESCRIPTOR)
        field(OPERATIONALSTATE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(USAGESTATE_DESCRIPTOR)
        field(VNFPRODUCTNAME_DESCRIPTOR)
        field(VNFPROVIDER_DESCRIPTOR)
        field(VNFDID_DESCRIPTOR)
        field(VNFDVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                METADATA_DESCRIPTOR.index -> builder.metadata = deserializeGetSolFunctionPackageMetadataDocument(deserializer)
                ONBOARDINGSTATE_DESCRIPTOR.index -> builder.onboardingState = deserializeString().let { OnboardingState.fromValue(it) }
                OPERATIONALSTATE_DESCRIPTOR.index -> builder.operationalState = deserializeString().let { OperationalState.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                USAGESTATE_DESCRIPTOR.index -> builder.usageState = deserializeString().let { UsageState.fromValue(it) }
                VNFPRODUCTNAME_DESCRIPTOR.index -> builder.vnfProductName = deserializeString()
                VNFPROVIDER_DESCRIPTOR.index -> builder.vnfProvider = deserializeString()
                VNFDID_DESCRIPTOR.index -> builder.vnfdId = deserializeString()
                VNFDVERSION_DESCRIPTOR.index -> builder.vnfdVersion = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
