// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.paginators

import aws.sdk.kotlin.services.tnb.TnbClient
import aws.sdk.kotlin.services.tnb.model.ListSolFunctionInstanceInfo
import aws.sdk.kotlin.services.tnb.model.ListSolFunctionInstancesRequest
import aws.sdk.kotlin.services.tnb.model.ListSolFunctionInstancesResponse
import aws.sdk.kotlin.services.tnb.model.ListSolFunctionPackageInfo
import aws.sdk.kotlin.services.tnb.model.ListSolFunctionPackagesRequest
import aws.sdk.kotlin.services.tnb.model.ListSolFunctionPackagesResponse
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstanceInfo
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstancesRequest
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstancesResponse
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkOperationsInfo
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkOperationsRequest
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkOperationsResponse
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkPackageInfo
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkPackagesRequest
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkPackagesResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListSolFunctionInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSolFunctionInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolFunctionInstancesResponse]
 */
public fun TnbClient.listSolFunctionInstancesPaginated(initialRequest: ListSolFunctionInstancesRequest = ListSolFunctionInstancesRequest { }): Flow<ListSolFunctionInstancesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSolFunctionInstancesPaginated.listSolFunctionInstances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSolFunctionInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolFunctionInstancesResponse]
 */
public fun TnbClient.listSolFunctionInstancesPaginated(block: ListSolFunctionInstancesRequest.Builder.() -> Unit): Flow<ListSolFunctionInstancesResponse> =
    listSolFunctionInstancesPaginated(ListSolFunctionInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSolFunctionInstancesPaginated]
 * to access the nested member [ListSolFunctionInstanceInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolFunctionInstanceInfo]
 */
@JvmName("listSolFunctionInstancesResponseListSolFunctionInstanceInfo")
public fun Flow<ListSolFunctionInstancesResponse>.functionInstances(): Flow<ListSolFunctionInstanceInfo> =
    transform() { response ->
        response.functionInstances?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSolFunctionPackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSolFunctionPackagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolFunctionPackagesResponse]
 */
public fun TnbClient.listSolFunctionPackagesPaginated(initialRequest: ListSolFunctionPackagesRequest = ListSolFunctionPackagesRequest { }): Flow<ListSolFunctionPackagesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSolFunctionPackagesPaginated.listSolFunctionPackages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSolFunctionPackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolFunctionPackagesResponse]
 */
public fun TnbClient.listSolFunctionPackagesPaginated(block: ListSolFunctionPackagesRequest.Builder.() -> Unit): Flow<ListSolFunctionPackagesResponse> =
    listSolFunctionPackagesPaginated(ListSolFunctionPackagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSolFunctionPackagesPaginated]
 * to access the nested member [ListSolFunctionPackageInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolFunctionPackageInfo]
 */
@JvmName("listSolFunctionPackagesResponseListSolFunctionPackageInfo")
public fun Flow<ListSolFunctionPackagesResponse>.functionPackages(): Flow<ListSolFunctionPackageInfo> =
    transform() { response ->
        response.functionPackages?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSolNetworkInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSolNetworkInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolNetworkInstancesResponse]
 */
public fun TnbClient.listSolNetworkInstancesPaginated(initialRequest: ListSolNetworkInstancesRequest = ListSolNetworkInstancesRequest { }): Flow<ListSolNetworkInstancesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSolNetworkInstancesPaginated.listSolNetworkInstances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSolNetworkInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolNetworkInstancesResponse]
 */
public fun TnbClient.listSolNetworkInstancesPaginated(block: ListSolNetworkInstancesRequest.Builder.() -> Unit): Flow<ListSolNetworkInstancesResponse> =
    listSolNetworkInstancesPaginated(ListSolNetworkInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSolNetworkInstancesPaginated]
 * to access the nested member [ListSolNetworkInstanceInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolNetworkInstanceInfo]
 */
@JvmName("listSolNetworkInstancesResponseListSolNetworkInstanceInfo")
public fun Flow<ListSolNetworkInstancesResponse>.networkInstances(): Flow<ListSolNetworkInstanceInfo> =
    transform() { response ->
        response.networkInstances?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSolNetworkOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSolNetworkOperationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolNetworkOperationsResponse]
 */
public fun TnbClient.listSolNetworkOperationsPaginated(initialRequest: ListSolNetworkOperationsRequest = ListSolNetworkOperationsRequest { }): Flow<ListSolNetworkOperationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSolNetworkOperationsPaginated.listSolNetworkOperations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSolNetworkOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolNetworkOperationsResponse]
 */
public fun TnbClient.listSolNetworkOperationsPaginated(block: ListSolNetworkOperationsRequest.Builder.() -> Unit): Flow<ListSolNetworkOperationsResponse> =
    listSolNetworkOperationsPaginated(ListSolNetworkOperationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSolNetworkOperationsPaginated]
 * to access the nested member [ListSolNetworkOperationsInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolNetworkOperationsInfo]
 */
@JvmName("listSolNetworkOperationsResponseListSolNetworkOperationsInfo")
public fun Flow<ListSolNetworkOperationsResponse>.networkOperations(): Flow<ListSolNetworkOperationsInfo> =
    transform() { response ->
        response.networkOperations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSolNetworkPackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSolNetworkPackagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolNetworkPackagesResponse]
 */
public fun TnbClient.listSolNetworkPackagesPaginated(initialRequest: ListSolNetworkPackagesRequest = ListSolNetworkPackagesRequest { }): Flow<ListSolNetworkPackagesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSolNetworkPackagesPaginated.listSolNetworkPackages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSolNetworkPackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolNetworkPackagesResponse]
 */
public fun TnbClient.listSolNetworkPackagesPaginated(block: ListSolNetworkPackagesRequest.Builder.() -> Unit): Flow<ListSolNetworkPackagesResponse> =
    listSolNetworkPackagesPaginated(ListSolNetworkPackagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSolNetworkPackagesPaginated]
 * to access the nested member [ListSolNetworkPackageInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSolNetworkPackageInfo]
 */
@JvmName("listSolNetworkPackagesResponseListSolNetworkPackageInfo")
public fun Flow<ListSolNetworkPackagesResponse>.networkPackages(): Flow<ListSolNetworkPackageInfo> =
    transform() { response ->
        response.networkPackages?.forEach {
            emit(it)
        }
    }
