// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details of a network package.
 *
 * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
 */
public class ListSolNetworkPackageInfo private constructor(builder: Builder) {
    /**
     * Network package ARN.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * ID of the individual network package.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The metadata of the network package.
     */
    public val metadata: aws.sdk.kotlin.services.tnb.model.ListSolNetworkPackageMetadata? = builder.metadata
    /**
     * Designer of the onboarded network service descriptor in the network package.
     */
    public val nsdDesigner: kotlin.String? = builder.nsdDesigner
    /**
     * ID of the network service descriptor on which the network package is based.
     */
    public val nsdId: kotlin.String? = builder.nsdId
    /**
     * Identifies a network service descriptor in a version independent manner.
     */
    public val nsdInvariantId: kotlin.String? = builder.nsdInvariantId
    /**
     * Name of the onboarded network service descriptor in the network package.
     */
    public val nsdName: kotlin.String? = builder.nsdName
    /**
     * Onboarding state of the network service descriptor in the network package.
     */
    public val nsdOnboardingState: aws.sdk.kotlin.services.tnb.model.NsdOnboardingState = requireNotNull(builder.nsdOnboardingState) { "A non-null value must be provided for nsdOnboardingState" }
    /**
     * Operational state of the network service descriptor in the network package.
     */
    public val nsdOperationalState: aws.sdk.kotlin.services.tnb.model.NsdOperationalState = requireNotNull(builder.nsdOperationalState) { "A non-null value must be provided for nsdOperationalState" }
    /**
     * Usage state of the network service descriptor in the network package.
     */
    public val nsdUsageState: aws.sdk.kotlin.services.tnb.model.NsdUsageState = requireNotNull(builder.nsdUsageState) { "A non-null value must be provided for nsdUsageState" }
    /**
     * Version of the onboarded network service descriptor in the network package.
     */
    public val nsdVersion: kotlin.String? = builder.nsdVersion
    /**
     * Identifies the function package for the function package descriptor referenced by the onboarded network package.
     */
    public val vnfPkgIds: List<String>? = builder.vnfPkgIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.tnb.model.ListSolNetworkPackageInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSolNetworkPackageInfo(")
        append("arn=$arn,")
        append("id=$id,")
        append("metadata=$metadata,")
        append("nsdDesigner=$nsdDesigner,")
        append("nsdId=$nsdId,")
        append("nsdInvariantId=$nsdInvariantId,")
        append("nsdName=$nsdName,")
        append("nsdOnboardingState=$nsdOnboardingState,")
        append("nsdOperationalState=$nsdOperationalState,")
        append("nsdUsageState=$nsdUsageState,")
        append("nsdVersion=$nsdVersion,")
        append("vnfPkgIds=$vnfPkgIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (id.hashCode())
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (nsdDesigner?.hashCode() ?: 0)
        result = 31 * result + (nsdId?.hashCode() ?: 0)
        result = 31 * result + (nsdInvariantId?.hashCode() ?: 0)
        result = 31 * result + (nsdName?.hashCode() ?: 0)
        result = 31 * result + (nsdOnboardingState.hashCode())
        result = 31 * result + (nsdOperationalState.hashCode())
        result = 31 * result + (nsdUsageState.hashCode())
        result = 31 * result + (nsdVersion?.hashCode() ?: 0)
        result = 31 * result + (vnfPkgIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSolNetworkPackageInfo

        if (arn != other.arn) return false
        if (id != other.id) return false
        if (metadata != other.metadata) return false
        if (nsdDesigner != other.nsdDesigner) return false
        if (nsdId != other.nsdId) return false
        if (nsdInvariantId != other.nsdInvariantId) return false
        if (nsdName != other.nsdName) return false
        if (nsdOnboardingState != other.nsdOnboardingState) return false
        if (nsdOperationalState != other.nsdOperationalState) return false
        if (nsdUsageState != other.nsdUsageState) return false
        if (nsdVersion != other.nsdVersion) return false
        if (vnfPkgIds != other.vnfPkgIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.tnb.model.ListSolNetworkPackageInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Network package ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * ID of the individual network package.
         */
        public var id: kotlin.String? = null
        /**
         * The metadata of the network package.
         */
        public var metadata: aws.sdk.kotlin.services.tnb.model.ListSolNetworkPackageMetadata? = null
        /**
         * Designer of the onboarded network service descriptor in the network package.
         */
        public var nsdDesigner: kotlin.String? = null
        /**
         * ID of the network service descriptor on which the network package is based.
         */
        public var nsdId: kotlin.String? = null
        /**
         * Identifies a network service descriptor in a version independent manner.
         */
        public var nsdInvariantId: kotlin.String? = null
        /**
         * Name of the onboarded network service descriptor in the network package.
         */
        public var nsdName: kotlin.String? = null
        /**
         * Onboarding state of the network service descriptor in the network package.
         */
        public var nsdOnboardingState: aws.sdk.kotlin.services.tnb.model.NsdOnboardingState? = null
        /**
         * Operational state of the network service descriptor in the network package.
         */
        public var nsdOperationalState: aws.sdk.kotlin.services.tnb.model.NsdOperationalState? = null
        /**
         * Usage state of the network service descriptor in the network package.
         */
        public var nsdUsageState: aws.sdk.kotlin.services.tnb.model.NsdUsageState? = null
        /**
         * Version of the onboarded network service descriptor in the network package.
         */
        public var nsdVersion: kotlin.String? = null
        /**
         * Identifies the function package for the function package descriptor referenced by the onboarded network package.
         */
        public var vnfPkgIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.tnb.model.ListSolNetworkPackageInfo) : this() {
            this.arn = x.arn
            this.id = x.id
            this.metadata = x.metadata
            this.nsdDesigner = x.nsdDesigner
            this.nsdId = x.nsdId
            this.nsdInvariantId = x.nsdInvariantId
            this.nsdName = x.nsdName
            this.nsdOnboardingState = x.nsdOnboardingState
            this.nsdOperationalState = x.nsdOperationalState
            this.nsdUsageState = x.nsdUsageState
            this.nsdVersion = x.nsdVersion
            this.vnfPkgIds = x.vnfPkgIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.tnb.model.ListSolNetworkPackageInfo = ListSolNetworkPackageInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.tnb.model.ListSolNetworkPackageMetadata] inside the given [block]
         */
        public fun metadata(block: aws.sdk.kotlin.services.tnb.model.ListSolNetworkPackageMetadata.Builder.() -> kotlin.Unit) {
            this.metadata = aws.sdk.kotlin.services.tnb.model.ListSolNetworkPackageMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (nsdOnboardingState == null) nsdOnboardingState = NsdOnboardingState.SdkUnknown("no value provided")
            if (nsdOperationalState == null) nsdOperationalState = NsdOperationalState.SdkUnknown("no value provided")
            if (nsdUsageState == null) nsdUsageState = NsdUsageState.SdkUnknown("no value provided")
            return this
        }
    }
}
