// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Metadata details for a network instance.
 *
 * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
 */
public class ListSolNetworkInstanceMetadata private constructor(builder: Builder) {
    /**
     * The date that the resource was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The date that the resource was last modified.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModified) { "A non-null value must be provided for lastModified" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstanceMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSolNetworkInstanceMetadata(")
        append("createdAt=$createdAt,")
        append("lastModified=$lastModified")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (lastModified.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSolNetworkInstanceMetadata

        if (createdAt != other.createdAt) return false
        if (lastModified != other.lastModified) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstanceMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date that the resource was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date that the resource was last modified.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstanceMetadata) : this() {
            this.createdAt = x.createdAt
            this.lastModified = x.lastModified
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstanceMetadata = ListSolNetworkInstanceMetadata(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (lastModified == null) lastModified = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
