// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Info about the specific network instance.
 *
 * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
 */
public class ListSolNetworkInstanceInfo private constructor(builder: Builder) {
    /**
     * Network instance ARN.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * ID of the network instance.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The metadata of the network instance.
     */
    public val metadata: aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstanceMetadata? = builder.metadata
    /**
     * Human-readable description of the network instance.
     */
    public val nsInstanceDescription: kotlin.String = requireNotNull(builder.nsInstanceDescription) { "A non-null value must be provided for nsInstanceDescription" }
    /**
     * Human-readable name of the network instance.
     */
    public val nsInstanceName: kotlin.String = requireNotNull(builder.nsInstanceName) { "A non-null value must be provided for nsInstanceName" }
    /**
     * The state of the network instance.
     */
    public val nsState: aws.sdk.kotlin.services.tnb.model.NsState = requireNotNull(builder.nsState) { "A non-null value must be provided for nsState" }
    /**
     * ID of the network service descriptor in the network package.
     */
    public val nsdId: kotlin.String = requireNotNull(builder.nsdId) { "A non-null value must be provided for nsdId" }
    /**
     * ID of the network service descriptor in the network package.
     */
    public val nsdInfoId: kotlin.String = requireNotNull(builder.nsdInfoId) { "A non-null value must be provided for nsdInfoId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstanceInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSolNetworkInstanceInfo(")
        append("arn=$arn,")
        append("id=$id,")
        append("metadata=$metadata,")
        append("nsInstanceDescription=$nsInstanceDescription,")
        append("nsInstanceName=$nsInstanceName,")
        append("nsState=$nsState,")
        append("nsdId=$nsdId,")
        append("nsdInfoId=$nsdInfoId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (id.hashCode())
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (nsInstanceDescription.hashCode())
        result = 31 * result + (nsInstanceName.hashCode())
        result = 31 * result + (nsState.hashCode())
        result = 31 * result + (nsdId.hashCode())
        result = 31 * result + (nsdInfoId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSolNetworkInstanceInfo

        if (arn != other.arn) return false
        if (id != other.id) return false
        if (metadata != other.metadata) return false
        if (nsInstanceDescription != other.nsInstanceDescription) return false
        if (nsInstanceName != other.nsInstanceName) return false
        if (nsState != other.nsState) return false
        if (nsdId != other.nsdId) return false
        if (nsdInfoId != other.nsdInfoId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstanceInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Network instance ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * ID of the network instance.
         */
        public var id: kotlin.String? = null
        /**
         * The metadata of the network instance.
         */
        public var metadata: aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstanceMetadata? = null
        /**
         * Human-readable description of the network instance.
         */
        public var nsInstanceDescription: kotlin.String? = null
        /**
         * Human-readable name of the network instance.
         */
        public var nsInstanceName: kotlin.String? = null
        /**
         * The state of the network instance.
         */
        public var nsState: aws.sdk.kotlin.services.tnb.model.NsState? = null
        /**
         * ID of the network service descriptor in the network package.
         */
        public var nsdId: kotlin.String? = null
        /**
         * ID of the network service descriptor in the network package.
         */
        public var nsdInfoId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstanceInfo) : this() {
            this.arn = x.arn
            this.id = x.id
            this.metadata = x.metadata
            this.nsInstanceDescription = x.nsInstanceDescription
            this.nsInstanceName = x.nsInstanceName
            this.nsState = x.nsState
            this.nsdId = x.nsdId
            this.nsdInfoId = x.nsdInfoId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstanceInfo = ListSolNetworkInstanceInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstanceMetadata] inside the given [block]
         */
        public fun metadata(block: aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstanceMetadata.Builder.() -> kotlin.Unit) {
            this.metadata = aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstanceMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (id == null) id = ""
            if (nsInstanceDescription == null) nsInstanceDescription = ""
            if (nsInstanceName == null) nsInstanceName = ""
            if (nsState == null) nsState = NsState.SdkUnknown("no value provided")
            if (nsdId == null) nsdId = ""
            if (nsdInfoId == null) nsdInfoId = ""
            return this
        }
    }
}
