// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Metadata associated with a network package.
 *
 * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
 */
public class GetSolNetworkPackageMetadata private constructor(builder: Builder) {
    /**
     * The date that the resource was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The date that the resource was last modified.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModified) { "A non-null value must be provided for lastModified" }
    /**
     * Metadata related to the onboarded network service descriptor in the network package.
     */
    public val nsd: aws.sdk.kotlin.services.tnb.model.NetworkArtifactMeta? = builder.nsd

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.tnb.model.GetSolNetworkPackageMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSolNetworkPackageMetadata(")
        append("createdAt=$createdAt,")
        append("lastModified=$lastModified,")
        append("nsd=$nsd")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (lastModified.hashCode())
        result = 31 * result + (nsd?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSolNetworkPackageMetadata

        if (createdAt != other.createdAt) return false
        if (lastModified != other.lastModified) return false
        if (nsd != other.nsd) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.tnb.model.GetSolNetworkPackageMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date that the resource was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date that the resource was last modified.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Metadata related to the onboarded network service descriptor in the network package.
         */
        public var nsd: aws.sdk.kotlin.services.tnb.model.NetworkArtifactMeta? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.tnb.model.GetSolNetworkPackageMetadata) : this() {
            this.createdAt = x.createdAt
            this.lastModified = x.lastModified
            this.nsd = x.nsd
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.tnb.model.GetSolNetworkPackageMetadata = GetSolNetworkPackageMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.tnb.model.NetworkArtifactMeta] inside the given [block]
         */
        public fun nsd(block: aws.sdk.kotlin.services.tnb.model.NetworkArtifactMeta.Builder.() -> kotlin.Unit) {
            this.nsd = aws.sdk.kotlin.services.tnb.model.NetworkArtifactMeta.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (lastModified == null) lastModified = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
