// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Metadata related to a network operation occurrence.
 *
 * A network operation is any operation that is done to your network, such as network instance instantiation or termination.
 */
public class GetSolNetworkOperationMetadata private constructor(builder: Builder) {
    /**
     * The date that the resource was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * Metadata related to the network operation occurrence for network instantiation. This is populated only if the lcmOperationType is `INSTANTIATE`.
     */
    public val instantiateMetadata: aws.sdk.kotlin.services.tnb.model.InstantiateMetadata? = builder.instantiateMetadata
    /**
     * The date that the resource was last modified.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModified) { "A non-null value must be provided for lastModified" }
    /**
     * Metadata related to the network operation occurrence for network function updates in a network instance. This is populated only if the lcmOperationType is `UPDATE` and the updateType is `MODIFY_VNF_INFORMATION`.
     */
    public val modifyVnfInfoMetadata: aws.sdk.kotlin.services.tnb.model.ModifyVnfInfoMetadata? = builder.modifyVnfInfoMetadata
    /**
     * Metadata related to the network operation occurrence for network instance updates. This is populated only if the lcmOperationType is `UPDATE` and the updateType is `UPDATE_NS`.
     */
    public val updateNsMetadata: aws.sdk.kotlin.services.tnb.model.UpdateNsMetadata? = builder.updateNsMetadata

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.tnb.model.GetSolNetworkOperationMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSolNetworkOperationMetadata(")
        append("createdAt=$createdAt,")
        append("instantiateMetadata=$instantiateMetadata,")
        append("lastModified=$lastModified,")
        append("modifyVnfInfoMetadata=$modifyVnfInfoMetadata,")
        append("updateNsMetadata=$updateNsMetadata")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (instantiateMetadata?.hashCode() ?: 0)
        result = 31 * result + (lastModified.hashCode())
        result = 31 * result + (modifyVnfInfoMetadata?.hashCode() ?: 0)
        result = 31 * result + (updateNsMetadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSolNetworkOperationMetadata

        if (createdAt != other.createdAt) return false
        if (instantiateMetadata != other.instantiateMetadata) return false
        if (lastModified != other.lastModified) return false
        if (modifyVnfInfoMetadata != other.modifyVnfInfoMetadata) return false
        if (updateNsMetadata != other.updateNsMetadata) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.tnb.model.GetSolNetworkOperationMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date that the resource was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Metadata related to the network operation occurrence for network instantiation. This is populated only if the lcmOperationType is `INSTANTIATE`.
         */
        public var instantiateMetadata: aws.sdk.kotlin.services.tnb.model.InstantiateMetadata? = null
        /**
         * The date that the resource was last modified.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Metadata related to the network operation occurrence for network function updates in a network instance. This is populated only if the lcmOperationType is `UPDATE` and the updateType is `MODIFY_VNF_INFORMATION`.
         */
        public var modifyVnfInfoMetadata: aws.sdk.kotlin.services.tnb.model.ModifyVnfInfoMetadata? = null
        /**
         * Metadata related to the network operation occurrence for network instance updates. This is populated only if the lcmOperationType is `UPDATE` and the updateType is `UPDATE_NS`.
         */
        public var updateNsMetadata: aws.sdk.kotlin.services.tnb.model.UpdateNsMetadata? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.tnb.model.GetSolNetworkOperationMetadata) : this() {
            this.createdAt = x.createdAt
            this.instantiateMetadata = x.instantiateMetadata
            this.lastModified = x.lastModified
            this.modifyVnfInfoMetadata = x.modifyVnfInfoMetadata
            this.updateNsMetadata = x.updateNsMetadata
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.tnb.model.GetSolNetworkOperationMetadata = GetSolNetworkOperationMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.tnb.model.InstantiateMetadata] inside the given [block]
         */
        public fun instantiateMetadata(block: aws.sdk.kotlin.services.tnb.model.InstantiateMetadata.Builder.() -> kotlin.Unit) {
            this.instantiateMetadata = aws.sdk.kotlin.services.tnb.model.InstantiateMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.tnb.model.ModifyVnfInfoMetadata] inside the given [block]
         */
        public fun modifyVnfInfoMetadata(block: aws.sdk.kotlin.services.tnb.model.ModifyVnfInfoMetadata.Builder.() -> kotlin.Unit) {
            this.modifyVnfInfoMetadata = aws.sdk.kotlin.services.tnb.model.ModifyVnfInfoMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.tnb.model.UpdateNsMetadata] inside the given [block]
         */
        public fun updateNsMetadata(block: aws.sdk.kotlin.services.tnb.model.UpdateNsMetadata.Builder.() -> kotlin.Unit) {
            this.updateNsMetadata = aws.sdk.kotlin.services.tnb.model.UpdateNsMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (lastModified == null) lastModified = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
