// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Metadata related to the function package.
 *
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
 */
public class GetSolFunctionPackageMetadata private constructor(builder: Builder) {
    /**
     * The date that the resource was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The date that the resource was last modified.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModified) { "A non-null value must be provided for lastModified" }
    /**
     * Metadata related to the function package descriptor of the function package.
     */
    public val vnfd: aws.sdk.kotlin.services.tnb.model.FunctionArtifactMeta? = builder.vnfd

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSolFunctionPackageMetadata(")
        append("createdAt=$createdAt,")
        append("lastModified=$lastModified,")
        append("vnfd=$vnfd")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (lastModified.hashCode())
        result = 31 * result + (vnfd?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSolFunctionPackageMetadata

        if (createdAt != other.createdAt) return false
        if (lastModified != other.lastModified) return false
        if (vnfd != other.vnfd) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date that the resource was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date that the resource was last modified.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Metadata related to the function package descriptor of the function package.
         */
        public var vnfd: aws.sdk.kotlin.services.tnb.model.FunctionArtifactMeta? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageMetadata) : this() {
            this.createdAt = x.createdAt
            this.lastModified = x.lastModified
            this.vnfd = x.vnfd
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageMetadata = GetSolFunctionPackageMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.tnb.model.FunctionArtifactMeta] inside the given [block]
         */
        public fun vnfd(block: aws.sdk.kotlin.services.tnb.model.FunctionArtifactMeta.Builder.() -> kotlin.Unit) {
            this.vnfd = aws.sdk.kotlin.services.tnb.model.FunctionArtifactMeta.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (lastModified == null) lastModified = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
