// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.tnb

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.tnb.auth.DefaultTnbAuthSchemeProvider
import aws.sdk.kotlin.services.tnb.auth.TnbAuthSchemeProvider
import aws.sdk.kotlin.services.tnb.endpoints.DefaultTnbEndpointProvider
import aws.sdk.kotlin.services.tnb.endpoints.TnbEndpointParameters
import aws.sdk.kotlin.services.tnb.endpoints.TnbEndpointProvider
import aws.sdk.kotlin.services.tnb.model.CancelSolNetworkOperationRequest
import aws.sdk.kotlin.services.tnb.model.CancelSolNetworkOperationResponse
import aws.sdk.kotlin.services.tnb.model.CreateSolFunctionPackageRequest
import aws.sdk.kotlin.services.tnb.model.CreateSolFunctionPackageResponse
import aws.sdk.kotlin.services.tnb.model.CreateSolNetworkInstanceRequest
import aws.sdk.kotlin.services.tnb.model.CreateSolNetworkInstanceResponse
import aws.sdk.kotlin.services.tnb.model.CreateSolNetworkPackageRequest
import aws.sdk.kotlin.services.tnb.model.CreateSolNetworkPackageResponse
import aws.sdk.kotlin.services.tnb.model.DeleteSolFunctionPackageRequest
import aws.sdk.kotlin.services.tnb.model.DeleteSolFunctionPackageResponse
import aws.sdk.kotlin.services.tnb.model.DeleteSolNetworkInstanceRequest
import aws.sdk.kotlin.services.tnb.model.DeleteSolNetworkInstanceResponse
import aws.sdk.kotlin.services.tnb.model.DeleteSolNetworkPackageRequest
import aws.sdk.kotlin.services.tnb.model.DeleteSolNetworkPackageResponse
import aws.sdk.kotlin.services.tnb.model.GetSolFunctionInstanceRequest
import aws.sdk.kotlin.services.tnb.model.GetSolFunctionInstanceResponse
import aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageContentRequest
import aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageContentResponse
import aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageDescriptorRequest
import aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageDescriptorResponse
import aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageRequest
import aws.sdk.kotlin.services.tnb.model.GetSolFunctionPackageResponse
import aws.sdk.kotlin.services.tnb.model.GetSolNetworkInstanceRequest
import aws.sdk.kotlin.services.tnb.model.GetSolNetworkInstanceResponse
import aws.sdk.kotlin.services.tnb.model.GetSolNetworkOperationRequest
import aws.sdk.kotlin.services.tnb.model.GetSolNetworkOperationResponse
import aws.sdk.kotlin.services.tnb.model.GetSolNetworkPackageContentRequest
import aws.sdk.kotlin.services.tnb.model.GetSolNetworkPackageContentResponse
import aws.sdk.kotlin.services.tnb.model.GetSolNetworkPackageDescriptorRequest
import aws.sdk.kotlin.services.tnb.model.GetSolNetworkPackageDescriptorResponse
import aws.sdk.kotlin.services.tnb.model.GetSolNetworkPackageRequest
import aws.sdk.kotlin.services.tnb.model.GetSolNetworkPackageResponse
import aws.sdk.kotlin.services.tnb.model.InstantiateSolNetworkInstanceRequest
import aws.sdk.kotlin.services.tnb.model.InstantiateSolNetworkInstanceResponse
import aws.sdk.kotlin.services.tnb.model.ListSolFunctionInstancesRequest
import aws.sdk.kotlin.services.tnb.model.ListSolFunctionInstancesResponse
import aws.sdk.kotlin.services.tnb.model.ListSolFunctionPackagesRequest
import aws.sdk.kotlin.services.tnb.model.ListSolFunctionPackagesResponse
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstancesRequest
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkInstancesResponse
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkOperationsRequest
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkOperationsResponse
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkPackagesRequest
import aws.sdk.kotlin.services.tnb.model.ListSolNetworkPackagesResponse
import aws.sdk.kotlin.services.tnb.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.tnb.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.tnb.model.PutSolFunctionPackageContentRequest
import aws.sdk.kotlin.services.tnb.model.PutSolFunctionPackageContentResponse
import aws.sdk.kotlin.services.tnb.model.PutSolNetworkPackageContentRequest
import aws.sdk.kotlin.services.tnb.model.PutSolNetworkPackageContentResponse
import aws.sdk.kotlin.services.tnb.model.TagResourceRequest
import aws.sdk.kotlin.services.tnb.model.TagResourceResponse
import aws.sdk.kotlin.services.tnb.model.TerminateSolNetworkInstanceRequest
import aws.sdk.kotlin.services.tnb.model.TerminateSolNetworkInstanceResponse
import aws.sdk.kotlin.services.tnb.model.UntagResourceRequest
import aws.sdk.kotlin.services.tnb.model.UntagResourceResponse
import aws.sdk.kotlin.services.tnb.model.UpdateSolFunctionPackageRequest
import aws.sdk.kotlin.services.tnb.model.UpdateSolFunctionPackageResponse
import aws.sdk.kotlin.services.tnb.model.UpdateSolNetworkInstanceRequest
import aws.sdk.kotlin.services.tnb.model.UpdateSolNetworkInstanceResponse
import aws.sdk.kotlin.services.tnb.model.UpdateSolNetworkPackageRequest
import aws.sdk.kotlin.services.tnb.model.UpdateSolNetworkPackageResponse
import aws.sdk.kotlin.services.tnb.model.ValidateSolFunctionPackageContentRequest
import aws.sdk.kotlin.services.tnb.model.ValidateSolFunctionPackageContentResponse
import aws.sdk.kotlin.services.tnb.model.ValidateSolNetworkPackageContentRequest
import aws.sdk.kotlin.services.tnb.model.ValidateSolNetworkPackageContentResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "tnb"
public const val SdkVersion: String = "1.3.17"
public const val ServiceApiVersion: String = "2008-10-21"

/**
 * Amazon Web Services Telco Network Builder (TNB) is a network automation service that helps you deploy and manage telecom networks. AWS TNB helps you with the lifecycle management of your telecommunication network functions throughout planning, deployment, and post-deployment activities.
 */
public interface TnbClient : SdkClient {
    /**
     * TnbClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, TnbClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Tnb",
                "TNB",
                "tnb",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, TnbClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): TnbClient = DefaultTnbClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: TnbEndpointProvider = builder.endpointProvider ?: DefaultTnbEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: TnbAuthSchemeProvider = builder.authSchemeProvider ?: DefaultTnbAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "tnb"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: TnbEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: TnbAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels a network operation.
     *
     * A network operation is any operation that is done to your network, such as network instance instantiation or termination.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.CancelSolNetworkOperation.sample
     */
    public suspend fun cancelSolNetworkOperation(input: CancelSolNetworkOperationRequest): CancelSolNetworkOperationResponse

    /**
     * Creates a function package.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network. For more information, see [Function packages](https://docs.aws.amazon.com/tnb/latest/ug/function-packages.html) in the *Amazon Web Services Telco Network Builder User Guide*.
     *
     * Creating a function package is the first step for creating a network in AWS TNB. This request creates an empty container with an ID. The next step is to upload the actual CSAR zip file into that empty container. To upload function package content, see [PutSolFunctionPackageContent](https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html).
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.CreateSolFunctionPackage.sample
     */
    public suspend fun createSolFunctionPackage(input: CreateSolFunctionPackageRequest = CreateSolFunctionPackageRequest { }): CreateSolFunctionPackageResponse

    /**
     * Creates a network instance.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed. Creating a network instance is the third step after creating a network package. For more information about network instances, [Network instances](https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html) in the *Amazon Web Services Telco Network Builder User Guide*.
     *
     * Once you create a network instance, you can instantiate it. To instantiate a network, see [InstantiateSolNetworkInstance](https://docs.aws.amazon.com/tnb/latest/APIReference/API_InstantiateSolNetworkInstance.html).
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.CreateSolNetworkInstance.sample
     */
    public suspend fun createSolNetworkInstance(input: CreateSolNetworkInstanceRequest): CreateSolNetworkInstanceResponse

    /**
     * Creates a network package.
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on. For more information, see [Network instances](https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html) in the *Amazon Web Services Telco Network Builder User Guide*.
     *
     * A network package consists of a network service descriptor (NSD) file (required) and any additional files (optional), such as scripts specific to your needs. For example, if you have multiple function packages in your network package, you can use the NSD to define which network functions should run in certain VPCs, subnets, or EKS clusters.
     *
     * This request creates an empty network package container with an ID. Once you create a network package, you can upload the network package content using [PutSolNetworkPackageContent](https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html).
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.CreateSolNetworkPackage.sample
     */
    public suspend fun createSolNetworkPackage(input: CreateSolNetworkPackageRequest = CreateSolNetworkPackageRequest { }): CreateSolNetworkPackageResponse

    /**
     * Deletes a function package.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     *
     * To delete a function package, the package must be in a disabled state. To disable a function package, see [UpdateSolFunctionPackage](https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolFunctionPackage.html).
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.DeleteSolFunctionPackage.sample
     */
    public suspend fun deleteSolFunctionPackage(input: DeleteSolFunctionPackageRequest): DeleteSolFunctionPackageResponse

    /**
     * Deletes a network instance.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
     *
     * To delete a network instance, the instance must be in a stopped or terminated state. To terminate a network instance, see [TerminateSolNetworkInstance](https://docs.aws.amazon.com/tnb/latest/APIReference/API_TerminateSolNetworkInstance.html).
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.DeleteSolNetworkInstance.sample
     */
    public suspend fun deleteSolNetworkInstance(input: DeleteSolNetworkInstanceRequest): DeleteSolNetworkInstanceResponse

    /**
     * Deletes network package.
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
     *
     * To delete a network package, the package must be in a disable state. To disable a network package, see [UpdateSolNetworkPackage](https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolNetworkPackage.html).
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.DeleteSolNetworkPackage.sample
     */
    public suspend fun deleteSolNetworkPackage(input: DeleteSolNetworkPackageRequest): DeleteSolNetworkPackageResponse

    /**
     * Gets the details of a network function instance, including the instantiation state and metadata from the function package descriptor in the network function package.
     *
     * A network function instance is a function in a function package .
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolFunctionInstance.sample
     */
    public suspend fun getSolFunctionInstance(input: GetSolFunctionInstanceRequest): GetSolFunctionInstanceResponse

    /**
     * Gets the details of an individual function package, such as the operational state and whether the package is in use.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network..
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolFunctionPackage.sample
     */
    public suspend fun getSolFunctionPackage(input: GetSolFunctionPackageRequest): GetSolFunctionPackageResponse

    /**
     * Gets the contents of a function package.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolFunctionPackageContent.sample
     */
    public suspend fun getSolFunctionPackageContent(input: GetSolFunctionPackageContentRequest): GetSolFunctionPackageContentResponse

    /**
     * Gets a function package descriptor in a function package.
     *
     * A function package descriptor is a .yaml file in a function package that uses the TOSCA standard to describe how the network function in the function package should run on your network.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolFunctionPackageDescriptor.sample
     */
    public suspend fun getSolFunctionPackageDescriptor(input: GetSolFunctionPackageDescriptorRequest): GetSolFunctionPackageDescriptorResponse

    /**
     * Gets the details of the network instance.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkInstance.sample
     */
    public suspend fun getSolNetworkInstance(input: GetSolNetworkInstanceRequest): GetSolNetworkInstanceResponse

    /**
     * Gets the details of a network operation, including the tasks involved in the network operation and the status of the tasks.
     *
     * A network operation is any operation that is done to your network, such as network instance instantiation or termination.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkOperation.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkOperation.sample2
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkOperation.sample3
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkOperation.sample4
     */
    public suspend fun getSolNetworkOperation(input: GetSolNetworkOperationRequest): GetSolNetworkOperationResponse

    /**
     * Gets the details of a network package.
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkPackage.sample
     */
    public suspend fun getSolNetworkPackage(input: GetSolNetworkPackageRequest): GetSolNetworkPackageResponse

    /**
     * Gets the contents of a network package.
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkPackageContent.sample
     */
    public suspend fun getSolNetworkPackageContent(input: GetSolNetworkPackageContentRequest): GetSolNetworkPackageContentResponse

    /**
     * Gets the content of the network service descriptor.
     *
     * A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network functions on.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkPackageDescriptor.sample
     */
    public suspend fun getSolNetworkPackageDescriptor(input: GetSolNetworkPackageDescriptorRequest): GetSolNetworkPackageDescriptorResponse

    /**
     * Instantiates a network instance.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
     *
     * Before you can instantiate a network instance, you have to create a network instance. For more information, see [CreateSolNetworkInstance](https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolNetworkInstance.html).
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.InstantiateSolNetworkInstance.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.InstantiateSolNetworkInstance.sample2
     */
    public suspend fun instantiateSolNetworkInstance(input: InstantiateSolNetworkInstanceRequest): InstantiateSolNetworkInstanceResponse

    /**
     * Lists network function instances.
     *
     * A network function instance is a function in a function package .
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionInstances.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionInstances.sample2
     */
    public suspend fun listSolFunctionInstances(input: ListSolFunctionInstancesRequest = ListSolFunctionInstancesRequest { }): ListSolFunctionInstancesResponse

    /**
     * Lists information about function packages.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionPackages.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionPackages.sample2
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionPackages.sample3
     */
    public suspend fun listSolFunctionPackages(input: ListSolFunctionPackagesRequest = ListSolFunctionPackagesRequest { }): ListSolFunctionPackagesResponse

    /**
     * Lists your network instances.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkInstances.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkInstances.sample2
     */
    public suspend fun listSolNetworkInstances(input: ListSolNetworkInstancesRequest = ListSolNetworkInstancesRequest { }): ListSolNetworkInstancesResponse

    /**
     * Lists details for a network operation, including when the operation started and the status of the operation.
     *
     * A network operation is any operation that is done to your network, such as network instance instantiation or termination.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkOperations.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkOperations.sample2
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkOperations.sample3
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkOperations.sample4
     */
    public suspend fun listSolNetworkOperations(input: ListSolNetworkOperationsRequest = ListSolNetworkOperationsRequest { }): ListSolNetworkOperationsResponse

    /**
     * Lists network packages.
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkPackages.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkPackages.sample2
     * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkPackages.sample3
     */
    public suspend fun listSolNetworkPackages(input: ListSolNetworkPackagesRequest = ListSolNetworkPackagesRequest { }): ListSolNetworkPackagesResponse

    /**
     * Lists tags for AWS TNB resources.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Uploads the contents of a function package.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.PutSolFunctionPackageContent.sample
     */
    public suspend fun putSolFunctionPackageContent(input: PutSolFunctionPackageContentRequest): PutSolFunctionPackageContentResponse

    /**
     * Uploads the contents of a network package.
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.PutSolNetworkPackageContent.sample
     */
    public suspend fun putSolNetworkPackageContent(input: PutSolNetworkPackageContentRequest): PutSolNetworkPackageContentResponse

    /**
     * Tags an AWS TNB resource.
     *
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Terminates a network instance.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
     *
     * You must terminate a network instance before you can delete it.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.TerminateSolNetworkInstance.sample
     */
    public suspend fun terminateSolNetworkInstance(input: TerminateSolNetworkInstanceRequest): TerminateSolNetworkInstanceResponse

    /**
     * Untags an AWS TNB resource.
     *
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the operational state of function package.
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolFunctionPackage.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolFunctionPackage.sample2
     */
    public suspend fun updateSolFunctionPackage(input: UpdateSolFunctionPackageRequest): UpdateSolFunctionPackageResponse

    /**
     * Update a network instance.
     *
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
     *
     * Choose the *updateType* parameter to target the necessary update of the network instance.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolNetworkInstance.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolNetworkInstance.sample2
     */
    public suspend fun updateSolNetworkInstance(input: UpdateSolNetworkInstanceRequest): UpdateSolNetworkInstanceResponse

    /**
     * Updates the operational state of a network package.
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
     *
     * A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network functions on.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolNetworkPackage.sample
     * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolNetworkPackage.sample2
     */
    public suspend fun updateSolNetworkPackage(input: UpdateSolNetworkPackageRequest): UpdateSolNetworkPackageResponse

    /**
     * Validates function package content. This can be used as a dry run before uploading function package content with [PutSolFunctionPackageContent](https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html).
     *
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.ValidateSolFunctionPackageContent.sample
     */
    public suspend fun validateSolFunctionPackageContent(input: ValidateSolFunctionPackageContentRequest): ValidateSolFunctionPackageContentResponse

    /**
     * Validates network package content. This can be used as a dry run before uploading network package content with [PutSolNetworkPackageContent](https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html).
     *
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
     *
     * @sample aws.sdk.kotlin.services.tnb.samples.ValidateSolNetworkPackageContent.sample
     */
    public suspend fun validateSolNetworkPackageContent(input: ValidateSolNetworkPackageContentRequest): ValidateSolNetworkPackageContentResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun TnbClient.withConfig(block: TnbClient.Config.Builder.() -> Unit): TnbClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultTnbClient(newConfig)
}

/**
 * Cancels a network operation.
 *
 * A network operation is any operation that is done to your network, such as network instance instantiation or termination.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.CancelSolNetworkOperation.sample
 */
public suspend inline fun TnbClient.cancelSolNetworkOperation(crossinline block: CancelSolNetworkOperationRequest.Builder.() -> Unit): CancelSolNetworkOperationResponse = cancelSolNetworkOperation(CancelSolNetworkOperationRequest.Builder().apply(block).build())

/**
 * Creates a function package.
 *
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network. For more information, see [Function packages](https://docs.aws.amazon.com/tnb/latest/ug/function-packages.html) in the *Amazon Web Services Telco Network Builder User Guide*.
 *
 * Creating a function package is the first step for creating a network in AWS TNB. This request creates an empty container with an ID. The next step is to upload the actual CSAR zip file into that empty container. To upload function package content, see [PutSolFunctionPackageContent](https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html).
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.CreateSolFunctionPackage.sample
 */
public suspend inline fun TnbClient.createSolFunctionPackage(crossinline block: CreateSolFunctionPackageRequest.Builder.() -> Unit): CreateSolFunctionPackageResponse = createSolFunctionPackage(CreateSolFunctionPackageRequest.Builder().apply(block).build())

/**
 * Creates a network instance.
 *
 * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed. Creating a network instance is the third step after creating a network package. For more information about network instances, [Network instances](https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html) in the *Amazon Web Services Telco Network Builder User Guide*.
 *
 * Once you create a network instance, you can instantiate it. To instantiate a network, see [InstantiateSolNetworkInstance](https://docs.aws.amazon.com/tnb/latest/APIReference/API_InstantiateSolNetworkInstance.html).
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.CreateSolNetworkInstance.sample
 */
public suspend inline fun TnbClient.createSolNetworkInstance(crossinline block: CreateSolNetworkInstanceRequest.Builder.() -> Unit): CreateSolNetworkInstanceResponse = createSolNetworkInstance(CreateSolNetworkInstanceRequest.Builder().apply(block).build())

/**
 * Creates a network package.
 *
 * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on. For more information, see [Network instances](https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html) in the *Amazon Web Services Telco Network Builder User Guide*.
 *
 * A network package consists of a network service descriptor (NSD) file (required) and any additional files (optional), such as scripts specific to your needs. For example, if you have multiple function packages in your network package, you can use the NSD to define which network functions should run in certain VPCs, subnets, or EKS clusters.
 *
 * This request creates an empty network package container with an ID. Once you create a network package, you can upload the network package content using [PutSolNetworkPackageContent](https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html).
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.CreateSolNetworkPackage.sample
 */
public suspend inline fun TnbClient.createSolNetworkPackage(crossinline block: CreateSolNetworkPackageRequest.Builder.() -> Unit): CreateSolNetworkPackageResponse = createSolNetworkPackage(CreateSolNetworkPackageRequest.Builder().apply(block).build())

/**
 * Deletes a function package.
 *
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
 *
 * To delete a function package, the package must be in a disabled state. To disable a function package, see [UpdateSolFunctionPackage](https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolFunctionPackage.html).
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.DeleteSolFunctionPackage.sample
 */
public suspend inline fun TnbClient.deleteSolFunctionPackage(crossinline block: DeleteSolFunctionPackageRequest.Builder.() -> Unit): DeleteSolFunctionPackageResponse = deleteSolFunctionPackage(DeleteSolFunctionPackageRequest.Builder().apply(block).build())

/**
 * Deletes a network instance.
 *
 * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
 *
 * To delete a network instance, the instance must be in a stopped or terminated state. To terminate a network instance, see [TerminateSolNetworkInstance](https://docs.aws.amazon.com/tnb/latest/APIReference/API_TerminateSolNetworkInstance.html).
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.DeleteSolNetworkInstance.sample
 */
public suspend inline fun TnbClient.deleteSolNetworkInstance(crossinline block: DeleteSolNetworkInstanceRequest.Builder.() -> Unit): DeleteSolNetworkInstanceResponse = deleteSolNetworkInstance(DeleteSolNetworkInstanceRequest.Builder().apply(block).build())

/**
 * Deletes network package.
 *
 * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
 *
 * To delete a network package, the package must be in a disable state. To disable a network package, see [UpdateSolNetworkPackage](https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolNetworkPackage.html).
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.DeleteSolNetworkPackage.sample
 */
public suspend inline fun TnbClient.deleteSolNetworkPackage(crossinline block: DeleteSolNetworkPackageRequest.Builder.() -> Unit): DeleteSolNetworkPackageResponse = deleteSolNetworkPackage(DeleteSolNetworkPackageRequest.Builder().apply(block).build())

/**
 * Gets the details of a network function instance, including the instantiation state and metadata from the function package descriptor in the network function package.
 *
 * A network function instance is a function in a function package .
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.GetSolFunctionInstance.sample
 */
public suspend inline fun TnbClient.getSolFunctionInstance(crossinline block: GetSolFunctionInstanceRequest.Builder.() -> Unit): GetSolFunctionInstanceResponse = getSolFunctionInstance(GetSolFunctionInstanceRequest.Builder().apply(block).build())

/**
 * Gets the details of an individual function package, such as the operational state and whether the package is in use.
 *
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network..
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.GetSolFunctionPackage.sample
 */
public suspend inline fun TnbClient.getSolFunctionPackage(crossinline block: GetSolFunctionPackageRequest.Builder.() -> Unit): GetSolFunctionPackageResponse = getSolFunctionPackage(GetSolFunctionPackageRequest.Builder().apply(block).build())

/**
 * Gets the contents of a function package.
 *
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.GetSolFunctionPackageContent.sample
 */
public suspend inline fun TnbClient.getSolFunctionPackageContent(crossinline block: GetSolFunctionPackageContentRequest.Builder.() -> Unit): GetSolFunctionPackageContentResponse = getSolFunctionPackageContent(GetSolFunctionPackageContentRequest.Builder().apply(block).build())

/**
 * Gets a function package descriptor in a function package.
 *
 * A function package descriptor is a .yaml file in a function package that uses the TOSCA standard to describe how the network function in the function package should run on your network.
 *
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.GetSolFunctionPackageDescriptor.sample
 */
public suspend inline fun TnbClient.getSolFunctionPackageDescriptor(crossinline block: GetSolFunctionPackageDescriptorRequest.Builder.() -> Unit): GetSolFunctionPackageDescriptorResponse = getSolFunctionPackageDescriptor(GetSolFunctionPackageDescriptorRequest.Builder().apply(block).build())

/**
 * Gets the details of the network instance.
 *
 * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkInstance.sample
 */
public suspend inline fun TnbClient.getSolNetworkInstance(crossinline block: GetSolNetworkInstanceRequest.Builder.() -> Unit): GetSolNetworkInstanceResponse = getSolNetworkInstance(GetSolNetworkInstanceRequest.Builder().apply(block).build())

/**
 * Gets the details of a network operation, including the tasks involved in the network operation and the status of the tasks.
 *
 * A network operation is any operation that is done to your network, such as network instance instantiation or termination.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkOperation.sample
 * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkOperation.sample2
 * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkOperation.sample3
 * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkOperation.sample4
 */
public suspend inline fun TnbClient.getSolNetworkOperation(crossinline block: GetSolNetworkOperationRequest.Builder.() -> Unit): GetSolNetworkOperationResponse = getSolNetworkOperation(GetSolNetworkOperationRequest.Builder().apply(block).build())

/**
 * Gets the details of a network package.
 *
 * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkPackage.sample
 */
public suspend inline fun TnbClient.getSolNetworkPackage(crossinline block: GetSolNetworkPackageRequest.Builder.() -> Unit): GetSolNetworkPackageResponse = getSolNetworkPackage(GetSolNetworkPackageRequest.Builder().apply(block).build())

/**
 * Gets the contents of a network package.
 *
 * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkPackageContent.sample
 */
public suspend inline fun TnbClient.getSolNetworkPackageContent(crossinline block: GetSolNetworkPackageContentRequest.Builder.() -> Unit): GetSolNetworkPackageContentResponse = getSolNetworkPackageContent(GetSolNetworkPackageContentRequest.Builder().apply(block).build())

/**
 * Gets the content of the network service descriptor.
 *
 * A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network functions on.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.GetSolNetworkPackageDescriptor.sample
 */
public suspend inline fun TnbClient.getSolNetworkPackageDescriptor(crossinline block: GetSolNetworkPackageDescriptorRequest.Builder.() -> Unit): GetSolNetworkPackageDescriptorResponse = getSolNetworkPackageDescriptor(GetSolNetworkPackageDescriptorRequest.Builder().apply(block).build())

/**
 * Instantiates a network instance.
 *
 * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
 *
 * Before you can instantiate a network instance, you have to create a network instance. For more information, see [CreateSolNetworkInstance](https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolNetworkInstance.html).
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.InstantiateSolNetworkInstance.sample
 * @sample aws.sdk.kotlin.services.tnb.samples.InstantiateSolNetworkInstance.sample2
 */
public suspend inline fun TnbClient.instantiateSolNetworkInstance(crossinline block: InstantiateSolNetworkInstanceRequest.Builder.() -> Unit): InstantiateSolNetworkInstanceResponse = instantiateSolNetworkInstance(InstantiateSolNetworkInstanceRequest.Builder().apply(block).build())

/**
 * Lists network function instances.
 *
 * A network function instance is a function in a function package .
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionInstances.sample
 * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionInstances.sample2
 */
public suspend inline fun TnbClient.listSolFunctionInstances(crossinline block: ListSolFunctionInstancesRequest.Builder.() -> Unit): ListSolFunctionInstancesResponse = listSolFunctionInstances(ListSolFunctionInstancesRequest.Builder().apply(block).build())

/**
 * Lists information about function packages.
 *
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionPackages.sample
 * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionPackages.sample2
 * @sample aws.sdk.kotlin.services.tnb.samples.ListSolFunctionPackages.sample3
 */
public suspend inline fun TnbClient.listSolFunctionPackages(crossinline block: ListSolFunctionPackagesRequest.Builder.() -> Unit): ListSolFunctionPackagesResponse = listSolFunctionPackages(ListSolFunctionPackagesRequest.Builder().apply(block).build())

/**
 * Lists your network instances.
 *
 * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkInstances.sample
 * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkInstances.sample2
 */
public suspend inline fun TnbClient.listSolNetworkInstances(crossinline block: ListSolNetworkInstancesRequest.Builder.() -> Unit): ListSolNetworkInstancesResponse = listSolNetworkInstances(ListSolNetworkInstancesRequest.Builder().apply(block).build())

/**
 * Lists details for a network operation, including when the operation started and the status of the operation.
 *
 * A network operation is any operation that is done to your network, such as network instance instantiation or termination.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkOperations.sample
 * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkOperations.sample2
 * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkOperations.sample3
 * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkOperations.sample4
 */
public suspend inline fun TnbClient.listSolNetworkOperations(crossinline block: ListSolNetworkOperationsRequest.Builder.() -> Unit): ListSolNetworkOperationsResponse = listSolNetworkOperations(ListSolNetworkOperationsRequest.Builder().apply(block).build())

/**
 * Lists network packages.
 *
 * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkPackages.sample
 * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkPackages.sample2
 * @sample aws.sdk.kotlin.services.tnb.samples.ListSolNetworkPackages.sample3
 */
public suspend inline fun TnbClient.listSolNetworkPackages(crossinline block: ListSolNetworkPackagesRequest.Builder.() -> Unit): ListSolNetworkPackagesResponse = listSolNetworkPackages(ListSolNetworkPackagesRequest.Builder().apply(block).build())

/**
 * Lists tags for AWS TNB resources.
 */
public suspend inline fun TnbClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Uploads the contents of a function package.
 *
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.PutSolFunctionPackageContent.sample
 */
public suspend inline fun TnbClient.putSolFunctionPackageContent(crossinline block: PutSolFunctionPackageContentRequest.Builder.() -> Unit): PutSolFunctionPackageContentResponse = putSolFunctionPackageContent(PutSolFunctionPackageContentRequest.Builder().apply(block).build())

/**
 * Uploads the contents of a network package.
 *
 * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.PutSolNetworkPackageContent.sample
 */
public suspend inline fun TnbClient.putSolNetworkPackageContent(crossinline block: PutSolNetworkPackageContentRequest.Builder.() -> Unit): PutSolNetworkPackageContentResponse = putSolNetworkPackageContent(PutSolNetworkPackageContentRequest.Builder().apply(block).build())

/**
 * Tags an AWS TNB resource.
 *
 * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
 */
public suspend inline fun TnbClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Terminates a network instance.
 *
 * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
 *
 * You must terminate a network instance before you can delete it.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.TerminateSolNetworkInstance.sample
 */
public suspend inline fun TnbClient.terminateSolNetworkInstance(crossinline block: TerminateSolNetworkInstanceRequest.Builder.() -> Unit): TerminateSolNetworkInstanceResponse = terminateSolNetworkInstance(TerminateSolNetworkInstanceRequest.Builder().apply(block).build())

/**
 * Untags an AWS TNB resource.
 *
 * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
 */
public suspend inline fun TnbClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the operational state of function package.
 *
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolFunctionPackage.sample
 * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolFunctionPackage.sample2
 */
public suspend inline fun TnbClient.updateSolFunctionPackage(crossinline block: UpdateSolFunctionPackageRequest.Builder.() -> Unit): UpdateSolFunctionPackageResponse = updateSolFunctionPackage(UpdateSolFunctionPackageRequest.Builder().apply(block).build())

/**
 * Update a network instance.
 *
 * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which life-cycle operations (like terminate, update, and delete) can be performed.
 *
 * Choose the *updateType* parameter to target the necessary update of the network instance.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolNetworkInstance.sample
 * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolNetworkInstance.sample2
 */
public suspend inline fun TnbClient.updateSolNetworkInstance(crossinline block: UpdateSolNetworkInstanceRequest.Builder.() -> Unit): UpdateSolNetworkInstanceResponse = updateSolNetworkInstance(UpdateSolNetworkInstanceRequest.Builder().apply(block).build())

/**
 * Updates the operational state of a network package.
 *
 * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
 *
 * A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network functions on.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolNetworkPackage.sample
 * @sample aws.sdk.kotlin.services.tnb.samples.UpdateSolNetworkPackage.sample2
 */
public suspend inline fun TnbClient.updateSolNetworkPackage(crossinline block: UpdateSolNetworkPackageRequest.Builder.() -> Unit): UpdateSolNetworkPackageResponse = updateSolNetworkPackage(UpdateSolNetworkPackageRequest.Builder().apply(block).build())

/**
 * Validates function package content. This can be used as a dry run before uploading function package content with [PutSolFunctionPackageContent](https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html).
 *
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how the network functions should run on your network.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.ValidateSolFunctionPackageContent.sample
 */
public suspend inline fun TnbClient.validateSolFunctionPackageContent(crossinline block: ValidateSolFunctionPackageContentRequest.Builder.() -> Unit): ValidateSolFunctionPackageContentResponse = validateSolFunctionPackageContent(ValidateSolFunctionPackageContentRequest.Builder().apply(block).build())

/**
 * Validates network package content. This can be used as a dry run before uploading network package content with [PutSolNetworkPackageContent](https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html).
 *
 * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to deploy and the Amazon Web Services infrastructure you want to deploy them on.
 *
 * @sample aws.sdk.kotlin.services.tnb.samples.ValidateSolNetworkPackageContent.sample
 */
public suspend inline fun TnbClient.validateSolNetworkPackageContent(crossinline block: ValidateSolNetworkPackageContentRequest.Builder.() -> Unit): ValidateSolNetworkPackageContentResponse = validateSolNetworkPackageContent(ValidateSolNetworkPackageContentRequest.Builder().apply(block).build())
