// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the metadata attributes of the time series. For example, the name and Availability Zone of an EC2 instance or the name of the manufacturer of a wind turbine are dimensions.
 */
public class Dimension private constructor(builder: Builder) {
    /**
     * The data type of the dimension for the time-series data point.
     */
    public val dimensionValueType: aws.sdk.kotlin.services.timestreamwrite.model.DimensionValueType? = builder.dimensionValueType
    /**
     * Dimension represents the metadata attributes of the time series. For example, the name and Availability Zone of an EC2 instance or the name of the manufacturer of a wind turbine are dimensions.
     *
     * For constraints on dimension names, see [Naming Constraints](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming).
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The value of the dimension.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamwrite.model.Dimension = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Dimension(")
        append("dimensionValueType=$dimensionValueType,")
        append("name=$name,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensionValueType?.hashCode() ?: 0
        result = 31 * result + (name.hashCode())
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Dimension

        if (dimensionValueType != other.dimensionValueType) return false
        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamwrite.model.Dimension = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The data type of the dimension for the time-series data point.
         */
        public var dimensionValueType: aws.sdk.kotlin.services.timestreamwrite.model.DimensionValueType? = null
        /**
         * Dimension represents the metadata attributes of the time series. For example, the name and Availability Zone of an EC2 instance or the name of the manufacturer of a wind turbine are dimensions.
         *
         * For constraints on dimension names, see [Naming Constraints](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming).
         */
        public var name: kotlin.String? = null
        /**
         * The value of the dimension.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamwrite.model.Dimension) : this() {
            this.dimensionValueType = x.dimensionValueType
            this.name = x.name
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamwrite.model.Dimension = Dimension(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (value == null) value = ""
            return this
        }
    }
}
