// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A top-level container for a table. Databases and tables are the fundamental management concepts in Amazon Timestream. All tables in a database are encrypted with the same KMS key.
 */
public class Database private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name that uniquely identifies this database.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time when the database was created, calculated from the Unix epoch time.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The name of the Timestream database.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The identifier of the KMS key used to encrypt the data stored in the database.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The last time that this database was updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The total number of tables found within a Timestream database.
     */
    public val tableCount: kotlin.Long = builder.tableCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamwrite.model.Database = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Database(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("databaseName=$databaseName,")
        append("kmsKeyId=$kmsKeyId,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("tableCount=$tableCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (tableCount.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Database

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (databaseName != other.databaseName) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (tableCount != other.tableCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamwrite.model.Database = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name that uniquely identifies this database.
         */
        public var arn: kotlin.String? = null
        /**
         * The time when the database was created, calculated from the Unix epoch time.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Timestream database.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The identifier of the KMS key used to encrypt the data stored in the database.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The last time that this database was updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The total number of tables found within a Timestream database.
         */
        public var tableCount: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamwrite.model.Database) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.databaseName = x.databaseName
            this.kmsKeyId = x.kmsKeyId
            this.lastUpdatedTime = x.lastUpdatedTime
            this.tableCount = x.tableCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamwrite.model.Database = Database(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
