// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite.endpoints

import aws.sdk.kotlin.services.timestreamwrite.TimestreamWriteClient
import aws.smithy.kotlin.runtime.auth.awscredentials.Credentials
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.collections.ExpiringKeyedCache
import aws.smithy.kotlin.runtime.collections.PeriodicSweepCache
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.net.Host
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import kotlin.time.Duration.Companion.minutes

/**
 * A class which looks up specific endpoints for TimestreamWrite calls via the `describeEndpoints` API. These
 * unique endpoints are cached as appropriate to avoid unnecessary latency in subsequent calls.
 * @param cache An [ExpiringKeyedCache] implementation used to cache discovered hosts
 */
public class DefaultTimestreamWriteEndpointDiscoverer(public val cache: ExpiringKeyedCache<DiscoveryParams, Host> = PeriodicSweepCache(10.minutes)) : TimestreamWriteEndpointDiscoverer {
    override fun asEndpointResolver(client: TimestreamWriteClient, delegate: EndpointResolver): EndpointResolver = EndpointResolver { request ->
        if (client.config.endpointUrl == null) {
            val identity = request.identity
            require(identity is Credentials) { "Endpoint discovery requires AWS credentials" }

            val cacheKey = DiscoveryParams(client.config.region, identity.accessKeyId)
            request.context[DiscoveryParamsKey] = cacheKey
            val discoveredHost = cache.get(cacheKey) { discoverHost(client) }

            val originalEndpoint = delegate.resolve(request)
            Endpoint(
                originalEndpoint.uri.copy { host = discoveredHost },
                originalEndpoint.headers,
                originalEndpoint.attributes,
            )
        } else {
            delegate.resolve(request)
        }
    }

    override public suspend fun invalidate(context: ExecutionContext) {
        context.getOrNull(DiscoveryParamsKey)?.let { cache.invalidate(it) }
    }
}
