// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * WriteRecords would throw this exception in the following cases:
 * + Records with duplicate data where there are multiple records with the same dimensions, timestamps, and measure names but:
 *    + Measure values are different
 *    + Version is not present in the request *or* the value of version in the new record is equal to or lower than the existing value
 *  In this case, if Timestream rejects data, the `ExistingVersion` field in the `RejectedRecords` response will indicate the current record’s version. To force an update, you can resend the request with a version for the record set to a value greater than the `ExistingVersion`.
 * +  Records with timestamps that lie outside the retention duration of the memory store.
 * +  Records with dimensions or measures that exceed the Timestream defined limits.
 *
 *  For more information, see [Quotas](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html) in the Amazon Timestream Developer Guide.
 */
public class RejectedRecordsException private constructor(builder: Builder) : TimestreamWriteException(builder.message) {

    /**
     *
     */
    public val rejectedRecords: List<RejectedRecord>? = builder.rejectedRecords

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamwrite.model.RejectedRecordsException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RejectedRecordsException(")
        append("message=$message,")
        append("rejectedRecords=$rejectedRecords")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (this.rejectedRecords?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RejectedRecordsException

        if (message != other.message) return false
        if (rejectedRecords != other.rejectedRecords) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamwrite.model.RejectedRecordsException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        public var message: kotlin.String? = null
        /**
         *
         */
        public var rejectedRecords: List<RejectedRecord>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamwrite.model.RejectedRecordsException) : this() {
            this.message = x.message
            this.rejectedRecords = x.rejectedRecords
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamwrite.model.RejectedRecordsException = RejectedRecordsException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
