// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the data attribute of the time series. For example, the CPU utilization of an EC2 instance or the RPM of a wind turbine are measures. MeasureValue has both name and value.
 *
 *  MeasureValue is only allowed for type `MULTI`. Using `MULTI` type, you can pass multiple data attributes associated with the same time series in a single record
 */
public class MeasureValue private constructor(builder: Builder) {
    /**
     * The name of the MeasureValue.
     *
     *  For constraints on MeasureValue names, see [ Naming Constraints](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming) in the Amazon Timestream Developer Guide.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Contains the data type of the MeasureValue for the time-series data point.
     */
    public val type: aws.sdk.kotlin.services.timestreamwrite.model.MeasureValueType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * The value for the MeasureValue. For information, see [Data types](https://docs.aws.amazon.com/timestream/latest/developerguide/writes.html#writes.data-types).
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamwrite.model.MeasureValue = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MeasureValue(")
        append("name=$name,")
        append("type=$type,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name.hashCode()
        result = 31 * result + (this.type.hashCode())
        result = 31 * result + (this.value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MeasureValue

        if (name != other.name) return false
        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamwrite.model.MeasureValue = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the MeasureValue.
         *
         *  For constraints on MeasureValue names, see [ Naming Constraints](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html#limits.naming) in the Amazon Timestream Developer Guide.
         */
        public var name: kotlin.String? = null
        /**
         * Contains the data type of the MeasureValue for the time-series data point.
         */
        public var type: aws.sdk.kotlin.services.timestreamwrite.model.MeasureValueType? = null
        /**
         * The value for the MeasureValue. For information, see [Data types](https://docs.aws.amazon.com/timestream/latest/developerguide/writes.html#writes.data-types).
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamwrite.model.MeasureValue) : this() {
            this.name = x.name
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamwrite.model.MeasureValue = MeasureValue(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (type == null) type = MeasureValueType.SdkUnknown("no value provided")
            if (value == null) value = ""
            return this
        }
    }
}
