// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite.endpoints

import aws.sdk.kotlin.services.timestreamwrite.TimestreamWriteClient
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.collections.AttributeKey
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.net.Host
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.util.ExpiringValue
import kotlin.time.Duration.Companion.minutes

/**
 * Represents the logic for automatically discovering endpoints for Timestream Write calls
 */
public interface TimestreamWriteEndpointDiscoverer {
    public fun asEndpointResolver(client: TimestreamWriteClient, delegate: EndpointResolver): EndpointResolver

    public suspend fun discoverHost(client: TimestreamWriteClient): ExpiringValue<Host> =
        client.describeEndpoints()
            .endpoints
            ?.map { ep -> ExpiringValue(
                Host.parse(ep.address!!),
                Instant.now() + ep.cachePeriodInMinutes.minutes,
            )}
            ?.firstOrNull()
            ?: throw EndpointProviderException("Unable to discover any endpoints when invoking describeEndpoints!")

    public suspend fun invalidate(context: ExecutionContext)
}

public data class DiscoveryParams(private val region: String?, private val identity: String)
public val DiscoveryParamsKey: AttributeKey<DiscoveryParams> = AttributeKey("DiscoveryParams")
