// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite.model

import aws.smithy.kotlin.runtime.SdkDsl

public class WriteRecordsRequest private constructor(builder: Builder) {
    /**
     * A record that contains the common measure, dimension, time, and version attributes shared across all the records in the request. The measure and dimension attributes specified will be merged with the measure and dimension attributes in the records object when the data is written into Timestream. Dimensions may not overlap, or a `ValidationException` will be thrown. In other words, a record must contain dimensions with unique names.
     */
    public val commonAttributes: aws.sdk.kotlin.services.timestreamwrite.model.Record? = builder.commonAttributes
    /**
     * The name of the Timestream database.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * An array of records that contain the unique measure, dimension, time, and version attributes for each time-series data point.
     */
    public val records: List<Record>? = builder.records
    /**
     * The name of the Timestream table.
     */
    public val tableName: kotlin.String? = builder.tableName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamwrite.model.WriteRecordsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WriteRecordsRequest(")
        append("commonAttributes=$commonAttributes,")
        append("databaseName=$databaseName,")
        append("records=$records,")
        append("tableName=$tableName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = commonAttributes?.hashCode() ?: 0
        result = 31 * result + (this.databaseName?.hashCode() ?: 0)
        result = 31 * result + (this.records?.hashCode() ?: 0)
        result = 31 * result + (this.tableName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WriteRecordsRequest

        if (commonAttributes != other.commonAttributes) return false
        if (databaseName != other.databaseName) return false
        if (records != other.records) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamwrite.model.WriteRecordsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A record that contains the common measure, dimension, time, and version attributes shared across all the records in the request. The measure and dimension attributes specified will be merged with the measure and dimension attributes in the records object when the data is written into Timestream. Dimensions may not overlap, or a `ValidationException` will be thrown. In other words, a record must contain dimensions with unique names.
         */
        public var commonAttributes: aws.sdk.kotlin.services.timestreamwrite.model.Record? = null
        /**
         * The name of the Timestream database.
         */
        public var databaseName: kotlin.String? = null
        /**
         * An array of records that contain the unique measure, dimension, time, and version attributes for each time-series data point.
         */
        public var records: List<Record>? = null
        /**
         * The name of the Timestream table.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamwrite.model.WriteRecordsRequest) : this() {
            this.commonAttributes = x.commonAttributes
            this.databaseName = x.databaseName
            this.records = x.records
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamwrite.model.WriteRecordsRequest = WriteRecordsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.timestreamwrite.model.Record] inside the given [block]
         */
        public fun commonAttributes(block: aws.sdk.kotlin.services.timestreamwrite.model.Record.Builder.() -> kotlin.Unit) {
            this.commonAttributes = aws.sdk.kotlin.services.timestreamwrite.model.Record.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
