// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration that specifies an S3 location.
 */
public class S3Configuration private constructor(builder: Builder) {
    /**
     * The bucket name of the customer S3 bucket.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * The encryption option for the customer S3 location. Options are S3 server-side encryption with an S3 managed key or Amazon Web Services managed key.
     */
    public val encryptionOption: aws.sdk.kotlin.services.timestreamwrite.model.S3EncryptionOption? = builder.encryptionOption
    /**
     * The KMS key ID for the customer S3 location when encrypting with an Amazon Web Services managed key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The object key preview for the customer S3 location.
     */
    public val objectKeyPrefix: kotlin.String? = builder.objectKeyPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamwrite.model.S3Configuration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Configuration(")
        append("bucketName=$bucketName,")
        append("encryptionOption=$encryptionOption,")
        append("kmsKeyId=$kmsKeyId,")
        append("objectKeyPrefix=$objectKeyPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (this.encryptionOption?.hashCode() ?: 0)
        result = 31 * result + (this.kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (this.objectKeyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Configuration

        if (bucketName != other.bucketName) return false
        if (encryptionOption != other.encryptionOption) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (objectKeyPrefix != other.objectKeyPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamwrite.model.S3Configuration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The bucket name of the customer S3 bucket.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The encryption option for the customer S3 location. Options are S3 server-side encryption with an S3 managed key or Amazon Web Services managed key.
         */
        public var encryptionOption: aws.sdk.kotlin.services.timestreamwrite.model.S3EncryptionOption? = null
        /**
         * The KMS key ID for the customer S3 location when encrypting with an Amazon Web Services managed key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The object key preview for the customer S3 location.
         */
        public var objectKeyPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamwrite.model.S3Configuration) : this() {
            this.bucketName = x.bucketName
            this.encryptionOption = x.encryptionOption
            this.kmsKeyId = x.kmsKeyId
            this.objectKeyPrefix = x.objectKeyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamwrite.model.S3Configuration = S3Configuration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
