// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointDiscoveryEnabled
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.timestreamwrite.auth.DefaultTimestreamWriteAuthSchemeProvider
import aws.sdk.kotlin.services.timestreamwrite.auth.TimestreamWriteAuthSchemeProvider
import aws.sdk.kotlin.services.timestreamwrite.endpoints.DefaultTimestreamWriteEndpointDiscoverer
import aws.sdk.kotlin.services.timestreamwrite.endpoints.DefaultTimestreamWriteEndpointProvider
import aws.sdk.kotlin.services.timestreamwrite.endpoints.TimestreamWriteEndpointDiscoverer
import aws.sdk.kotlin.services.timestreamwrite.endpoints.TimestreamWriteEndpointParameters
import aws.sdk.kotlin.services.timestreamwrite.endpoints.TimestreamWriteEndpointProvider
import aws.sdk.kotlin.services.timestreamwrite.model.CreateBatchLoadTaskRequest
import aws.sdk.kotlin.services.timestreamwrite.model.CreateBatchLoadTaskResponse
import aws.sdk.kotlin.services.timestreamwrite.model.CreateDatabaseRequest
import aws.sdk.kotlin.services.timestreamwrite.model.CreateDatabaseResponse
import aws.sdk.kotlin.services.timestreamwrite.model.CreateTableRequest
import aws.sdk.kotlin.services.timestreamwrite.model.CreateTableResponse
import aws.sdk.kotlin.services.timestreamwrite.model.DeleteDatabaseRequest
import aws.sdk.kotlin.services.timestreamwrite.model.DeleteDatabaseResponse
import aws.sdk.kotlin.services.timestreamwrite.model.DeleteTableRequest
import aws.sdk.kotlin.services.timestreamwrite.model.DeleteTableResponse
import aws.sdk.kotlin.services.timestreamwrite.model.DescribeBatchLoadTaskRequest
import aws.sdk.kotlin.services.timestreamwrite.model.DescribeBatchLoadTaskResponse
import aws.sdk.kotlin.services.timestreamwrite.model.DescribeDatabaseRequest
import aws.sdk.kotlin.services.timestreamwrite.model.DescribeDatabaseResponse
import aws.sdk.kotlin.services.timestreamwrite.model.DescribeEndpointsRequest
import aws.sdk.kotlin.services.timestreamwrite.model.DescribeEndpointsResponse
import aws.sdk.kotlin.services.timestreamwrite.model.DescribeTableRequest
import aws.sdk.kotlin.services.timestreamwrite.model.DescribeTableResponse
import aws.sdk.kotlin.services.timestreamwrite.model.ListBatchLoadTasksRequest
import aws.sdk.kotlin.services.timestreamwrite.model.ListBatchLoadTasksResponse
import aws.sdk.kotlin.services.timestreamwrite.model.ListDatabasesRequest
import aws.sdk.kotlin.services.timestreamwrite.model.ListDatabasesResponse
import aws.sdk.kotlin.services.timestreamwrite.model.ListTablesRequest
import aws.sdk.kotlin.services.timestreamwrite.model.ListTablesResponse
import aws.sdk.kotlin.services.timestreamwrite.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.timestreamwrite.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.timestreamwrite.model.ResumeBatchLoadTaskRequest
import aws.sdk.kotlin.services.timestreamwrite.model.ResumeBatchLoadTaskResponse
import aws.sdk.kotlin.services.timestreamwrite.model.TagResourceRequest
import aws.sdk.kotlin.services.timestreamwrite.model.TagResourceResponse
import aws.sdk.kotlin.services.timestreamwrite.model.UntagResourceRequest
import aws.sdk.kotlin.services.timestreamwrite.model.UntagResourceResponse
import aws.sdk.kotlin.services.timestreamwrite.model.UpdateDatabaseRequest
import aws.sdk.kotlin.services.timestreamwrite.model.UpdateDatabaseResponse
import aws.sdk.kotlin.services.timestreamwrite.model.UpdateTableRequest
import aws.sdk.kotlin.services.timestreamwrite.model.UpdateTableResponse
import aws.sdk.kotlin.services.timestreamwrite.model.WriteRecordsRequest
import aws.sdk.kotlin.services.timestreamwrite.model.WriteRecordsResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "Timestream Write"
public const val SdkVersion: String = "1.5.54"
public const val ServiceApiVersion: String = "2018-11-01"

/**
 * # Amazon Timestream Write
 * Amazon Timestream is a fast, scalable, fully managed time-series database service that makes it easy to store and analyze trillions of time-series data points per day. With Timestream, you can easily store and analyze IoT sensor data to derive insights from your IoT applications. You can analyze industrial telemetry to streamline equipment management and maintenance. You can also store and analyze log data and metrics to improve the performance and availability of your applications.
 *
 * Timestream is built from the ground up to effectively ingest, process, and store time-series data. It organizes data to optimize query processing. It automatically scales based on the volume of data ingested and on the query volume to ensure you receive optimal performance while inserting and querying data. As your data grows over time, Timestream’s adaptive query processing engine spans across storage tiers to provide fast analysis while reducing costs.
 */
public interface TimestreamWriteClient : SdkClient {
    /**
     * TimestreamWriteClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, TimestreamWriteClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "TimestreamWrite",
                "TIMESTREAM_WRITE",
                "timestream_write",
            )
            val epDiscoveryEnabled = resolveEndpointDiscoveryEnabled(profile = activeProfile, serviceRequiresEpDiscovery = true)
            builder.config.endpointDiscoverer = builder.config.endpointDiscoverer ?: if (epDiscoveryEnabled) DefaultTimestreamWriteEndpointDiscoverer() else null
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, TimestreamWriteClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): TimestreamWriteClient = DefaultTimestreamWriteClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointDiscoverer: TimestreamWriteEndpointDiscoverer = builder.endpointDiscoverer ?: DefaultTimestreamWriteEndpointDiscoverer()
        public val endpointProvider: TimestreamWriteEndpointProvider = builder.endpointProvider ?: DefaultTimestreamWriteEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: TimestreamWriteAuthSchemeProvider = builder.authSchemeProvider ?: DefaultTimestreamWriteAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointDiscoverer = this@Config.endpointDiscoverer
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Timestream Write"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint discoverer for this client, [DefaultTimestreamWriteEndpointDiscoverer] by default.
             */
            public var endpointDiscoverer: TimestreamWriteEndpointDiscoverer? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: TimestreamWriteEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: TimestreamWriteAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new Timestream batch load task. A batch load task processes data from a CSV source in an S3 location and writes to a Timestream table. A mapping from source to target is defined in a batch load task. Errors and events are written to a report at an S3 location. For the report, if the KMS key is not specified, the report will be encrypted with an S3 managed key when `SSE_S3` is the option. Otherwise an error is thrown. For more information, see [Amazon Web Services managed keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk). [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html). For details, see [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-batch-load.html).
     */
    public suspend fun createBatchLoadTask(input: CreateBatchLoadTaskRequest): CreateBatchLoadTaskResponse

    /**
     * Creates a new Timestream database. If the KMS key is not specified, the database will be encrypted with a Timestream managed KMS key located in your account. For more information, see [Amazon Web Services managed keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk). [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html). For details, see [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-db.html).
     */
    public suspend fun createDatabase(input: CreateDatabaseRequest): CreateDatabaseResponse

    /**
     * Adds a new table to an existing database in your account. In an Amazon Web Services account, table names must be at least unique within each Region if they are in the same database. You might have identical table names in the same Region if the tables are in separate databases. While creating the table, you must specify the table name, database name, and the retention properties. [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html). See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-table.html) for details.
     */
    public suspend fun createTable(input: CreateTableRequest): CreateTableResponse

    /**
     * Deletes a given Timestream database. *This is an irreversible operation. After a database is deleted, the time-series data from its tables cannot be recovered.*
     *
     * All tables in the database must be deleted first, or a ValidationException error will be thrown.
     *
     * Due to the nature of distributed retries, the operation can return either success or a ResourceNotFoundException. Clients should consider them equivalent.
     *
     * See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.delete-db.html) for details.
     */
    public suspend fun deleteDatabase(input: DeleteDatabaseRequest): DeleteDatabaseResponse

    /**
     * Deletes a given Timestream table. This is an irreversible operation. After a Timestream database table is deleted, the time-series data stored in the table cannot be recovered.
     *
     * Due to the nature of distributed retries, the operation can return either success or a ResourceNotFoundException. Clients should consider them equivalent.
     *
     * See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.delete-table.html) for details.
     */
    public suspend fun deleteTable(input: DeleteTableRequest): DeleteTableResponse

    /**
     * Returns information about the batch load task, including configurations, mappings, progress, and other details. [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html). See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-batch-load.html) for details.
     */
    public suspend fun describeBatchLoadTask(input: DescribeBatchLoadTaskRequest): DescribeBatchLoadTaskResponse

    /**
     * Returns information about the database, including the database name, time that the database was created, and the total number of tables found within the database. [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html). See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-db.html) for details.
     */
    public suspend fun describeDatabase(input: DescribeDatabaseRequest): DescribeDatabaseResponse

    /**
     * Returns a list of available endpoints to make Timestream API calls against. This API operation is available through both the Write and Query APIs.
     *
     * Because the Timestream SDKs are designed to transparently work with the service’s architecture, including the management and mapping of the service endpoints, *we don't recommend that you use this API operation unless*:
     * + You are using [VPC endpoints (Amazon Web Services PrivateLink) with Timestream](https://docs.aws.amazon.com/timestream/latest/developerguide/VPCEndpoints)
     * + Your application uses a programming language that does not yet have SDK support
     * + You require better control over the client-side implementation
     *
     * For detailed information on how and when to use and implement DescribeEndpoints, see [The Endpoint Discovery Pattern](https://docs.aws.amazon.com/timestream/latest/developerguide/Using.API.html#Using-API.endpoint-discovery).
     */
    public suspend fun describeEndpoints(input: DescribeEndpointsRequest = DescribeEndpointsRequest { }): DescribeEndpointsResponse

    /**
     * Returns information about the table, including the table name, database name, retention duration of the memory store and the magnetic store. [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html). See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-table.html) for details.
     */
    public suspend fun describeTable(input: DescribeTableRequest): DescribeTableResponse

    /**
     * Provides a list of batch load tasks, along with the name, status, when the task is resumable until, and other details. See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-batch-load-tasks.html) for details.
     */
    public suspend fun listBatchLoadTasks(input: ListBatchLoadTasksRequest = ListBatchLoadTasksRequest { }): ListBatchLoadTasksResponse

    /**
     * Returns a list of your Timestream databases. [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html). See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-db.html) for details.
     */
    public suspend fun listDatabases(input: ListDatabasesRequest = ListDatabasesRequest { }): ListDatabasesResponse

    /**
     * Provides a list of tables, along with the name, status, and retention properties of each table. See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-table.html) for details.
     */
    public suspend fun listTables(input: ListTablesRequest = ListTablesRequest { }): ListTablesResponse

    /**
     * Lists all tags on a Timestream resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     *
     */
    public suspend fun resumeBatchLoadTask(input: ResumeBatchLoadTaskRequest): ResumeBatchLoadTaskResponse

    /**
     * Associates a set of tags with a Timestream resource. You can then activate these user-defined tags so that they appear on the Billing and Cost Management console for cost allocation tracking.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the association of tags from a Timestream resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Modifies the KMS key for an existing database. While updating the database, you must specify the database name and the identifier of the new KMS key to be used (`KmsKeyId`). If there are any concurrent `UpdateDatabase` requests, first writer wins.
     *
     * See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.update-db.html) for details.
     */
    public suspend fun updateDatabase(input: UpdateDatabaseRequest): UpdateDatabaseResponse

    /**
     * Modifies the retention duration of the memory store and magnetic store for your Timestream table. Note that the change in retention duration takes effect immediately. For example, if the retention period of the memory store was initially set to 2 hours and then changed to 24 hours, the memory store will be capable of holding 24 hours of data, but will be populated with 24 hours of data 22 hours after this change was made. Timestream does not retrieve data from the magnetic store to populate the memory store.
     *
     * See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.update-table.html) for details.
     */
    public suspend fun updateTable(input: UpdateTableRequest): UpdateTableResponse

    /**
     * Enables you to write your time-series data into Timestream. You can specify a single data point or a batch of data points to be inserted into the system. Timestream offers you a flexible schema that auto detects the column names and data types for your Timestream tables based on the dimension names and data types of the data points you specify when invoking writes into the database.
     *
     * Timestream supports eventual consistency read semantics. This means that when you query data immediately after writing a batch of data into Timestream, the query results might not reflect the results of a recently completed write operation. The results may also include some stale data. If you repeat the query request after a short time, the results should return the latest data. [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html).
     *
     * See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.write.html) for details.
     *
     * **Upserts**
     *
     * You can use the `Version` parameter in a `WriteRecords` request to update data points. Timestream tracks a version number with each record. `Version` defaults to `1` when it's not specified for the record in the request. Timestream updates an existing record’s measure value along with its `Version` when it receives a write request with a higher `Version` number for that record. When it receives an update request where the measure value is the same as that of the existing record, Timestream still updates `Version`, if it is greater than the existing value of `Version`. You can update a data point as many times as desired, as long as the value of `Version` continuously increases.
     *
     *  For example, suppose you write a new record without indicating `Version` in the request. Timestream stores this record, and set `Version` to `1`. Now, suppose you try to update this record with a `WriteRecords` request of the same record with a different measure value but, like before, do not provide `Version`. In this case, Timestream will reject this update with a `RejectedRecordsException` since the updated record’s version is not greater than the existing value of Version.
     *
     * However, if you were to resend the update request with `Version` set to `2`, Timestream would then succeed in updating the record’s value, and the `Version` would be set to `2`. Next, suppose you sent a `WriteRecords` request with this same record and an identical measure value, but with `Version` set to `3`. In this case, Timestream would only update `Version` to `3`. Any further updates would need to send a version number greater than `3`, or the update requests would receive a `RejectedRecordsException`.
     */
    public suspend fun writeRecords(input: WriteRecordsRequest): WriteRecordsResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun TimestreamWriteClient.withConfig(block: TimestreamWriteClient.Config.Builder.() -> Unit): TimestreamWriteClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultTimestreamWriteClient(newConfig)
}

/**
 * Creates a new Timestream batch load task. A batch load task processes data from a CSV source in an S3 location and writes to a Timestream table. A mapping from source to target is defined in a batch load task. Errors and events are written to a report at an S3 location. For the report, if the KMS key is not specified, the report will be encrypted with an S3 managed key when `SSE_S3` is the option. Otherwise an error is thrown. For more information, see [Amazon Web Services managed keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk). [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html). For details, see [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-batch-load.html).
 */
public suspend inline fun TimestreamWriteClient.createBatchLoadTask(crossinline block: CreateBatchLoadTaskRequest.Builder.() -> Unit): CreateBatchLoadTaskResponse = createBatchLoadTask(CreateBatchLoadTaskRequest.Builder().apply(block).build())

/**
 * Creates a new Timestream database. If the KMS key is not specified, the database will be encrypted with a Timestream managed KMS key located in your account. For more information, see [Amazon Web Services managed keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk). [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html). For details, see [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-db.html).
 */
public suspend inline fun TimestreamWriteClient.createDatabase(crossinline block: CreateDatabaseRequest.Builder.() -> Unit): CreateDatabaseResponse = createDatabase(CreateDatabaseRequest.Builder().apply(block).build())

/**
 * Adds a new table to an existing database in your account. In an Amazon Web Services account, table names must be at least unique within each Region if they are in the same database. You might have identical table names in the same Region if the tables are in separate databases. While creating the table, you must specify the table name, database name, and the retention properties. [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html). See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-table.html) for details.
 */
public suspend inline fun TimestreamWriteClient.createTable(crossinline block: CreateTableRequest.Builder.() -> Unit): CreateTableResponse = createTable(CreateTableRequest.Builder().apply(block).build())

/**
 * Deletes a given Timestream database. *This is an irreversible operation. After a database is deleted, the time-series data from its tables cannot be recovered.*
 *
 * All tables in the database must be deleted first, or a ValidationException error will be thrown.
 *
 * Due to the nature of distributed retries, the operation can return either success or a ResourceNotFoundException. Clients should consider them equivalent.
 *
 * See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.delete-db.html) for details.
 */
public suspend inline fun TimestreamWriteClient.deleteDatabase(crossinline block: DeleteDatabaseRequest.Builder.() -> Unit): DeleteDatabaseResponse = deleteDatabase(DeleteDatabaseRequest.Builder().apply(block).build())

/**
 * Deletes a given Timestream table. This is an irreversible operation. After a Timestream database table is deleted, the time-series data stored in the table cannot be recovered.
 *
 * Due to the nature of distributed retries, the operation can return either success or a ResourceNotFoundException. Clients should consider them equivalent.
 *
 * See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.delete-table.html) for details.
 */
public suspend inline fun TimestreamWriteClient.deleteTable(crossinline block: DeleteTableRequest.Builder.() -> Unit): DeleteTableResponse = deleteTable(DeleteTableRequest.Builder().apply(block).build())

/**
 * Returns information about the batch load task, including configurations, mappings, progress, and other details. [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html). See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-batch-load.html) for details.
 */
public suspend inline fun TimestreamWriteClient.describeBatchLoadTask(crossinline block: DescribeBatchLoadTaskRequest.Builder.() -> Unit): DescribeBatchLoadTaskResponse = describeBatchLoadTask(DescribeBatchLoadTaskRequest.Builder().apply(block).build())

/**
 * Returns information about the database, including the database name, time that the database was created, and the total number of tables found within the database. [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html). See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-db.html) for details.
 */
public suspend inline fun TimestreamWriteClient.describeDatabase(crossinline block: DescribeDatabaseRequest.Builder.() -> Unit): DescribeDatabaseResponse = describeDatabase(DescribeDatabaseRequest.Builder().apply(block).build())

/**
 * Returns a list of available endpoints to make Timestream API calls against. This API operation is available through both the Write and Query APIs.
 *
 * Because the Timestream SDKs are designed to transparently work with the service’s architecture, including the management and mapping of the service endpoints, *we don't recommend that you use this API operation unless*:
 * + You are using [VPC endpoints (Amazon Web Services PrivateLink) with Timestream](https://docs.aws.amazon.com/timestream/latest/developerguide/VPCEndpoints)
 * + Your application uses a programming language that does not yet have SDK support
 * + You require better control over the client-side implementation
 *
 * For detailed information on how and when to use and implement DescribeEndpoints, see [The Endpoint Discovery Pattern](https://docs.aws.amazon.com/timestream/latest/developerguide/Using.API.html#Using-API.endpoint-discovery).
 */
public suspend inline fun TimestreamWriteClient.describeEndpoints(crossinline block: DescribeEndpointsRequest.Builder.() -> Unit): DescribeEndpointsResponse = describeEndpoints(DescribeEndpointsRequest.Builder().apply(block).build())

/**
 * Returns information about the table, including the table name, database name, retention duration of the memory store and the magnetic store. [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html). See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.describe-table.html) for details.
 */
public suspend inline fun TimestreamWriteClient.describeTable(crossinline block: DescribeTableRequest.Builder.() -> Unit): DescribeTableResponse = describeTable(DescribeTableRequest.Builder().apply(block).build())

/**
 * Provides a list of batch load tasks, along with the name, status, when the task is resumable until, and other details. See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-batch-load-tasks.html) for details.
 */
public suspend inline fun TimestreamWriteClient.listBatchLoadTasks(crossinline block: ListBatchLoadTasksRequest.Builder.() -> Unit): ListBatchLoadTasksResponse = listBatchLoadTasks(ListBatchLoadTasksRequest.Builder().apply(block).build())

/**
 * Returns a list of your Timestream databases. [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html). See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-db.html) for details.
 */
public suspend inline fun TimestreamWriteClient.listDatabases(crossinline block: ListDatabasesRequest.Builder.() -> Unit): ListDatabasesResponse = listDatabases(ListDatabasesRequest.Builder().apply(block).build())

/**
 * Provides a list of tables, along with the name, status, and retention properties of each table. See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.list-table.html) for details.
 */
public suspend inline fun TimestreamWriteClient.listTables(crossinline block: ListTablesRequest.Builder.() -> Unit): ListTablesResponse = listTables(ListTablesRequest.Builder().apply(block).build())

/**
 * Lists all tags on a Timestream resource.
 */
public suspend inline fun TimestreamWriteClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 *
 */
public suspend inline fun TimestreamWriteClient.resumeBatchLoadTask(crossinline block: ResumeBatchLoadTaskRequest.Builder.() -> Unit): ResumeBatchLoadTaskResponse = resumeBatchLoadTask(ResumeBatchLoadTaskRequest.Builder().apply(block).build())

/**
 * Associates a set of tags with a Timestream resource. You can then activate these user-defined tags so that they appear on the Billing and Cost Management console for cost allocation tracking.
 */
public suspend inline fun TimestreamWriteClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the association of tags from a Timestream resource.
 */
public suspend inline fun TimestreamWriteClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Modifies the KMS key for an existing database. While updating the database, you must specify the database name and the identifier of the new KMS key to be used (`KmsKeyId`). If there are any concurrent `UpdateDatabase` requests, first writer wins.
 *
 * See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.update-db.html) for details.
 */
public suspend inline fun TimestreamWriteClient.updateDatabase(crossinline block: UpdateDatabaseRequest.Builder.() -> Unit): UpdateDatabaseResponse = updateDatabase(UpdateDatabaseRequest.Builder().apply(block).build())

/**
 * Modifies the retention duration of the memory store and magnetic store for your Timestream table. Note that the change in retention duration takes effect immediately. For example, if the retention period of the memory store was initially set to 2 hours and then changed to 24 hours, the memory store will be capable of holding 24 hours of data, but will be populated with 24 hours of data 22 hours after this change was made. Timestream does not retrieve data from the magnetic store to populate the memory store.
 *
 * See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.update-table.html) for details.
 */
public suspend inline fun TimestreamWriteClient.updateTable(crossinline block: UpdateTableRequest.Builder.() -> Unit): UpdateTableResponse = updateTable(UpdateTableRequest.Builder().apply(block).build())

/**
 * Enables you to write your time-series data into Timestream. You can specify a single data point or a batch of data points to be inserted into the system. Timestream offers you a flexible schema that auto detects the column names and data types for your Timestream tables based on the dimension names and data types of the data points you specify when invoking writes into the database.
 *
 * Timestream supports eventual consistency read semantics. This means that when you query data immediately after writing a batch of data into Timestream, the query results might not reflect the results of a recently completed write operation. The results may also include some stale data. If you repeat the query request after a short time, the results should return the latest data. [Service quotas apply](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html).
 *
 * See [code sample](https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.write.html) for details.
 *
 * **Upserts**
 *
 * You can use the `Version` parameter in a `WriteRecords` request to update data points. Timestream tracks a version number with each record. `Version` defaults to `1` when it's not specified for the record in the request. Timestream updates an existing record’s measure value along with its `Version` when it receives a write request with a higher `Version` number for that record. When it receives an update request where the measure value is the same as that of the existing record, Timestream still updates `Version`, if it is greater than the existing value of `Version`. You can update a data point as many times as desired, as long as the value of `Version` continuously increases.
 *
 *  For example, suppose you write a new record without indicating `Version` in the request. Timestream stores this record, and set `Version` to `1`. Now, suppose you try to update this record with a `WriteRecords` request of the same record with a different measure value but, like before, do not provide `Version`. In this case, Timestream will reject this update with a `RejectedRecordsException` since the updated record’s version is not greater than the existing value of Version.
 *
 * However, if you were to resend the update request with `Version` set to `2`, Timestream would then succeed in updating the record’s value, and the `Version` would be set to `2`. Next, suppose you sent a `WriteRecords` request with this same record and an identical measure value, but with `Version` set to `3`. In this case, Timestream would only update `Version` to `3`. Any further updates would need to send a version number greater than `3`, or the update requests would receive a `RejectedRecordsException`.
 */
public suspend inline fun TimestreamWriteClient.writeRecords(crossinline block: WriteRecordsRequest.Builder.() -> Unit): WriteRecordsResponse = writeRecords(WriteRecordsRequest.Builder().apply(block).build())
