// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite.paginators

import aws.sdk.kotlin.services.timestreamwrite.TimestreamWriteClient
import aws.sdk.kotlin.services.timestreamwrite.model.ListBatchLoadTasksRequest
import aws.sdk.kotlin.services.timestreamwrite.model.ListBatchLoadTasksResponse
import aws.sdk.kotlin.services.timestreamwrite.model.ListDatabasesRequest
import aws.sdk.kotlin.services.timestreamwrite.model.ListDatabasesResponse
import aws.sdk.kotlin.services.timestreamwrite.model.ListTablesRequest
import aws.sdk.kotlin.services.timestreamwrite.model.ListTablesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListBatchLoadTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBatchLoadTasksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBatchLoadTasksResponse]
 */
public fun TimestreamWriteClient.listBatchLoadTasksPaginated(initialRequest: ListBatchLoadTasksRequest = ListBatchLoadTasksRequest { }): Flow<ListBatchLoadTasksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBatchLoadTasksPaginated.listBatchLoadTasks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBatchLoadTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBatchLoadTasksResponse]
 */
public fun TimestreamWriteClient.listBatchLoadTasksPaginated(block: ListBatchLoadTasksRequest.Builder.() -> Unit): Flow<ListBatchLoadTasksResponse> =
    listBatchLoadTasksPaginated(ListBatchLoadTasksRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDatabasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatabasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatabasesResponse]
 */
public fun TimestreamWriteClient.listDatabasesPaginated(initialRequest: ListDatabasesRequest = ListDatabasesRequest { }): Flow<ListDatabasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatabasesPaginated.listDatabases(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDatabasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatabasesResponse]
 */
public fun TimestreamWriteClient.listDatabasesPaginated(block: ListDatabasesRequest.Builder.() -> Unit): Flow<ListDatabasesResponse> =
    listDatabasesPaginated(ListDatabasesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTablesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTablesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTablesResponse]
 */
public fun TimestreamWriteClient.listTablesPaginated(initialRequest: ListTablesRequest = ListTablesRequest { }): Flow<ListTablesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTablesPaginated.listTables(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTablesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTablesResponse]
 */
public fun TimestreamWriteClient.listTablesPaginated(block: ListTablesRequest.Builder.() -> Unit): Flow<ListTablesResponse> =
    listTablesPaginated(ListTablesRequest.Builder().apply(block).build())
