// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite.endpoints

import aws.sdk.kotlin.services.timestreamwrite.TimestreamWriteClient
import aws.sdk.kotlin.services.timestreamwrite.endpoints.internal.EndpointResolverAdapter
import aws.smithy.kotlin.runtime.auth.awscredentials.Credentials
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.collections.AttributeKey
import aws.smithy.kotlin.runtime.collections.ReadThroughCache
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.net.Host
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.time.Clock
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.util.ExpiringValue
import kotlin.time.Duration.Companion.minutes

/**
 * A class which looks up specific endpoints for Timestream Write calls via the `describeEndpoints`
 * API. These unique endpoints are cached as appropriate to avoid unnecessary latency in subsequent
 * calls.
 */
public class TimestreamWriteEndpointDiscoverer {
    private val cache = ReadThroughCache<DiscoveryParams, Host>(10.minutes, Clock.System)

    internal fun asEndpointResolver(client: TimestreamWriteClient, delegate: EndpointResolverAdapter) = EndpointResolver { request ->
        val identity = request.identity
        require(identity is Credentials) { "Endpoint discovery requires AWS credentials" }

        val cacheKey = DiscoveryParams(client.config.region, identity.accessKeyId)
        request.context[discoveryParamsKey] = cacheKey
        val discoveredHost = cache.get(cacheKey) { discoverHost(client) }

        val originalEndpoint = delegate.resolve(request)
        Endpoint(
            originalEndpoint.uri.copy { host = discoveredHost },
            originalEndpoint.headers,
            originalEndpoint.attributes,
        )
    }

    private suspend fun discoverHost(client: TimestreamWriteClient): ExpiringValue<Host> =
        client.describeEndpoints()
            .endpoints
            ?.map { ep -> ExpiringValue(
                Host.parse(ep.address!!),
                Instant.now() + ep.cachePeriodInMinutes.minutes,
            )}
            ?.firstOrNull()
            ?: throw EndpointProviderException("Unable to discover any endpoints when invoking describeEndpoints!")

    internal suspend fun invalidate(context: ExecutionContext) {
        context.getOrNull(discoveryParamsKey)?.let { cache.invalidate(it) }
    }
}

private val discoveryParamsKey = AttributeKey<DiscoveryParams>("DiscoveryParams")
private data class DiscoveryParams(private val region: String?, private val identity: String)
