// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite.serde

import aws.sdk.kotlin.services.timestreamwrite.model.Database
import aws.sdk.kotlin.services.timestreamwrite.model.DescribeDatabaseResponse
import aws.sdk.kotlin.services.timestreamwrite.model.TimestreamWriteException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeDatabaseOperationDeserializer: HttpDeserialize<DescribeDatabaseResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeDatabaseResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDatabaseError(context, call)
        }
        val builder = DescribeDatabaseResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDatabaseOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeDatabaseError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TimestreamWriteException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidEndpointException" -> InvalidEndpointExceptionDeserializer().deserialize(context, wrappedCall)
        else -> TimestreamWriteException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDatabaseOperationBody(builder: DescribeDatabaseResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATABASE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Database"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATABASE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATABASE_DESCRIPTOR.index -> builder.database = deserializeDatabaseDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
