// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a database table in Timestream. Tables contain one or more related time series. You can modify the retention duration of the memory store and the magnetic store for a table.
 */
public class Table private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name that uniquely identifies this table.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time when the Timestream table was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The name of the Timestream database that contains this table.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The time when the Timestream table was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * Contains properties to set on the table when enabling magnetic store writes.
     */
    public val magneticStoreWriteProperties: aws.sdk.kotlin.services.timestreamwrite.model.MagneticStoreWriteProperties? = builder.magneticStoreWriteProperties
    /**
     * The retention duration for the memory store and magnetic store.
     */
    public val retentionProperties: aws.sdk.kotlin.services.timestreamwrite.model.RetentionProperties? = builder.retentionProperties
    /**
     * The schema of the table.
     */
    public val schema: aws.sdk.kotlin.services.timestreamwrite.model.Schema? = builder.schema
    /**
     * The name of the Timestream table.
     */
    public val tableName: kotlin.String? = builder.tableName
    /**
     * The current state of the table:
     * + `DELETING` - The table is being deleted.
     * + `ACTIVE` - The table is ready for use.
     */
    public val tableStatus: aws.sdk.kotlin.services.timestreamwrite.model.TableStatus? = builder.tableStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamwrite.model.Table = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Table(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("databaseName=$databaseName,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("magneticStoreWriteProperties=$magneticStoreWriteProperties,")
        append("retentionProperties=$retentionProperties,")
        append("schema=$schema,")
        append("tableName=$tableName,")
        append("tableStatus=$tableStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (magneticStoreWriteProperties?.hashCode() ?: 0)
        result = 31 * result + (retentionProperties?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (tableStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Table

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (databaseName != other.databaseName) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (magneticStoreWriteProperties != other.magneticStoreWriteProperties) return false
        if (retentionProperties != other.retentionProperties) return false
        if (schema != other.schema) return false
        if (tableName != other.tableName) return false
        if (tableStatus != other.tableStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamwrite.model.Table = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name that uniquely identifies this table.
         */
        public var arn: kotlin.String? = null
        /**
         * The time when the Timestream table was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the Timestream database that contains this table.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The time when the Timestream table was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains properties to set on the table when enabling magnetic store writes.
         */
        public var magneticStoreWriteProperties: aws.sdk.kotlin.services.timestreamwrite.model.MagneticStoreWriteProperties? = null
        /**
         * The retention duration for the memory store and magnetic store.
         */
        public var retentionProperties: aws.sdk.kotlin.services.timestreamwrite.model.RetentionProperties? = null
        /**
         * The schema of the table.
         */
        public var schema: aws.sdk.kotlin.services.timestreamwrite.model.Schema? = null
        /**
         * The name of the Timestream table.
         */
        public var tableName: kotlin.String? = null
        /**
         * The current state of the table:
         * + `DELETING` - The table is being deleted.
         * + `ACTIVE` - The table is ready for use.
         */
        public var tableStatus: aws.sdk.kotlin.services.timestreamwrite.model.TableStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamwrite.model.Table) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.databaseName = x.databaseName
            this.lastUpdatedTime = x.lastUpdatedTime
            this.magneticStoreWriteProperties = x.magneticStoreWriteProperties
            this.retentionProperties = x.retentionProperties
            this.schema = x.schema
            this.tableName = x.tableName
            this.tableStatus = x.tableStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamwrite.model.Table = Table(this)

        /**
         * construct an [aws.sdk.kotlin.services.timestreamwrite.model.MagneticStoreWriteProperties] inside the given [block]
         */
        public fun magneticStoreWriteProperties(block: aws.sdk.kotlin.services.timestreamwrite.model.MagneticStoreWriteProperties.Builder.() -> kotlin.Unit) {
            this.magneticStoreWriteProperties = aws.sdk.kotlin.services.timestreamwrite.model.MagneticStoreWriteProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreamwrite.model.RetentionProperties] inside the given [block]
         */
        public fun retentionProperties(block: aws.sdk.kotlin.services.timestreamwrite.model.RetentionProperties.Builder.() -> kotlin.Unit) {
            this.retentionProperties = aws.sdk.kotlin.services.timestreamwrite.model.RetentionProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreamwrite.model.Schema] inside the given [block]
         */
        public fun schema(block: aws.sdk.kotlin.services.timestreamwrite.model.Schema.Builder.() -> kotlin.Unit) {
            this.schema = aws.sdk.kotlin.services.timestreamwrite.model.Schema.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
