// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite.model



/**
 * Represents records that were not successfully inserted into Timestream due to data validation issues that must be resolved before reinserting time-series data into the system.
 */
public class RejectedRecord private constructor(builder: Builder) {
    /**
     * The existing version of the record. This value is populated in scenarios where an identical record exists with a higher version than the version in the write request.
     */
    public val existingVersion: kotlin.Long? = builder.existingVersion
    /**
     * The reason why a record was not successfully inserted into Timestream. Possible causes of failure include:
     * + Records with duplicate data where there are multiple records with the same dimensions, timestamps, and measure names but:
     *    + Measure values are different
     *    + Version is not present in the request, *or* the value of version in the new record is equal to or lower than the existing value
     * If Timestream rejects data for this case, the `ExistingVersion` field in the `RejectedRecords` response will indicate the current record’s version. To force an update, you can resend the request with a version for the record set to a value greater than the `ExistingVersion`.
     * +  Records with timestamps that lie outside the retention duration of the memory store. When the retention window is updated, you will receive a `RejectedRecords` exception if you immediately try to ingest data within the new window. To avoid a `RejectedRecords` exception, wait until the duration of the new window to ingest new data. For further information, see [ Best Practices for Configuring Timestream](https://docs.aws.amazon.com/timestream/latest/developerguide/best-practices.html#configuration) and [the explanation of how storage works in Timestream](https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html).
     * +  Records with dimensions or measures that exceed the Timestream defined limits.
     *
     *  For more information, see [Access Management](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html) in the Timestream Developer Guide.
     */
    public val reason: kotlin.String? = builder.reason
    /**
     * The index of the record in the input request for WriteRecords. Indexes begin with 0.
     */
    public val recordIndex: kotlin.Int = builder.recordIndex

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamwrite.model.RejectedRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RejectedRecord(")
        append("existingVersion=$existingVersion,")
        append("reason=$reason,")
        append("recordIndex=$recordIndex")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = existingVersion?.hashCode() ?: 0
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (recordIndex)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RejectedRecord

        if (existingVersion != other.existingVersion) return false
        if (reason != other.reason) return false
        if (recordIndex != other.recordIndex) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamwrite.model.RejectedRecord = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The existing version of the record. This value is populated in scenarios where an identical record exists with a higher version than the version in the write request.
         */
        public var existingVersion: kotlin.Long? = null
        /**
         * The reason why a record was not successfully inserted into Timestream. Possible causes of failure include:
         * + Records with duplicate data where there are multiple records with the same dimensions, timestamps, and measure names but:
         *    + Measure values are different
         *    + Version is not present in the request, *or* the value of version in the new record is equal to or lower than the existing value
         * If Timestream rejects data for this case, the `ExistingVersion` field in the `RejectedRecords` response will indicate the current record’s version. To force an update, you can resend the request with a version for the record set to a value greater than the `ExistingVersion`.
         * +  Records with timestamps that lie outside the retention duration of the memory store. When the retention window is updated, you will receive a `RejectedRecords` exception if you immediately try to ingest data within the new window. To avoid a `RejectedRecords` exception, wait until the duration of the new window to ingest new data. For further information, see [ Best Practices for Configuring Timestream](https://docs.aws.amazon.com/timestream/latest/developerguide/best-practices.html#configuration) and [the explanation of how storage works in Timestream](https://docs.aws.amazon.com/timestream/latest/developerguide/storage.html).
         * +  Records with dimensions or measures that exceed the Timestream defined limits.
         *
         *  For more information, see [Access Management](https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html) in the Timestream Developer Guide.
         */
        public var reason: kotlin.String? = null
        /**
         * The index of the record in the input request for WriteRecords. Indexes begin with 0.
         */
        public var recordIndex: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamwrite.model.RejectedRecord) : this() {
            this.existingVersion = x.existingVersion
            this.reason = x.reason
            this.recordIndex = x.recordIndex
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamwrite.model.RejectedRecord = RejectedRecord(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
