// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamwrite.model



/**
 * Represents a time-series data point being written into Timestream. Each record contains an array of dimensions. Dimensions represent the metadata attributes of a time-series data point, such as the instance name or Availability Zone of an EC2 instance. A record also contains the measure name, which is the name of the measure being collected (for example, the CPU utilization of an EC2 instance). Additionally, a record contains the measure value and the value type, which is the data type of the measure value. Also, the record contains the timestamp of when the measure was collected and the timestamp unit, which represents the granularity of the timestamp.
 *
 *  Records have a `Version` field, which is a 64-bit `long` that you can use for updating data points. Writes of a duplicate record with the same dimension, timestamp, and measure name but different measure value will only succeed if the `Version` attribute of the record in the write request is higher than that of the existing record. Timestream defaults to a `Version` of `1` for records without the `Version` field.
 */
public class Record private constructor(builder: Builder) {
    /**
     * Contains the list of dimensions for time-series data points.
     */
    public val dimensions: List<Dimension>? = builder.dimensions
    /**
     * Measure represents the data attribute of the time series. For example, the CPU utilization of an EC2 instance or the RPM of a wind turbine are measures.
     */
    public val measureName: kotlin.String? = builder.measureName
    /**
     * Contains the measure value for the time-series data point.
     */
    public val measureValue: kotlin.String? = builder.measureValue
    /**
     * Contains the data type of the measure value for the time-series data point. Default type is `DOUBLE`. For more information, see [Data types](https://docs.aws.amazon.com/timestream/latest/developerguide/writes.html#writes.data-types).
     */
    public val measureValueType: aws.sdk.kotlin.services.timestreamwrite.model.MeasureValueType? = builder.measureValueType
    /**
     * Contains the list of MeasureValue for time-series data points.
     *
     *  This is only allowed for type `MULTI`. For scalar values, use `MeasureValue` attribute of the record directly.
     */
    public val measureValues: List<MeasureValue>? = builder.measureValues
    /**
     * Contains the time at which the measure value for the data point was collected. The time value plus the unit provides the time elapsed since the epoch. For example, if the time value is `12345` and the unit is `ms`, then `12345 ms` have elapsed since the epoch.
     */
    public val time: kotlin.String? = builder.time
    /**
     * The granularity of the timestamp unit. It indicates if the time value is in seconds, milliseconds, nanoseconds, or other supported values. Default is `MILLISECONDS`.
     */
    public val timeUnit: aws.sdk.kotlin.services.timestreamwrite.model.TimeUnit? = builder.timeUnit
    /**
     * 64-bit attribute used for record updates. Write requests for duplicate data with a higher version number will update the existing measure value and version. In cases where the measure value is the same, `Version` will still be updated. Default value is `1`.
     *
     * `Version` must be `1` or greater, or you will receive a `ValidationException` error.
     */
    public val version: kotlin.Long? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamwrite.model.Record = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Record(")
        append("dimensions=$dimensions,")
        append("measureName=$measureName,")
        append("measureValue=$measureValue,")
        append("measureValueType=$measureValueType,")
        append("measureValues=$measureValues,")
        append("time=$time,")
        append("timeUnit=$timeUnit,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensions?.hashCode() ?: 0
        result = 31 * result + (measureName?.hashCode() ?: 0)
        result = 31 * result + (measureValue?.hashCode() ?: 0)
        result = 31 * result + (measureValueType?.hashCode() ?: 0)
        result = 31 * result + (measureValues?.hashCode() ?: 0)
        result = 31 * result + (time?.hashCode() ?: 0)
        result = 31 * result + (timeUnit?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Record

        if (dimensions != other.dimensions) return false
        if (measureName != other.measureName) return false
        if (measureValue != other.measureValue) return false
        if (measureValueType != other.measureValueType) return false
        if (measureValues != other.measureValues) return false
        if (time != other.time) return false
        if (timeUnit != other.timeUnit) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamwrite.model.Record = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains the list of dimensions for time-series data points.
         */
        public var dimensions: List<Dimension>? = null
        /**
         * Measure represents the data attribute of the time series. For example, the CPU utilization of an EC2 instance or the RPM of a wind turbine are measures.
         */
        public var measureName: kotlin.String? = null
        /**
         * Contains the measure value for the time-series data point.
         */
        public var measureValue: kotlin.String? = null
        /**
         * Contains the data type of the measure value for the time-series data point. Default type is `DOUBLE`. For more information, see [Data types](https://docs.aws.amazon.com/timestream/latest/developerguide/writes.html#writes.data-types).
         */
        public var measureValueType: aws.sdk.kotlin.services.timestreamwrite.model.MeasureValueType? = null
        /**
         * Contains the list of MeasureValue for time-series data points.
         *
         *  This is only allowed for type `MULTI`. For scalar values, use `MeasureValue` attribute of the record directly.
         */
        public var measureValues: List<MeasureValue>? = null
        /**
         * Contains the time at which the measure value for the data point was collected. The time value plus the unit provides the time elapsed since the epoch. For example, if the time value is `12345` and the unit is `ms`, then `12345 ms` have elapsed since the epoch.
         */
        public var time: kotlin.String? = null
        /**
         * The granularity of the timestamp unit. It indicates if the time value is in seconds, milliseconds, nanoseconds, or other supported values. Default is `MILLISECONDS`.
         */
        public var timeUnit: aws.sdk.kotlin.services.timestreamwrite.model.TimeUnit? = null
        /**
         * 64-bit attribute used for record updates. Write requests for duplicate data with a higher version number will update the existing measure value and version. In cases where the measure value is the same, `Version` will still be updated. Default value is `1`.
         *
         * `Version` must be `1` or greater, or you will receive a `ValidationException` error.
         */
        public var version: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamwrite.model.Record) : this() {
            this.dimensions = x.dimensions
            this.measureName = x.measureName
            this.measureValue = x.measureValue
            this.measureValueType = x.measureValueType
            this.measureValues = x.measureValues
            this.time = x.time
            this.timeUnit = x.timeUnit
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamwrite.model.Record = Record(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
