// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.serde

import aws.sdk.kotlin.services.timestreamquery.model.ColumnInfo
import aws.sdk.kotlin.services.timestreamquery.model.QueryInsightsResponse
import aws.sdk.kotlin.services.timestreamquery.model.QueryResponse
import aws.sdk.kotlin.services.timestreamquery.model.QueryStatus
import aws.sdk.kotlin.services.timestreamquery.model.Row
import aws.sdk.kotlin.services.timestreamquery.model.TimestreamQueryException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class QueryOperationDeserializer: HttpDeserializer.NonStreaming<QueryResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): QueryResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwQueryError(context, call, payload)
        }
        val builder = QueryResponse.Builder()

        if (payload != null) {
            deserializeQueryOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwQueryError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw TimestreamQueryException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEndpointException" -> InvalidEndpointExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "QueryExecutionException" -> QueryExecutionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> TimestreamQueryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeQueryOperationBody(builder: QueryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COLUMNINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ColumnInfo"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val QUERYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryId"))
    val QUERYINSIGHTSRESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("QueryInsightsResponse"))
    val QUERYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("QueryStatus"))
    val ROWS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Rows"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COLUMNINFO_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(QUERYID_DESCRIPTOR)
        field(QUERYINSIGHTSRESPONSE_DESCRIPTOR)
        field(QUERYSTATUS_DESCRIPTOR)
        field(ROWS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COLUMNINFO_DESCRIPTOR.index -> builder.columnInfo =
                    deserializer.deserializeList(COLUMNINFO_DESCRIPTOR) {
                        val col0 = mutableListOf<ColumnInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeColumnInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                QUERYID_DESCRIPTOR.index -> builder.queryId = deserializeString()
                QUERYINSIGHTSRESPONSE_DESCRIPTOR.index -> builder.queryInsightsResponse = deserializeQueryInsightsResponseDocument(deserializer)
                QUERYSTATUS_DESCRIPTOR.index -> builder.queryStatus = deserializeQueryStatusDocument(deserializer)
                ROWS_DESCRIPTOR.index -> builder.rows =
                    deserializer.deserializeList(ROWS_DESCRIPTOR) {
                        val col0 = mutableListOf<Row>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRowDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
