// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details on S3 location for error reports that result from running a query.
 */
public class S3Configuration private constructor(builder: Builder) {
    /**
     * Name of the S3 bucket under which error reports will be created.
     */
    public val bucketName: kotlin.String = requireNotNull(builder.bucketName) { "A non-null value must be provided for bucketName" }
    /**
     * Encryption at rest options for the error reports. If no encryption option is specified, Timestream will choose SSE_S3 as default.
     */
    public val encryptionOption: aws.sdk.kotlin.services.timestreamquery.model.S3EncryptionOption? = builder.encryptionOption
    /**
     * Prefix for the error report key. Timestream by default adds the following prefix to the error report path.
     */
    public val objectKeyPrefix: kotlin.String? = builder.objectKeyPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamquery.model.S3Configuration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Configuration(")
        append("bucketName=$bucketName,")
        append("encryptionOption=$encryptionOption,")
        append("objectKeyPrefix=$objectKeyPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName.hashCode()
        result = 31 * result + (encryptionOption?.hashCode() ?: 0)
        result = 31 * result + (objectKeyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Configuration

        if (bucketName != other.bucketName) return false
        if (encryptionOption != other.encryptionOption) return false
        if (objectKeyPrefix != other.objectKeyPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamquery.model.S3Configuration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Name of the S3 bucket under which error reports will be created.
         */
        public var bucketName: kotlin.String? = null
        /**
         * Encryption at rest options for the error reports. If no encryption option is specified, Timestream will choose SSE_S3 as default.
         */
        public var encryptionOption: aws.sdk.kotlin.services.timestreamquery.model.S3EncryptionOption? = null
        /**
         * Prefix for the error report key. Timestream by default adds the following prefix to the error report path.
         */
        public var objectKeyPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamquery.model.S3Configuration) : this() {
            this.bucketName = x.bucketName
            this.encryptionOption = x.encryptionOption
            this.objectKeyPrefix = x.objectKeyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamquery.model.S3Configuration = S3Configuration(this)

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            return this
        }
    }
}
