// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides insights into the table with the most sub-optimal spatial range scanned by your query.
 */
public class QuerySpatialCoverageMax private constructor(builder: Builder) {
    /**
     * The partition key used for partitioning, which can be a default `measure_name` or a [customer defined partition key](https://docs.aws.amazon.com/timestream/latest/developerguide/customer-defined-partition-keys.html).
     */
    public val partitionKey: List<String>? = builder.partitionKey
    /**
     * The Amazon Resource Name (ARN) of the table with the most sub-optimal spatial pruning.
     */
    public val tableArn: kotlin.String? = builder.tableArn
    /**
     * The maximum ratio of spatial coverage.
     */
    public val value: kotlin.Double = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverageMax = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QuerySpatialCoverageMax(")
        append("partitionKey=$partitionKey,")
        append("tableArn=$tableArn,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = partitionKey?.hashCode() ?: 0
        result = 31 * result + (tableArn?.hashCode() ?: 0)
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QuerySpatialCoverageMax

        if (partitionKey != other.partitionKey) return false
        if (tableArn != other.tableArn) return false
        if (!(value?.equals(other.value) ?: (other.value == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverageMax = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The partition key used for partitioning, which can be a default `measure_name` or a [customer defined partition key](https://docs.aws.amazon.com/timestream/latest/developerguide/customer-defined-partition-keys.html).
         */
        public var partitionKey: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the table with the most sub-optimal spatial pruning.
         */
        public var tableArn: kotlin.String? = null
        /**
         * The maximum ratio of spatial coverage.
         */
        public var value: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverageMax) : this() {
            this.partitionKey = x.partitionKey
            this.tableArn = x.tableArn
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverageMax = QuerySpatialCoverageMax(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
