// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides insights into the spatial coverage of the query, including the table with sub-optimal (max) spatial pruning. This information can help you identify areas for improvement in your partitioning strategy to enhance spatial pruning
 *
 * For example, you can do the following with the `QuerySpatialCoverage` information:
 * + Add measure_name or use [customer-defined partition key](https://docs.aws.amazon.com/timestream/latest/developerguide/customer-defined-partition-keys.html) (CDPK) predicates.
 * + If you've already done the preceding action, remove functions around them or clauses, such as `LIKE`.
 */
public class QuerySpatialCoverage private constructor(builder: Builder) {
    /**
     * Provides insights into the spatial coverage of the executed query and the table with the most inefficient spatial pruning.
     * + `Value` – The maximum ratio of spatial coverage.
     * + `TableArn` – The Amazon Resource Name (ARN) of the table with sub-optimal spatial pruning.
     * + `PartitionKey` – The partition key used for partitioning, which can be a default `measure_name` or a CDPK.
     */
    public val max: aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverageMax? = builder.max

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QuerySpatialCoverage(")
        append("max=$max")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = max?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QuerySpatialCoverage

        if (max != other.max) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverage = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Provides insights into the spatial coverage of the executed query and the table with the most inefficient spatial pruning.
         * + `Value` – The maximum ratio of spatial coverage.
         * + `TableArn` – The Amazon Resource Name (ARN) of the table with sub-optimal spatial pruning.
         * + `PartitionKey` – The partition key used for partitioning, which can be a default `measure_name` or a CDPK.
         */
        public var max: aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverageMax? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverage) : this() {
            this.max = x.max
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverage = QuerySpatialCoverage(this)

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverageMax] inside the given [block]
         */
        public fun max(block: aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverageMax.Builder.() -> kotlin.Unit) {
            this.max = aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverageMax.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
