// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.model

import aws.smithy.kotlin.runtime.SdkDsl

public class QueryResponse private constructor(builder: Builder) {
    /**
     * The column data types of the returned result set.
     */
    public val columnInfo: List<ColumnInfo> = requireNotNull(builder.columnInfo) { "A non-null value must be provided for columnInfo" }
    /**
     * A pagination token that can be used again on a `Query` call to get the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * A unique ID for the given query.
     */
    public val queryId: kotlin.String = requireNotNull(builder.queryId) { "A non-null value must be provided for queryId" }
    /**
     * Encapsulates `QueryInsights` containing insights and metrics related to the query that you executed.
     */
    public val queryInsightsResponse: aws.sdk.kotlin.services.timestreamquery.model.QueryInsightsResponse? = builder.queryInsightsResponse
    /**
     * Information about the status of the query, including progress and bytes scanned.
     */
    public val queryStatus: aws.sdk.kotlin.services.timestreamquery.model.QueryStatus? = builder.queryStatus
    /**
     * The result set rows returned by the query.
     */
    public val rows: List<Row> = requireNotNull(builder.rows) { "A non-null value must be provided for rows" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamquery.model.QueryResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryResponse(")
        append("columnInfo=$columnInfo,")
        append("nextToken=$nextToken,")
        append("queryId=$queryId,")
        append("queryInsightsResponse=$queryInsightsResponse,")
        append("queryStatus=$queryStatus,")
        append("rows=$rows")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = columnInfo.hashCode()
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (queryId.hashCode())
        result = 31 * result + (queryInsightsResponse?.hashCode() ?: 0)
        result = 31 * result + (queryStatus?.hashCode() ?: 0)
        result = 31 * result + (rows.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryResponse

        if (columnInfo != other.columnInfo) return false
        if (nextToken != other.nextToken) return false
        if (queryId != other.queryId) return false
        if (queryInsightsResponse != other.queryInsightsResponse) return false
        if (queryStatus != other.queryStatus) return false
        if (rows != other.rows) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamquery.model.QueryResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The column data types of the returned result set.
         */
        public var columnInfo: List<ColumnInfo>? = null
        /**
         * A pagination token that can be used again on a `Query` call to get the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * A unique ID for the given query.
         */
        public var queryId: kotlin.String? = null
        /**
         * Encapsulates `QueryInsights` containing insights and metrics related to the query that you executed.
         */
        public var queryInsightsResponse: aws.sdk.kotlin.services.timestreamquery.model.QueryInsightsResponse? = null
        /**
         * Information about the status of the query, including progress and bytes scanned.
         */
        public var queryStatus: aws.sdk.kotlin.services.timestreamquery.model.QueryStatus? = null
        /**
         * The result set rows returned by the query.
         */
        public var rows: List<Row>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamquery.model.QueryResponse) : this() {
            this.columnInfo = x.columnInfo
            this.nextToken = x.nextToken
            this.queryId = x.queryId
            this.queryInsightsResponse = x.queryInsightsResponse
            this.queryStatus = x.queryStatus
            this.rows = x.rows
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamquery.model.QueryResponse = QueryResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.QueryInsightsResponse] inside the given [block]
         */
        public fun queryInsightsResponse(block: aws.sdk.kotlin.services.timestreamquery.model.QueryInsightsResponse.Builder.() -> kotlin.Unit) {
            this.queryInsightsResponse = aws.sdk.kotlin.services.timestreamquery.model.QueryInsightsResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.QueryStatus] inside the given [block]
         */
        public fun queryStatus(block: aws.sdk.kotlin.services.timestreamquery.model.QueryStatus.Builder.() -> kotlin.Unit) {
            this.queryStatus = aws.sdk.kotlin.services.timestreamquery.model.QueryStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (columnInfo == null) columnInfo = emptyList()
            if (queryId == null) queryId = ""
            if (rows == null) rows = emptyList()
            return this
        }
    }
}
