// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides various insights and metrics related to the query that you executed.
 */
public class QueryInsightsResponse private constructor(builder: Builder) {
    /**
     * Indicates the size of query result set in bytes. You can use this data to validate if the result set has changed as part of the query tuning exercise.
     */
    public val outputBytes: kotlin.Long? = builder.outputBytes
    /**
     * Indicates the total number of rows returned as part of the query result set. You can use this data to validate if the number of rows in the result set have changed as part of the query tuning exercise.
     */
    public val outputRows: kotlin.Long? = builder.outputRows
    /**
     * Provides insights into the spatial coverage of the query, including the table with sub-optimal (max) spatial pruning. This information can help you identify areas for improvement in your partitioning strategy to enhance spatial pruning.
     */
    public val querySpatialCoverage: aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverage? = builder.querySpatialCoverage
    /**
     * Indicates the number of tables in the query.
     */
    public val queryTableCount: kotlin.Long? = builder.queryTableCount
    /**
     * Provides insights into the temporal range of the query, including the table with the largest (max) time range. Following are some of the potential options for optimizing time-based pruning:
     * + Add missing time-predicates.
     * + Remove functions around the time predicates.
     * + Add time predicates to all the sub-queries.
     */
    public val queryTemporalRange: aws.sdk.kotlin.services.timestreamquery.model.QueryTemporalRange? = builder.queryTemporalRange
    /**
     * Indicates the partitions created by the `Unload` operation.
     */
    public val unloadPartitionCount: kotlin.Long? = builder.unloadPartitionCount
    /**
     * Indicates the size, in bytes, written by the `Unload` operation.
     */
    public val unloadWrittenBytes: kotlin.Long? = builder.unloadWrittenBytes
    /**
     * Indicates the rows written by the `Unload` query.
     */
    public val unloadWrittenRows: kotlin.Long? = builder.unloadWrittenRows

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamquery.model.QueryInsightsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryInsightsResponse(")
        append("outputBytes=$outputBytes,")
        append("outputRows=$outputRows,")
        append("querySpatialCoverage=$querySpatialCoverage,")
        append("queryTableCount=$queryTableCount,")
        append("queryTemporalRange=$queryTemporalRange,")
        append("unloadPartitionCount=$unloadPartitionCount,")
        append("unloadWrittenBytes=$unloadWrittenBytes,")
        append("unloadWrittenRows=$unloadWrittenRows")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = outputBytes?.hashCode() ?: 0
        result = 31 * result + (outputRows?.hashCode() ?: 0)
        result = 31 * result + (querySpatialCoverage?.hashCode() ?: 0)
        result = 31 * result + (queryTableCount?.hashCode() ?: 0)
        result = 31 * result + (queryTemporalRange?.hashCode() ?: 0)
        result = 31 * result + (unloadPartitionCount?.hashCode() ?: 0)
        result = 31 * result + (unloadWrittenBytes?.hashCode() ?: 0)
        result = 31 * result + (unloadWrittenRows?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryInsightsResponse

        if (outputBytes != other.outputBytes) return false
        if (outputRows != other.outputRows) return false
        if (querySpatialCoverage != other.querySpatialCoverage) return false
        if (queryTableCount != other.queryTableCount) return false
        if (queryTemporalRange != other.queryTemporalRange) return false
        if (unloadPartitionCount != other.unloadPartitionCount) return false
        if (unloadWrittenBytes != other.unloadWrittenBytes) return false
        if (unloadWrittenRows != other.unloadWrittenRows) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamquery.model.QueryInsightsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates the size of query result set in bytes. You can use this data to validate if the result set has changed as part of the query tuning exercise.
         */
        public var outputBytes: kotlin.Long? = null
        /**
         * Indicates the total number of rows returned as part of the query result set. You can use this data to validate if the number of rows in the result set have changed as part of the query tuning exercise.
         */
        public var outputRows: kotlin.Long? = null
        /**
         * Provides insights into the spatial coverage of the query, including the table with sub-optimal (max) spatial pruning. This information can help you identify areas for improvement in your partitioning strategy to enhance spatial pruning.
         */
        public var querySpatialCoverage: aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverage? = null
        /**
         * Indicates the number of tables in the query.
         */
        public var queryTableCount: kotlin.Long? = null
        /**
         * Provides insights into the temporal range of the query, including the table with the largest (max) time range. Following are some of the potential options for optimizing time-based pruning:
         * + Add missing time-predicates.
         * + Remove functions around the time predicates.
         * + Add time predicates to all the sub-queries.
         */
        public var queryTemporalRange: aws.sdk.kotlin.services.timestreamquery.model.QueryTemporalRange? = null
        /**
         * Indicates the partitions created by the `Unload` operation.
         */
        public var unloadPartitionCount: kotlin.Long? = null
        /**
         * Indicates the size, in bytes, written by the `Unload` operation.
         */
        public var unloadWrittenBytes: kotlin.Long? = null
        /**
         * Indicates the rows written by the `Unload` query.
         */
        public var unloadWrittenRows: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamquery.model.QueryInsightsResponse) : this() {
            this.outputBytes = x.outputBytes
            this.outputRows = x.outputRows
            this.querySpatialCoverage = x.querySpatialCoverage
            this.queryTableCount = x.queryTableCount
            this.queryTemporalRange = x.queryTemporalRange
            this.unloadPartitionCount = x.unloadPartitionCount
            this.unloadWrittenBytes = x.unloadWrittenBytes
            this.unloadWrittenRows = x.unloadWrittenRows
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamquery.model.QueryInsightsResponse = QueryInsightsResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverage] inside the given [block]
         */
        public fun querySpatialCoverage(block: aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverage.Builder.() -> kotlin.Unit) {
            this.querySpatialCoverage = aws.sdk.kotlin.services.timestreamquery.model.QuerySpatialCoverage.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.timestreamquery.model.QueryTemporalRange] inside the given [block]
         */
        public fun queryTemporalRange(block: aws.sdk.kotlin.services.timestreamquery.model.QueryTemporalRange.Builder.() -> kotlin.Unit) {
            this.queryTemporalRange = aws.sdk.kotlin.services.timestreamquery.model.QueryTemporalRange.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
