// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.timestreamquery.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * `QueryInsights` is a performance tuning feature that helps you optimize your queries, reducing costs and improving performance. With `QueryInsights`, you can assess the pruning efficiency of your queries and identify areas for improvement to enhance query performance. With `QueryInsights`, you can also analyze the effectiveness of your queries in terms of temporal and spatial pruning, and identify opportunities to improve performance. Specifically, you can evaluate how well your queries use time-based and partition key-based indexing strategies to optimize data retrieval. To optimize query performance, it's essential that you fine-tune both the temporal and spatial parameters that govern query execution.
 *
 * The key metrics provided by `QueryInsights` are `QuerySpatialCoverage` and `QueryTemporalRange`. `QuerySpatialCoverage` indicates how much of the spatial axis the query scans, with lower values being more efficient. `QueryTemporalRange` shows the time range scanned, with narrower ranges being more performant.
 *
 * **Benefits of QueryInsights**
 *
 * The following are the key benefits of using `QueryInsights`:
 * + **Identifying inefficient queries** – `QueryInsights` provides information on the time-based and attribute-based pruning of the tables accessed by the query. This information helps you identify the tables that are sub-optimally accessed.
 * + **Optimizing your data model and partitioning** – You can use the `QueryInsights` information to access and fine-tune your data model and partitioning strategy.
 * + **Tuning queries** – `QueryInsights` highlights opportunities to use indexes more effectively.
 *
 * The maximum number of `Query` API requests you're allowed to make with `QueryInsights` enabled is 1 query per second (QPS). If you exceed this query rate, it might result in throttling.
 */
public class QueryInsights private constructor(builder: Builder) {
    /**
     * Provides the following modes to enable `QueryInsights`:
     * + `ENABLED_WITH_RATE_CONTROL` – Enables `QueryInsights` for the queries being processed. This mode also includes a rate control mechanism, which limits the `QueryInsights` feature to 1 query per second (QPS).
     * + `DISABLED` – Disables `QueryInsights`.
     */
    public val mode: aws.sdk.kotlin.services.timestreamquery.model.QueryInsightsMode = requireNotNull(builder.mode) { "A non-null value must be provided for mode" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.timestreamquery.model.QueryInsights = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryInsights(")
        append("mode=$mode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = mode.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryInsights

        if (mode != other.mode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.timestreamquery.model.QueryInsights = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Provides the following modes to enable `QueryInsights`:
         * + `ENABLED_WITH_RATE_CONTROL` – Enables `QueryInsights` for the queries being processed. This mode also includes a rate control mechanism, which limits the `QueryInsights` feature to 1 query per second (QPS).
         * + `DISABLED` – Disables `QueryInsights`.
         */
        public var mode: aws.sdk.kotlin.services.timestreamquery.model.QueryInsightsMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.timestreamquery.model.QueryInsights) : this() {
            this.mode = x.mode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.timestreamquery.model.QueryInsights = QueryInsights(this)

        internal fun correctErrors(): Builder {
            if (mode == null) mode = QueryInsightsMode.SdkUnknown("no value provided")
            return this
        }
    }
}
